/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.virtualization.util;

import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProtectionToolsUtil {
    private static final Log logger = LogFactory.getInstance(ProtectionToolsUtil.class);
    private static ProtectionToolsUtil instance = new ProtectionToolsUtil();

    private ProtectionToolsUtil() {
    }

    public static ProtectionToolsUtil getInstance() {
        return instance;
    }

    public void checkBuildProtectObjectsParam(ProtectGroup protectGroup) {
        if (null == protectGroup) {
            logger.error((Object)"protectGroup is empty", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            logger.error((Object)"protectObjects is empty", 90160758787071L);
            throw new LegoCheckedException(1073948166L);
        }
    }

    public void checkProtectObjectNumber(ProtectGroup protectGroup, int maxNum) {
        logger.debug((Object)"checkProtectObjectNumber start, protectGroup name=%s", new Object[]{protectGroup.getName()});
        if (!VerifyUtil.isEmpty((Collection)protectGroup.getPolist()) && protectGroup.getPolist().size() > maxNum) {
            throw new LegoCheckedException(1073948163L);
        }
    }

    public Map<String, TaskResultItem> getResultItemMap(MessageEvent event) {
        if (VerifyUtil.isEmpty((Map)event.getMessageMap())) {
            return new HashMap<String, TaskResultItem>();
        }
        Set resultItemSet = (Set)event.getMessageMap().get("TASK_RESULT_ITEM_LIST_KEY");
        if (VerifyUtil.isEmpty((Collection)resultItemSet)) {
            return new HashMap<String, TaskResultItem>();
        }
        HashMap<String, TaskResultItem> resultItemMap = new HashMap<String, TaskResultItem>();
        for (TaskResultItem item : resultItemSet) {
            if (VerifyUtil.isEmpty((String)item.getResId())) {
                logger.info((Object)("the TaskResultItem is empty:resName=" + item.getResName()));
                continue;
            }
            resultItemMap.put(item.getResId(), item);
        }
        return resultItemMap;
    }

    public static Set<ProtectObject> removeProtectObjects(Set<String> allVmsInPg, ProtectGroup protectGroup) {
        Set poSet = protectGroup.getPolist();
        HashSet<ProtectObject> poToBeDeleted = new HashSet<ProtectObject>();
        HashSet<String> pgVmUuidSet = new HashSet<String>();
        for (ProtectObject po : poSet) {
            if (!allVmsInPg.contains(po.getMoUuid())) {
                poToBeDeleted.add(po);
                continue;
            }
            pgVmUuidSet.add(po.getMoUuid());
        }
        if (!VerifyUtil.isEmpty(poToBeDeleted)) {
            protectGroup.getPolist().removeAll(poToBeDeleted);
        }
        allVmsInPg.removeAll(pgVmUuidSet);
        for (String vmUuid : allVmsInPg) {
            ProtectObject po = new ProtectObject();
            po.setMoUuid(vmUuid);
            po.setUuid(UUIDGenerator.getUUID());
            protectGroup.addProtectObject(po);
        }
        return poToBeDeleted;
    }
}

