/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.virtualization.util;

import com.huawei.ism.drm.license.LicenseOverflowStackControl;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;

public final class VirtualizationCommonUtil {
    private static final Log logger = LogFactory.getInstance(VirtualizationCommonUtil.class);
    private static VirtualizationCommonUtil instance = new VirtualizationCommonUtil();

    private VirtualizationCommonUtil() {
    }

    public static VirtualizationCommonUtil getInstance() {
        return instance;
    }

    public <T> T getElementFromCollection(Collection<T> collection) {
        if (null == collection || collection.isEmpty()) {
            logger.error((Object)"collection is null or is empty");
            throw new LegoCheckedException(1073947393L);
        }
        return collection.iterator().next();
    }

    public void overflowStackLicense(int type, int newPoCount) {
        String typeLicStr;
        logger.debug((Object)("new po count is " + newPoCount));
        switch (type) {
            case 25: {
                typeLicStr = "LSTQCSHA";
                break;
            }
            case 29: {
                typeLicStr = "LSTQVHA";
                break;
            }
            case 21: 
            case 22: {
                typeLicStr = "LSTQCSDR";
                break;
            }
            case 34: {
                typeLicStr = "LSTQVHA_CSDR";
                break;
            }
            case 37: {
                typeLicStr = "LSTQCSHA_CSDR";
                break;
            }
            default: {
                typeLicStr = "LSTQDPMP";
            }
        }
        LicenseOverflowStackControl licenseCtr = LicenseOverflowStackControl.getInstance();
        licenseCtr.checkLicenseEnable(typeLicStr, newPoCount);
    }

    public void checkLicense(int type, int newPoCount) {
        String typeLicStr;
        logger.debug((Object)("new po count is " + newPoCount));
        if (newPoCount <= 0) {
            return;
        }
        switch (type) {
            case 25: {
                typeLicStr = "LSTQCSHA";
                break;
            }
            case 29: {
                typeLicStr = "LSTQVHA";
                break;
            }
            case 21: 
            case 22: {
                typeLicStr = "LSTQCSDR";
                break;
            }
            default: {
                typeLicStr = "LSTQDPMP";
            }
        }
        ILicenseControl licenseCtr = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        licenseCtr.checkLicenseEnable(typeLicStr, newPoCount);
    }
}

