/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.dcs;

import com.huawei.csr.app.dcs.constants.DcsCsrDefaultAction;
import com.huawei.csr.app.dcs.service.DcsService;
import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.plugin.ServiceInstanceFilter;
import com.huawei.csr.framework.core.identifier.AppIdentifier;
import com.huawei.csr.framework.core.manager.AbstractAppManager;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class DcsManager
extends AbstractAppManager {
    private static final Log LOG = LogFactory.getInstance(DcsManager.class);
    private DcsService dcsService;

    public DcsManager() {
        this.setAppIdentifier(new AppIdentifier(ServiceType.DCS.getValue()));
    }

    public AppServiceInstance getProtectServiceInstance(String instanceId, Credential credential) throws ResponseException, ClientException, IOException {
        return this.dcsService.getProtectServiceInstance(instanceId, credential);
    }

    public List<AppServiceInstance> canProtectServiceInstances(ServiceInstanceFilter filter, Credential credential) throws ResponseException, ClientException, IOException {
        return this.dcsService.queryServiceInstances(filter, credential);
    }

    public boolean isProtectableServiceInstance(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        return this.dcsService.isProtectableServiceInstance(serviceInstanceId, credential);
    }

    public Optional<RecoverStepAction> getServiceInstanceDefaultAction(RecoverOperateType csrOperationType) {
        if (VerifyUtil.isEmpty((Object)((Object)DcsCsrDefaultAction.from(csrOperationType)))) {
            LOG.error((Object)"DcsCsrDefaultAction not exist with OperationType '%s'", new Object[]{csrOperationType});
            throw new LegoCheckedException(1073952404L);
        }
        return Optional.ofNullable(DcsCsrDefaultAction.from(csrOperationType).getDefaultAction());
    }

    public DcsService getDcsService() {
        return this.dcsService;
    }

    public void setDcsService(DcsService dcsService) {
        this.dcsService = dcsService;
    }
}

