/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.dcs.constants;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import java.util.Arrays;

public enum DcsCsrDefaultAction {
    PLANNED_MIGRATION(RecoverOperateType.PLANNED_MIGRATION, RecoverStepAction.SWITCHOVER),
    DISASTER_RECOVERY(RecoverOperateType.DISASTER_RECOVERY, RecoverStepAction.CHECK_PD_STATUS),
    REPROTECT(RecoverOperateType.REPROTECT, RecoverStepAction.CHECK_INSTANCE),
    SWITCHBACK(RecoverOperateType.SWITCHBACK, RecoverStepAction.SWITCHOVER);

    private final RecoverOperateType csrOpType;
    private final RecoverStepAction defaultAction;

    private DcsCsrDefaultAction(RecoverOperateType csrOpType, RecoverStepAction defaultAction) {
        this.csrOpType = csrOpType;
        this.defaultAction = defaultAction;
    }

    public RecoverOperateType getCsrOpType() {
        return this.csrOpType;
    }

    public RecoverStepAction getDefaultAction() {
        return this.defaultAction;
    }

    @JsonCreator
    public static DcsCsrDefaultAction from(RecoverOperateType operateType) {
        return Arrays.stream(DcsCsrDefaultAction.values()).filter(em -> em.csrOpType.equals((Object)operateType)).findFirst().orElse(null);
    }
}

