/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.dcs.constants;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huawei.csr.framework.common.statusopt.status.ServiceInstanceStatus;
import java.util.Arrays;

public enum InstanceInfoStatus {
    CREATING("CREATING", ServiceInstanceStatus.CREATING, false),
    RUNNING("RUNNING", ServiceInstanceStatus.NORMAL, true),
    CREATFAILED("CREATEFAILED", ServiceInstanceStatus.ERROR, false),
    ERROR("ERROR", ServiceInstanceStatus.ERROR, false),
    RESTARTING("RESTARTING", ServiceInstanceStatus.MAINTAIN, false),
    EXTENDING("EXTENDING", ServiceInstanceStatus.MAINTAIN, false),
    FLUSHING("FLUSHING", ServiceInstanceStatus.MAINTAIN, false),
    FROZEN("FROZEN", ServiceInstanceStatus.MAINTAIN, false),
    RESTORING("RESTORING", ServiceInstanceStatus.MAINTAIN, false),
    SOFTDELETE("SOFTDELETE", ServiceInstanceStatus.MAINTAIN, false);

    private final String status;
    private final ServiceInstanceStatus csrStatus;
    private final Boolean isProtectable;

    private InstanceInfoStatus(String status, ServiceInstanceStatus csrStatus, Boolean isProtectable) {
        this.status = status;
        this.csrStatus = csrStatus;
        this.isProtectable = isProtectable;
    }

    @JsonValue
    public String getStatus() {
        return this.status;
    }

    public Boolean getProtectable() {
        return this.isProtectable;
    }

    public ServiceInstanceStatus getCsrStatus() {
        return this.csrStatus;
    }

    @JsonCreator
    public static InstanceInfoStatus from(String value) {
        return Arrays.stream(InstanceInfoStatus.values()).filter(em -> em.status.equalsIgnoreCase(value)).findFirst().orElse(null);
    }
}

