/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.dcs.executor;

import com.huawei.csr.app.dcs.constants.InstanceInfoStatus;
import com.huawei.csr.app.dcs.executor.SwitchoverExecutor;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.utils.EndpointUtil;
import com.huawei.csr.framework.core.executor.AbstractStepExecutor;
import com.huawei.csr.framework.core.executor.PollingStrategy;
import com.huawei.csr.framework.core.executor.StepExecuteContext;
import com.huawei.csr.framework.core.identifier.StepIdentifier;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.dcs.DcsClient;
import com.huawei.sdk.dcs.model.InstanceInfo;
import com.huawei.sdk.dcs.model.InstanceReplicationListInfo;
import com.huawei.sdk.dcs.model.response.ListGroupResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class CheckPdStatusExecutor
extends AbstractStepExecutor {
    private static final Log LOG = LogFactory.getInstance(SwitchoverExecutor.class);
    private PollingStrategy dcsPoller;

    public CheckPdStatusExecutor() {
        this.setStepIdentifier(new StepIdentifier(ServiceType.DCS.getValue(), RecoverStepAction.CHECK_PD_STATUS.getValue()));
    }

    public void work(RecoverStep step, StepExecuteContext executeContext) throws ResponseException, ClientException, IOException {
        AppServiceInstance serviceInstance = ((ServiceInstanceDao)ServiceLocator.getInstance().getService(ServiceInstanceDao.class)).getServiceInstanceById(step.getServiceInstanceId());
        Credential credential = new Credential(executeContext.getRequestContext().getProjectId(), executeContext.getRequestContext().getAuthToken(), EndpointUtil.getEndpoint((String)step.getServiceType(), (String)serviceInstance.getPdRegionId()));
        DcsClient client = (DcsClient)ServiceLocator.getInstance().getService(DcsClient.class);
        this.dcsPoller.executePoller(executeContext, context -> {
            InstanceInfo instanceInfo = client.getInstance(serviceInstance.getInstanceId(), credential);
            if (VerifyUtil.isEmpty((Object)instanceInfo)) {
                LOG.error((Object)"Step(%s) is not reqiure execution conditions, instanceId: %s", new Object[]{step.getName(), step.getServiceInstanceId()});
                throw new LegoCheckedException(1073953000L);
            }
            List<InstanceReplicationListInfo> instanceReplicationListInfos = this.getInstanceReplicationListInfos(credential, client, instanceInfo);
            List instanceReplicationListInfoList = instanceReplicationListInfos.stream().filter(instanceReplicationListInfo -> instanceReplicationListInfo.getStatus().equals("Active") && instanceReplicationListInfo.getReplicationRole().equals("master")).collect(Collectors.toList());
            return instanceReplicationListInfoList != null && instanceReplicationListInfoList.size() >= 1 && instanceInfo.getStatus().equals(InstanceInfoStatus.RUNNING.getStatus());
        });
    }

    private List<InstanceReplicationListInfo> getInstanceReplicationListInfos(Credential credential, DcsClient client, InstanceInfo instanceInfo) throws ResponseException, ClientException, IOException {
        ListGroupResponse listGroupResponse = client.getGroupReplicationInfo(credential, instanceInfo.getInstanceId());
        List instanceReplicationListInfos = listGroupResponse.getGroupList().stream().map(instanceGroupListInfo -> instanceGroupListInfo.getReplicationList()).findFirst().orElse(null);
        if (instanceReplicationListInfos == null) {
            LOG.error((Object)"InstanceReplicationListInfos is null.");
            throw new LegoCheckedException(1073953000L);
        }
        return instanceReplicationListInfos;
    }

    public PollingStrategy getDcsPoller() {
        return this.dcsPoller;
    }

    public void setDcsPoller(PollingStrategy dcsPoller) {
        this.dcsPoller = dcsPoller;
    }
}

