/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.dcs.service;

import com.huawei.csr.app.dcs.constants.InstanceInfoStatus;
import com.huawei.csr.app.dcs.service.DcsService;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.plugin.ServiceInstanceFilter;
import com.huawei.csr.framework.common.statusopt.status.ReplicaStatus;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.dcs.DcsClient;
import com.huawei.sdk.dcs.model.InstanceInfo;
import com.huawei.sdk.dcs.model.InstanceReplicationListInfo;
import com.huawei.sdk.dcs.model.request.ListInstancesRequest;
import com.huawei.sdk.dcs.model.response.ListGroupResponse;
import com.huawei.sdk.dcs.model.response.ListInstancesResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DcsServiceImpl
implements DcsService {
    private static final Log LOG = LogFactory.getInstance(DcsServiceImpl.class);
    private DcsClient dcsClient;

    @Override
    public AppServiceInstance getProtectServiceInstance(String instanceId, Credential credential) throws ResponseException, ClientException, IOException {
        LOG.debug((Object)"Start isProtectableServiceInstance, instanceId: %s, projectId: %s, endpoint: %s", new Object[]{instanceId, credential.getProjectId(), credential.getEndpoint()});
        InstanceInfo instance = this.dcsClient.getInstance(instanceId, credential);
        return this.convert2ServiceInstance(instance, credential);
    }

    @Override
    public boolean isProtectableServiceInstance(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        LOG.debug((Object)"Start isProtectableServiceInstance, serviceInstanceId: %s, projectId: %s, endpoint: %s", new Object[]{serviceInstanceId, credential.getProjectId(), credential.getEndpoint()});
        InstanceInfo instance = this.dcsClient.getInstance(serviceInstanceId, credential);
        return this.isProtectableServiceInstance(instance);
    }

    private boolean isProtectableServiceInstance(InstanceInfo instanceInfo) {
        return !VerifyUtil.isEmpty((Object)instanceInfo) && InstanceInfoStatus.from(instanceInfo.getStatus()) != null && InstanceInfoStatus.from(instanceInfo.getStatus()).getProtectable() != false;
    }

    @Override
    public List<AppServiceInstance> queryServiceInstances(ServiceInstanceFilter filter, Credential credential) throws ResponseException, ClientException, IOException {
        if (!this.checkRegionAz(filter)) {
            LOG.error((Object)"CheckRegionAz error,pdRegionId: %s, drRegionId: %s, pdAzId: %s, drAzId:%s", new Object[]{filter.getPdRegionId(), filter.getDrRegionId(), filter.getPdAzId(), filter.getDrAzId()});
            return Collections.emptyList();
        }
        LOG.debug((Object)"Start queryServiceInstances, pdRegionId: %s, drRegionId: %s,", new Object[]{filter.getPdRegionId(), filter.getDrRegionId()});
        LOG.debug((Object)"Start queryServiceInstances, pdAzId: %s, drAzId:%s, projectId: %s, endpoint: %s", new Object[]{filter.getPdAzId(), filter.getDrAzId(), credential.getProjectId(), credential.getEndpoint()});
        ListInstancesRequest instancesRequest = new ListInstancesRequest();
        int offset = 0;
        int limit = 1000;
        ArrayList<AppServiceInstance> resultList = new ArrayList<AppServiceInstance>();
        while (true) {
            instancesRequest.setLimit(Integer.valueOf(limit));
            instancesRequest.setOffset(Integer.valueOf(offset));
            instancesRequest.setName(filter.getInstanceName());
            ListInstancesResponse instancesResponse = this.dcsClient.listInstances(instancesRequest, credential);
            if (instancesResponse == null || instancesResponse.getInstanceNum() == null || instancesResponse.getInstanceNum() == 0 || VerifyUtil.isEmpty((Collection)instancesResponse.getInstances())) break;
            List instances = instancesResponse.getInstances();
            Stream<Object> stream = instances.stream();
            if (!VerifyUtil.isEmpty((String)filter.getInstanceId())) {
                stream = stream.filter(instanceInfo -> instanceInfo.getInstanceId().contains(filter.getInstanceId()));
            }
            List collect = stream.filter(this::isProtectableServiceInstance).filter(instanceInfo -> (long)instanceInfo.getAzCodes().size() == 2L).map(instanceInfo -> this.convert2ServiceInstance((InstanceInfo)instanceInfo, credential)).filter(instance -> instance.getPdAzId().equals(filter.getPdAzId())).filter(instance -> instance.getDrAzId().equals(filter.getDrAzId())).peek(instance -> {
                instance.setPdRegionId(filter.getPdRegionId());
                instance.setDrRegionId(filter.getDrRegionId());
                instance.setDrType(filter.getDrType().getValue());
            }).collect(Collectors.toList());
            resultList.addAll(collect);
            if (instancesResponse.getInstanceNum() < limit) break;
            instancesRequest.setOffset(Integer.valueOf(offset + limit));
        }
        return resultList;
    }

    private AppServiceInstance convert2ServiceInstance(InstanceInfo instanceInfo, Credential credential) {
        InstanceReplicationListInfo drReplicationListInfo;
        List<InstanceReplicationListInfo> instanceReplicationListInfos = this.getInstanceReplicationListInfos(credential, instanceInfo.getInstanceId());
        AppServiceInstance instance = new AppServiceInstance();
        instance.setInstanceName(instanceInfo.getName());
        instance.setInstanceId(instanceInfo.getInstanceId());
        instance.setStatus(InstanceInfoStatus.from(instanceInfo.getStatus()).getCsrStatus().getValue());
        instance.setInstanceAddress(instanceInfo.getIp());
        instance.setInstanceObjectCount(Integer.valueOf(1));
        instance.setServiceType(ServiceType.DCS.getValue());
        instance.setReplicaStatus(ReplicaStatus.NORMAL.getValue());
        InstanceReplicationListInfo pdReplicationListInfo = instanceReplicationListInfos.stream().filter(replicationListInfo -> replicationListInfo.getReplicationRole().equals("master")).findFirst().orElse(null);
        if (pdReplicationListInfo != null) {
            instance.setPdAzId(pdReplicationListInfo.getAzCode());
        }
        if ((drReplicationListInfo = (InstanceReplicationListInfo)instanceReplicationListInfos.stream().filter(replicationListInfo -> replicationListInfo.getReplicationRole().equals("slave")).findFirst().orElse(null)) != null) {
            instance.setDrAzId(drReplicationListInfo.getAzCode());
        }
        return instance;
    }

    private List<InstanceReplicationListInfo> getInstanceReplicationListInfos(Credential credential, String instanceId) {
        LOG.debug((Object)"Start getInstanceReplicationListInfos, instanceId: %s, projectId: %s, endpoint: %s", new Object[]{instanceId, credential.getProjectId(), credential.getEndpoint()});
        ListGroupResponse listGroupResponse = null;
        try {
            DcsClient client = (DcsClient)ServiceLocator.getInstance().getService(DcsClient.class);
            listGroupResponse = client.getGroupReplicationInfo(credential, instanceId);
        }
        catch (Exception e) {
            LOG.error((Object)"GetGroupReplicationInfo error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return Collections.EMPTY_LIST;
        }
        List instanceReplicationListInfos = listGroupResponse.getGroupList().stream().map(instanceGroupListInfo -> instanceGroupListInfo.getReplicationList()).findFirst().orElse(null);
        if (instanceReplicationListInfos == null) {
            LOG.error((Object)"InstanceReplicationListInfos is null.");
            return Collections.EMPTY_LIST;
        }
        return instanceReplicationListInfos;
    }

    private boolean checkRegionAz(ServiceInstanceFilter filter) {
        return !VerifyUtil.isEmpty((String)filter.getPdRegionId()) && !VerifyUtil.isEmpty((String)filter.getPdAzId()) && !VerifyUtil.isEmpty((String)filter.getDrRegionId()) && !VerifyUtil.isEmpty((String)filter.getDrAzId());
    }

    public DcsClient getDcsClient() {
        return this.dcsClient;
    }

    public void setDcsClient(DcsClient dcsClient) {
        this.dcsClient = dcsClient;
    }
}

