/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.elb;

import com.huawei.csr.app.elb.service.ElbService;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.plugin.ServiceInstanceFilter;
import com.huawei.csr.framework.core.identifier.AppIdentifier;
import com.huawei.csr.framework.core.manager.AbstractAppManager;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class ElbManager
extends AbstractAppManager {
    private static final Log LOGGER = LogFactory.getInstance(ElbManager.class);
    private ElbService elbService;

    public ElbManager() {
        this.setAppIdentifier(new AppIdentifier(ServiceType.ELB.getValue()));
    }

    public List<AppServiceInstance> canProtectServiceInstances(ServiceInstanceFilter filter, Credential credential) throws ResponseException, ClientException, IOException {
        return this.elbService.canProtectServiceInstances(credential, filter);
    }

    public boolean isProtectableServiceInstance(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        return this.elbService.isProtectableServiceInstance(serviceInstanceId, credential);
    }

    public AppServiceInstance getProtectServiceInstance(String instanceId, Credential credential) throws ResponseException, ClientException, IOException {
        return this.elbService.queryLoadBalancer(instanceId, credential);
    }

    public List<String> queryRelatedIps(String serviceInstanceId, Credential credential) {
        try {
            return this.elbService.queryMemberIps(serviceInstanceId, credential);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Query instance(%s) relatedVmIds failed; msg: %s ", new Object[]{serviceInstanceId, ExceptionUtil.getErrorMessage((Throwable)e)});
            return Collections.emptyList();
        }
    }

    public ElbService getElbService() {
        return this.elbService;
    }

    public void setElbService(ElbService elbService) {
        this.elbService = elbService;
    }
}

