/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.elb.service;

import com.huawei.csr.app.elb.constant.ElbStatus;
import com.huawei.csr.app.elb.service.ElbService;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.plugin.ServiceInstanceFilter;
import com.huawei.csr.framework.common.statusopt.status.ReplicaStatus;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.elb.ElbClient;
import com.huawei.sdk.elb.model.LoadBalancer;
import com.huawei.sdk.elb.model.Pools;
import com.huawei.sdk.elb.model.request.ListLoadBalancerRequest;
import com.huawei.sdk.elb.model.v3.Member;
import com.huawei.sdk.elb.model.v3.MemberResponseV3;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ElbServiceImpl
implements ElbService {
    private static final Log LOGGER = LogFactory.getInstance(ElbServiceImpl.class);
    private ElbClient elbClient;

    @Override
    public List<AppServiceInstance> canProtectServiceInstances(Credential credential, ServiceInstanceFilter filter) throws ResponseException, ClientException, IOException {
        LOGGER.debug((Object)"Start canProtectServiceInstances, pdRegionId: %s, drRegionId: %s, pdAzId: %s, drAzId:%s, projectId: %s, endpoint: %s", new Object[]{filter.getPdRegionId(), filter.getDrRegionId(), filter.getPdAzId(), filter.getDrAzId(), credential.getProjectId(), credential.getEndpoint()});
        if (!this.checkRegion(filter)) {
            LOGGER.error((Object)"CheckRegionAz error,pdRegionId: %s, drRegionId: %s, pdAzId: %s, drAzId:%s", new Object[]{filter.getPdRegionId(), filter.getDrRegionId(), filter.getPdAzId(), filter.getDrAzId()});
            return Collections.emptyList();
        }
        ListLoadBalancerRequest para = new ListLoadBalancerRequest();
        para.setName(filter.getInstanceName());
        para.setId(filter.getInstanceId());
        List loadBalancers = this.elbClient.queryLoadBalancerList(credential, para);
        Stream<Object> stream = loadBalancers.stream();
        if (!VerifyUtil.isEmpty((String)filter.getInstanceId())) {
            stream = stream.filter(loadBalancer -> loadBalancer.getId().contains(filter.getInstanceId()));
        }
        List<LoadBalancer> canProtectList = stream.filter(loadBalancer -> ElbStatus.from(loadBalancer.getProvisioningStatus()) != null && ElbStatus.from(loadBalancer.getProvisioningStatus()).getProtectable() != false).collect(Collectors.toList());
        return this.convert2serviceInstance(canProtectList, filter);
    }

    @Override
    public boolean isProtectableServiceInstance(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        LOGGER.debug((Object)"Start isProtectableServiceInstance, serviceInstanceId: %s, projectId: %s, endpoint: %s", new Object[]{serviceInstanceId, credential.getProjectId(), credential.getEndpoint()});
        LoadBalancer loadBalancerVo = this.elbClient.queryLoadBalancer(serviceInstanceId, credential);
        return ElbStatus.from(loadBalancerVo.getProvisioningStatus()) != null && ElbStatus.from(loadBalancerVo.getProvisioningStatus()).getProtectable() != false;
    }

    private List<AppServiceInstance> convert2serviceInstance(List<LoadBalancer> loadBalancerVos, ServiceInstanceFilter filter) {
        return loadBalancerVos.stream().map(this::generateServiceInstance).peek(serviceInstance -> {
            serviceInstance.setDrType(filter.getDrType().getValue());
            serviceInstance.setPdRegionId(filter.getPdRegionId());
        }).collect(Collectors.toList());
    }

    @Override
    public AppServiceInstance queryLoadBalancer(String loaderbalancerId, Credential credential) throws ResponseException, ClientException, IOException {
        LOGGER.debug((Object)"Start queryLoadBalancer, loaderbalancerId: %s, projectId: %s, endpoint: %s", new Object[]{loaderbalancerId, credential.getProjectId(), credential.getEndpoint()});
        LoadBalancer loadBalancer = this.elbClient.queryLoadBalancer(loaderbalancerId, credential);
        return this.generateServiceInstance(loadBalancer);
    }

    @Override
    public List<String> queryMemberIps(String serviceInstanceId, Credential credential) {
        LOGGER.debug((Object)"Start queryMemberIds, serviceInstanceId: %s, projectId: %s, endpoint: %s", new Object[]{serviceInstanceId, credential.getProjectId(), credential.getEndpoint()});
        try {
            LoadBalancer loadBalancer = this.elbClient.queryLoadBalancer(serviceInstanceId, credential);
            if (VerifyUtil.isEmpty((Object)loadBalancer) || VerifyUtil.isEmpty((Collection)loadBalancer.getPools())) {
                return Collections.emptyList();
            }
            return loadBalancer.getPools().stream().flatMap(pool -> this.queryMembers(credential, (Pools)pool)).map(Member::getAddress).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error((Object)"queryMemberIps failed instanceId is %s, msg: %s ", new Object[]{serviceInstanceId, ExceptionUtil.getErrorMessage((Throwable)e)});
            return Collections.emptyList();
        }
    }

    private Stream<Member> queryMembers(Credential credential, Pools pool) {
        try {
            MemberResponseV3 membersResponse = this.elbClient.queryMemberListV3(pool.getId(), null, credential);
            if (VerifyUtil.isEmpty((Object)membersResponse) || VerifyUtil.isEmpty((Collection)membersResponse.getExmembers())) {
                LOGGER.info((Object)"Response of query members is empty.");
                return Stream.empty();
            }
            return membersResponse.getExmembers().stream();
        }
        catch (Exception e) {
            LOGGER.error((Object)"queryMemberListV3 failed poolId is %s, msg: %s ", new Object[]{pool.getId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            return Stream.empty();
        }
    }

    private AppServiceInstance generateServiceInstance(LoadBalancer loadBalancerVo) {
        AppServiceInstance serviceInstance = new AppServiceInstance();
        serviceInstance.setInstanceName(loadBalancerVo.getName());
        serviceInstance.setInstanceId(loadBalancerVo.getId());
        serviceInstance.setStatus(ElbStatus.from(loadBalancerVo.getProvisioningStatus()).getCsrStatus().getValue());
        serviceInstance.setInstanceAddress(loadBalancerVo.getVipAddress());
        serviceInstance.setInstanceObjectCount(Integer.valueOf(1));
        serviceInstance.setReplicaStatus(ReplicaStatus.NORMAL.getValue());
        serviceInstance.setServiceType(ServiceType.ELB.getValue());
        return serviceInstance;
    }

    private boolean checkRegion(ServiceInstanceFilter filter) {
        return !VerifyUtil.isEmpty((String)filter.getPdRegionId());
    }

    public void setElbClient(ElbClient elbClient) {
        this.elbClient = elbClient;
    }
}

