/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.elb.topo;

import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.utils.EndpointUtil;
import com.huawei.csr.framework.core.identifier.AppIdentifier;
import com.huawei.csr.framework.core.manager.AppManager;
import com.huawei.csr.framework.core.manager.AppPluginManager;
import com.huawei.csr.framework.dao.model.TopoLink;
import com.huawei.csr.framework.dao.model.TopoNode;
import com.huawei.csr.framework.topo.build.AbstractTopoBuilder;
import com.huawei.csr.framework.topo.build.BuildContext;
import com.huawei.csr.framework.topo.build.TopoSource;
import com.huawei.csr.framework.topo.build.TopoSourceType;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.auth.util.AuthUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ElbTopoBuilder
extends AbstractTopoBuilder {
    private static final Log LOGGER = LogFactory.getInstance(AppPluginManager.class);

    public ElbTopoBuilder(String supportType, List<String> dependencies) {
        super(supportType, dependencies);
    }

    public void build(BuildContext context, TopoSource topoSource) {
        TopoNode node = this.buildCommonNode(topoSource, null);
        node.setEntity(topoSource.getResourceId() + ":" + TopoSourceType.ELB.getValue());
        context.addTopoNode(node);
        List<String> relatedIpList = this.getRelatedIpList(topoSource);
        HashSet relatedNodeIds = new HashSet();
        if (!VerifyUtil.isEmpty(relatedIpList)) {
            for (String ip : relatedIpList) {
                if (!context.getAddressMap().containsKey(ip)) continue;
                String[] ids = ((String)context.getAddressMap().get(ip)).split(",");
                Collections.addAll(relatedNodeIds, ids);
            }
        }
        for (String id : relatedNodeIds) {
            TopoLink topoLink = new TopoLink();
            topoLink.setProjectId(topoSource.getProjectId());
            topoLink.setApplicationId(topoSource.getApplicationId());
            topoLink.setSourceId(node.getId());
            topoLink.setTargetId(id);
            context.addTopoLink(topoLink);
        }
    }

    private List<String> getRelatedIpList(TopoSource topoSource) {
        String authToken;
        AppIdentifier appIdentifier = new AppIdentifier(ServiceType.ELB.getValue());
        AppManager manager = AppPluginManager.getInstance().getAppManager(appIdentifier);
        try {
            authToken = AuthUtil.getScopedAuthToken((String)topoSource.getProjectId());
        }
        catch (ClientException | ResponseException | IOException e) {
            LOGGER.error((Object)"Fetch authToken failed. msg:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return Collections.emptyList();
        }
        String endPoint = EndpointUtil.getEndpoint((String)TopoSourceType.ELB.getValue(), (String)topoSource.getPdRegionId());
        Credential credential = new Credential(topoSource.getProjectId(), authToken, endPoint);
        return manager.queryRelatedIps(topoSource.getResourceId(), credential);
    }
}

