/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.rds;

import com.huawei.csr.app.rds.constants.RdsCsrDefaultAction;
import com.huawei.csr.app.rds.service.RdsService;
import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.plugin.ServiceInstanceFilter;
import com.huawei.csr.framework.core.identifier.AppIdentifier;
import com.huawei.csr.framework.core.manager.AbstractAppManager;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class RdsManager
extends AbstractAppManager {
    private static final Log LOG = LogFactory.getInstance(RdsManager.class);
    private RdsService rdsService;

    public RdsManager() {
        this.setAppIdentifier(new AppIdentifier(ServiceType.RDS.getValue()));
    }

    public AppServiceInstance getProtectServiceInstance(String instanceId, Credential credential) throws ResponseException, ClientException, IOException {
        return this.rdsService.queryProtectServiceInstance(instanceId, credential);
    }

    public List<AppServiceInstance> canProtectServiceInstances(ServiceInstanceFilter filter, Credential credential) throws ResponseException, ClientException, IOException {
        return this.rdsService.queryCanProtectServiceInstants(filter, credential);
    }

    public boolean isProtectableServiceInstance(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        return this.rdsService.isProtectableServiceInstance(serviceInstanceId, credential);
    }

    public Optional<RecoverStepAction> getServiceInstanceDefaultAction(RecoverOperateType csrOperationType) {
        if (VerifyUtil.isEmpty((Object)((Object)RdsCsrDefaultAction.from(csrOperationType)))) {
            LOG.error((Object)"RdsCsrDefaultAction not exist with OperationType '%s'", new Object[]{csrOperationType});
            throw new LegoCheckedException(1073952404L);
        }
        return Optional.ofNullable(RdsCsrDefaultAction.from(csrOperationType).getDefaultAction());
    }

    public RdsService getRdsService() {
        return this.rdsService;
    }

    public void setRdsService(RdsService rdsService) {
        this.rdsService = rdsService;
    }
}

