/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.rds.constants;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import java.util.Arrays;

public enum RdsCsrDefaultAction {
    PLANNED_MIGRATION(RecoverOperateType.PLANNED_MIGRATION, RecoverStepAction.SWITCHOVER),
    DISASTER_RECOVERY(RecoverOperateType.DISASTER_RECOVERY, RecoverStepAction.CHECK_PD_STATUS),
    REPROTECT(RecoverOperateType.REPROTECT, RecoverStepAction.CHECK_INSTANCE),
    SWITCHBACK(RecoverOperateType.SWITCHBACK, RecoverStepAction.SWITCHOVER);

    private final RecoverOperateType csrOpType;
    private final RecoverStepAction defaultAction;

    private RdsCsrDefaultAction(RecoverOperateType csrOpType, RecoverStepAction defaultAction) {
        this.csrOpType = csrOpType;
        this.defaultAction = defaultAction;
    }

    public RecoverOperateType getCsrOpType() {
        return this.csrOpType;
    }

    public RecoverStepAction getDefaultAction() {
        return this.defaultAction;
    }

    @JsonCreator
    public static RdsCsrDefaultAction from(RecoverOperateType operateType) {
        return Arrays.stream(RdsCsrDefaultAction.values()).filter(em -> em.csrOpType.equals((Object)operateType)).findFirst().orElse(null);
    }
}

