/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.rds.constants;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.huawei.csr.framework.common.statusopt.status.ServiceInstanceStatus;
import java.util.Arrays;
import java.util.Optional;

public enum RdsInstanceStatus {
    BUILD("BUILD", ServiceInstanceStatus.CREATING, false),
    ACTIVE("ACTIVE", ServiceInstanceStatus.NORMAL, true),
    STORAGE_FULL("STORAGE FULL", ServiceInstanceStatus.NORMAL, true),
    FAILED("FAILED", ServiceInstanceStatus.ERROR, false),
    MODIFYING("MODIFYING", ServiceInstanceStatus.MAINTAIN, false),
    REBOOTING("REBOOTING", ServiceInstanceStatus.MAINTAIN, false),
    RESTORING("RESTORING", ServiceInstanceStatus.MAINTAIN, false),
    MODIFYING_INSTANCE_TYPE("MODIFYING INSTANCE TYPE", ServiceInstanceStatus.MAINTAIN, false),
    SWITCHOVER("SWITCHOVER", ServiceInstanceStatus.MAINTAIN, false),
    MIGRATING("MIGRATING", ServiceInstanceStatus.MAINTAIN, false),
    BACKING_UP("BACKING UP", ServiceInstanceStatus.MAINTAIN, false),
    MODIFYING_DATABASE_PORT("MODIFYING DATABASE PORT", ServiceInstanceStatus.MAINTAIN, false),
    FROZEN("FROZEN", ServiceInstanceStatus.MAINTAIN, true);

    private final String status;
    private final ServiceInstanceStatus csrStatus;
    private final boolean isSteady;

    private RdsInstanceStatus(String status, ServiceInstanceStatus csrStatus, boolean isSteady) {
        this.status = status;
        this.csrStatus = csrStatus;
        this.isSteady = isSteady;
    }

    public String getStatus() {
        return this.status;
    }

    public ServiceInstanceStatus getCsrStatus() {
        return this.csrStatus;
    }

    public boolean getSteady() {
        return this.isSteady;
    }

    @JsonCreator
    public static Optional<RdsInstanceStatus> from(String value) {
        return Arrays.stream(RdsInstanceStatus.values()).filter(em -> em.status.equalsIgnoreCase(value)).findFirst();
    }
}

