/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.rds.executor;

import com.huawei.csr.framework.common.utils.EndpointUtil;
import com.huawei.csr.framework.core.executor.AbstractStepExecutor;
import com.huawei.csr.framework.core.executor.PollingStrategy;
import com.huawei.csr.framework.core.executor.StepExecuteContext;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.rds.RdsClient;
import com.huawei.sdk.rds.model.Instance;
import com.huawei.sdk.rds.model.request.ListInstancesRequest;
import com.huawei.sdk.rds.model.response.ListInstancesResponse;
import java.io.IOException;
import java.util.Collection;

public abstract class AbstractCheckStatusExecutor
extends AbstractStepExecutor {
    private PollingStrategy pollingStrategy;

    public void work(RecoverStep step, StepExecuteContext executeContext) throws ResponseException, ClientException, IOException {
        AppServiceInstance serviceInstance = ((ServiceInstanceDao)ServiceLocator.getInstance().getService(ServiceInstanceDao.class)).getServiceInstanceById(step.getServiceInstanceId());
        Credential credential = new Credential(executeContext.getRequestContext().getProjectId(), executeContext.getRequestContext().getAuthToken(), EndpointUtil.getEndpoint((String)step.getServiceType(), (String)serviceInstance.getPdRegionId()));
        RdsClient client = (RdsClient)ServiceLocator.getInstance().getService(RdsClient.class);
        ListInstancesRequest request = new ListInstancesRequest();
        request.setId(serviceInstance.getInstanceId());
        this.pollingStrategy.executePoller(executeContext, context -> {
            ListInstancesResponse instancesResponse = client.listInstances(request, credential);
            if (VerifyUtil.isEmpty((Collection)instancesResponse.getInstances())) {
                throw new LegoCheckedException(1073952404L, "Instance of rds is not exist.");
            }
            Instance instance = (Instance)instancesResponse.getInstances().get(0);
            return this.checkNodeStatus(instance);
        });
    }

    protected abstract boolean checkNodeStatus(Instance var1);

    public void setPollingStrategy(PollingStrategy pollingStrategy) {
        this.pollingStrategy = pollingStrategy;
    }
}

