/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.rds.executor;

import com.huawei.csr.framework.common.constants.RecoverOperateType;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.utils.EndpointUtil;
import com.huawei.csr.framework.core.executor.AbstractStepExecutor;
import com.huawei.csr.framework.core.executor.PollingStrategy;
import com.huawei.csr.framework.core.executor.StepExecuteContext;
import com.huawei.csr.framework.core.identifier.StepIdentifier;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.csr.framework.service.ConfigService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.rds.RdsClient;
import com.huawei.sdk.rds.common.InstanceStatus;
import com.huawei.sdk.rds.common.NodeRole;
import com.huawei.sdk.rds.model.Instance;
import com.huawei.sdk.rds.model.JobInfo;
import com.huawei.sdk.rds.model.Node;
import com.huawei.sdk.rds.model.request.ListInstancesRequest;
import com.huawei.sdk.rds.model.response.ListInstancesResponse;
import com.huawei.sdk.rds.model.response.ListJobInfoResponse;
import com.huawei.sdk.rds.model.response.StartFailoverResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SwitchoverExecutor
extends AbstractStepExecutor {
    private static final Log LOG = LogFactory.getInstance(SwitchoverExecutor.class);
    private PollingStrategy pollingStrategy;

    public SwitchoverExecutor() {
        this.setStepIdentifier(new StepIdentifier(ServiceType.RDS.getValue(), RecoverStepAction.SWITCHOVER.getValue()));
    }

    public void work(RecoverStep step, StepExecuteContext executeContext) throws ResponseException, ClientException, IOException {
        AppServiceInstance serviceInstance = ((ServiceInstanceDao)ServiceLocator.getInstance().getService(ServiceInstanceDao.class)).getServiceInstanceById(step.getServiceInstanceId());
        Credential credential = new Credential(executeContext.getRequestContext().getProjectId(), executeContext.getRequestContext().getAuthToken(), EndpointUtil.getEndpoint((String)step.getServiceType(), (String)serviceInstance.getPdRegionId()));
        RdsClient client = (RdsClient)ServiceLocator.getInstance().getService(RdsClient.class);
        ListInstancesRequest request = new ListInstancesRequest();
        request.setId(serviceInstance.getInstanceId());
        ListInstancesResponse instancesResponse = client.listInstances(request, credential);
        if (VerifyUtil.isEmpty((Collection)instancesResponse.getInstances())) {
            LOG.error((Object)"Instance of rds is not exists. id: %s", new Object[]{serviceInstance.getInstanceId()});
            throw new LegoCheckedException(1073953200L);
        }
        Instance instance = (Instance)instancesResponse.getInstances().get(0);
        if (!this.needExecute(instance, executeContext)) {
            return;
        }
        StartFailoverResponse failoverResponse = client.startFailover(serviceInstance.getProjectId(), serviceInstance.getInstanceId(), credential);
        String taskId = failoverResponse.getWorkflowId();
        this.pollingStrategy.executePoller(executeContext, context -> {
            ListJobInfoResponse jobResponse = client.listJobInfo(step.getProjectId(), taskId, credential);
            JobInfo.StatusEnum status = jobResponse.getJob().getStatus();
            if (JobInfo.StatusEnum.FAILED.equals((Object)status)) {
                LOG.error((Object)"Execute switchover of rds failed. %s", new Object[]{jobResponse.getJob().getFailReason()});
                throw new LegoCheckedException(1073953201L);
            }
            return JobInfo.StatusEnum.COMPLETED.equals((Object)status);
        });
    }

    private boolean needExecute(Instance instance, StepExecuteContext executeContext) {
        if (!InstanceStatus.ACTIVE.getValue().equals(instance.getStatus())) {
            LOG.error((Object)"Instance status is not active.");
            return false;
        }
        Node masterNode = null;
        for (Node node : instance.getNodes()) {
            if (!NodeRole.MASTER.getValue().equals(node.getRole())) continue;
            masterNode = node;
            break;
        }
        if (VerifyUtil.isEmpty(masterNode)) {
            return false;
        }
        String expectRegionAz = instance.getRegion() + masterNode.getAvailabilityZone();
        Set<String> regionAzSet = this.getRegionAzSet(executeContext.getOptSiteId());
        boolean plannedExpect = RecoverOperateType.PLANNED_MIGRATION.equals((Object)executeContext.getRecoverOperateType()) && regionAzSet.contains(expectRegionAz);
        boolean switchbackExpect = RecoverOperateType.SWITCHBACK.equals((Object)executeContext.getRecoverOperateType()) && !regionAzSet.contains(expectRegionAz);
        return plannedExpect || switchbackExpect;
    }

    private Set<String> getRegionAzSet(String siteId) {
        List siteInfos = ((ConfigService)ServiceLocator.getInstance().getService(ConfigService.class)).getSiteInfos(siteId);
        return siteInfos.stream().map(item -> item.getRegionId() + item.getAzId()).collect(Collectors.toSet());
    }

    public void setPollingStrategy(PollingStrategy pollingStrategy) {
        this.pollingStrategy = pollingStrategy;
    }
}

