/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.rds.service;

import com.huawei.csr.app.rds.constants.RdsInstanceStatus;
import com.huawei.csr.app.rds.service.RdsService;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.plugin.ServiceInstanceFilter;
import com.huawei.csr.framework.common.statusopt.status.ReplicaStatus;
import com.huawei.csr.framework.common.statusopt.status.ServiceInstanceStatus;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.rds.RdsClient;
import com.huawei.sdk.rds.common.NodeRole;
import com.huawei.sdk.rds.model.Instance;
import com.huawei.sdk.rds.model.Node;
import com.huawei.sdk.rds.model.request.ListInstancesRequest;
import com.huawei.sdk.rds.model.response.ListInstancesResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RdsServiceImpl
implements RdsService {
    private static final Log LOG = LogFactory.getInstance(RdsServiceImpl.class);
    private static final int MIN_AZ_NUM = 2;
    private static final List<String> INSTANT_PROTECTABLE_STATE_LIST = Arrays.asList("ACTIVE", "FROZEN", "STORAGE FULL");
    private static final String INSTANT_PROTECTABLE_TYPE = "Ha";
    private static final String INSTANT_PROTECTABLE_DATASTORE_TYPE = "MySQL";
    private static final int DEFAULT_RDS_LIST_INSTANCES_API_LIMIT = 100;
    private RdsClient rdsClient;

    @Override
    public List<AppServiceInstance> queryCanProtectServiceInstants(ServiceInstanceFilter filter, Credential credential) throws ResponseException, ClientException, IOException {
        ListInstancesResponse listInstancesResponse;
        if (VerifyUtil.isMultiEmpty((Object[])new Object[]{filter, credential})) {
            LOG.error((Object)"Parameter empty.");
            throw new LegoCheckedException(1073952400L);
        }
        if (!this.checkRegionAz(filter)) {
            LOG.error((Object)"CheckRegionAz error,pdRegionId: %s, drRegionId: %s, pdAzId: %s, drAzId:%s", new Object[]{filter.getPdRegionId(), filter.getDrRegionId(), filter.getPdAzId(), filter.getDrAzId()});
            return Collections.emptyList();
        }
        LOG.debug((Object)"Start queryCanProtectServiceInstants, pdRegionId: %s, drRegionId: %s, pdAzId: %s, drAzId:%s, projectId: %s, endpoint: %s", new Object[]{filter.getPdRegionId(), filter.getDrRegionId(), filter.getPdAzId(), filter.getDrAzId(), credential.getProjectId(), credential.getEndpoint()});
        ArrayList<AppServiceInstance> resultList = new ArrayList<AppServiceInstance>();
        filter.setMarker(0);
        filter.setLimit(100);
        while ((listInstancesResponse = this.listInstancesWrap(filter, credential)) != null && listInstancesResponse.getTotalCount() != 0 && !VerifyUtil.isEmpty((Collection)listInstancesResponse.getInstances())) {
            List respInstancesList = listInstancesResponse.getInstances();
            Stream<Object> stream = respInstancesList.stream();
            if (!VerifyUtil.isEmpty((String)filter.getInstanceId())) {
                stream = stream.filter(instance -> instance.getId().contains(filter.getInstanceId()));
            }
            List instanceList = stream.filter(this::isProtectableInstance).map(object -> this.convertRdsInstanct((Instance)object, credential)).filter(service -> service.getPdAzId().equals(filter.getPdAzId()) && service.getDrAzId().equals(filter.getDrAzId())).collect(Collectors.toList());
            resultList.addAll(instanceList);
            if (respInstancesList.size() < filter.getLimit()) break;
            filter.setMarker(filter.getMarker() + filter.getLimit());
        }
        return resultList;
    }

    private ListInstancesResponse listInstancesWrap(ServiceInstanceFilter filter, Credential credential) throws ResponseException, ClientException, IOException {
        LOG.debug((Object)"Start listInstancesWrap, pdRegionId: %s, drRegionId: %s, pdAzId: %s, drAzId:%s, projectId: %s, endpoint: %s", new Object[]{filter.getPdRegionId(), filter.getDrRegionId(), filter.getPdAzId(), filter.getDrAzId(), credential.getProjectId(), credential.getEndpoint()});
        ListInstancesRequest request = new ListInstancesRequest();
        request.setName(filter.getInstanceName());
        request.setOffset(filter.getMarker());
        request.setLimit(filter.getLimit());
        request.setDatastoreType(INSTANT_PROTECTABLE_DATASTORE_TYPE);
        request.setType(INSTANT_PROTECTABLE_TYPE);
        return this.rdsClient.listInstances(request, credential);
    }

    @Override
    public boolean isProtectableServiceInstance(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        LOG.debug((Object)"Start isProtectableServiceInstance, serviceInstanceId: %s, projectId: %s, endpoint: %s", new Object[]{serviceInstanceId, credential.getProjectId(), credential.getEndpoint()});
        ListInstancesRequest request = new ListInstancesRequest();
        request.setId(serviceInstanceId);
        ListInstancesResponse listInstancesResponse = this.rdsClient.listInstances(request, credential);
        if (listInstancesResponse == null || VerifyUtil.isEmpty((Collection)listInstancesResponse.getInstances())) {
            return false;
        }
        return this.isProtectableInstance((Instance)listInstancesResponse.getInstances().get(0));
    }

    @Override
    public AppServiceInstance queryProtectServiceInstance(String instanceId, Credential credential) throws ResponseException, ClientException, IOException {
        LOG.debug((Object)"Start queryProtectServiceInstance, instanceId: %s, projectId: %s, endpoint: %s", new Object[]{instanceId, credential.getProjectId(), credential.getEndpoint()});
        ListInstancesRequest request = new ListInstancesRequest();
        request.setId(instanceId);
        AppServiceInstance appServiceInstance = null;
        ListInstancesResponse listInstancesResponse = this.rdsClient.listInstances(request, credential);
        if (listInstancesResponse != null && !VerifyUtil.isEmpty((Collection)listInstancesResponse.getInstances())) {
            Instance instance = (Instance)listInstancesResponse.getInstances().get(0);
            appServiceInstance = this.convertRdsInstanct(instance, credential);
        }
        return appServiceInstance;
    }

    public RdsClient getRdsClient() {
        return this.rdsClient;
    }

    public void setRdsClient(RdsClient rdsClient) {
        this.rdsClient = rdsClient;
    }

    private boolean isProtectableInstance(Instance instance) {
        if (instance == null) {
            return false;
        }
        List nodes = instance.getNodes();
        if (nodes == null) {
            return false;
        }
        long azNum = nodes.stream().map(Node::getAvailabilityZone).distinct().count();
        if (azNum < 2L) {
            return false;
        }
        return INSTANT_PROTECTABLE_STATE_LIST.stream().anyMatch(state -> instance.getStatus().equals(state)) && INSTANT_PROTECTABLE_TYPE.equals(instance.getType()) && instance.getDatastore() != null && instance.getDatastore().getType() != null && INSTANT_PROTECTABLE_DATASTORE_TYPE.equals(instance.getDatastore().getType().getValue());
    }

    private AppServiceInstance convertRdsInstanct(Instance instance, Credential credential) {
        AppServiceInstance appServiceInstance = new AppServiceInstance();
        appServiceInstance.setInstanceId(instance.getId());
        appServiceInstance.setInstanceName(instance.getName());
        Optional<RdsInstanceStatus> rdsInstanceStatus = RdsInstanceStatus.from(instance.getStatus());
        appServiceInstance.setStatus((String)rdsInstanceStatus.map(RdsInstanceStatus::getCsrStatus).map(ServiceInstanceStatus::getValue).orElse(null));
        appServiceInstance.setProjectId(credential.getProjectId());
        appServiceInstance.setReplicaStatus(ReplicaStatus.NORMAL.getValue());
        appServiceInstance.setPdRegionId(instance.getRegion());
        appServiceInstance.setDrRegionId(instance.getRegion());
        String pdAz = instance.getNodes().stream().filter(inst -> inst.getRole().equals(NodeRole.MASTER.getValue())).findFirst().map(Node::getAvailabilityZone).orElse(null);
        appServiceInstance.setPdAzId(pdAz);
        String drAz = instance.getNodes().stream().filter(inst -> inst.getRole().equals(NodeRole.SLAVE.getValue())).findFirst().map(Node::getAvailabilityZone).orElse(null);
        appServiceInstance.setDrAzId(drAz);
        appServiceInstance.setServiceType(ServiceType.RDS.getValue());
        appServiceInstance.setInstanceObjectCount(Integer.valueOf(1));
        List privateIps = instance.getPrivateIps();
        if (!VerifyUtil.isEmpty((Collection)privateIps)) {
            appServiceInstance.setInstanceAddress(String.join((CharSequence)",", privateIps));
        }
        return appServiceInstance;
    }

    private boolean checkRegionAz(ServiceInstanceFilter filter) {
        return !VerifyUtil.isEmpty((String)filter.getPdRegionId()) && !VerifyUtil.isEmpty((String)filter.getPdAzId()) && !VerifyUtil.isEmpty((String)filter.getDrRegionId()) && !VerifyUtil.isEmpty((String)filter.getDrAzId());
    }
}

