/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.client;

import com.huawei.ism.drm.rest.client.ErrorResponse;
import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;

public class DefaultResponseHandler
implements IResponseHandler {
    private static final Log log = LogFactory.getInstance(DefaultResponseHandler.class);
    private static final int REST_STATUS_SUCCESS_CODE = 200;

    @Override
    public void handleReponse(ServiceResponse response) {
        if (null == response) {
            log.error((Object)"response is empty");
            throw new LegoCheckedException(1073947647L);
        }
        if (404 == response.getStatusCode()) {
            log.error((Object)"response status code 404");
            throw new LegoCheckedException(1073947395L);
        }
        if (null != response.getContentData() && response.getStatusCode() != 200) {
            log.error((Object)"response error.");
            ErrorResponse errorResponse = this.convert2ErrorResponse(response);
            if (null == errorResponse.getErrorMessage() || errorResponse.getErrorMessage().trim().isEmpty()) {
                throw new LegoCheckedException(errorResponse.getErrorCode(), errorResponse.getDetailParam());
            }
            throw new LegoCheckedException(errorResponse.getErrorCode(), errorResponse.getDetailParam(), errorResponse.getErrorMessage());
        }
    }

    private ErrorResponse convert2ErrorResponse(ServiceResponse response) {
        ErrorResponse errorResponse;
        try {
            log.error((Object)"Error response: %s", new Object[]{response.getResponseString()});
            errorResponse = (ErrorResponse)JSONObject.toBean((String)response.getResponseString(), ErrorResponse.class);
        }
        catch (LegoCheckedException e) {
            log.error((Object)"convert error reponse failed.");
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (null == errorResponse) {
            throw new LegoCheckedException(-1L);
        }
        return errorResponse;
    }
}

