/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.client;

import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.ism.drm.rest.client.util.URLContext;
import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;

public class RESTAdapter {
    private static final Log log = LogFactory.getInstance(RESTAdapter.class);
    private static final String HTTPS_SCHEME = "https";
    private static final String CHARSE_UTF_8 = "UTF-8";
    private static final String CONTENT_TYPE = "application/json";
    private static final String TLSV1_2 = "TLSv1.2";
    private static final int CONNECTION_TIME_OUT = 60000;

    public static final ClassicHttpRequest buildHttpRequest(HttpRequestMethd methd, URLContext urlContext, List<Header> inputHeaders, String message) {
        String uri = urlContext.getContextPath().replaceAll("//", "/");
        if (HttpRequestMethd.DELETE == methd) {
            HttpDelete httpDelete = new HttpDelete(uri);
            httpDelete.setEntity(RESTAdapter.getMessageEntity(message));
            RESTAdapter.buildHttpRequest(inputHeaders, (HttpUriRequestBase)httpDelete);
            return httpDelete;
        }
        if (HttpRequestMethd.GET == methd) {
            HttpGet httpGet = new HttpGet(uri);
            RESTAdapter.buildHttpRequest(inputHeaders, (HttpUriRequestBase)httpGet);
            return httpGet;
        }
        if (HttpRequestMethd.POST == methd) {
            HttpPost httpPost = new HttpPost(uri);
            RESTAdapter.buildHttpRequest(inputHeaders, (HttpUriRequestBase)httpPost);
            httpPost.setEntity(RESTAdapter.getMessageEntity(message));
            return httpPost;
        }
        HttpPut httpPut = new HttpPut(uri);
        RESTAdapter.buildHttpRequest(inputHeaders, (HttpUriRequestBase)httpPut);
        httpPut.setEntity(RESTAdapter.getMessageEntity(message));
        return httpPut;
    }

    public static final HttpHost buildHttpHost(URLContext urlContext) {
        return new HttpHost(HTTPS_SCHEME, urlContext.getTargetDomain(), urlContext.getPort());
    }

    public static CloseableHttpClient buildRESTHttpClient(String ipAddress, int port, int timeout, String ... protocols) {
        SSLContext context;
        try {
            context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{new BcmX509TrustManager(ipAddress)}, new SecureRandom());
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L, "create SSL context fail,ipAddress:" + ipAddress + ExceptionUtil.getErrorMessage((Throwable)e));
        }
        String[] supportedProtocols = new String[]{TLSV1_2};
        String supportedProtocolConfig = LegoConfig.getInstance().getKeyValue("SUPPORT_TLS_PROTOCLO_VERSIONS");
        if (!VerifyUtil.isEmpty((String)supportedProtocolConfig)) {
            supportedProtocols = supportedProtocolConfig.split(",");
        }
        SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(context, supportedProtocols, null, (HostnameVerifier)new NoopHostnameVerifier());
        Registry registry = RegistryBuilder.create().register(HTTPS_SCHEME, (Object)sslFactory).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(registry);
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(Timeout.ofMilliseconds((long)60000L));
        builder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)timeout));
        RequestConfig requestConfig = builder.build();
        CloseableHttpClient httpclient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connMgr).disableContentCompression().build();
        return httpclient;
    }

    public static ServiceResponse doRequest(HttpHost targetHost, ClassicHttpRequest httpRequest, CloseableHttpClient restHttpClient) throws IOException {
        CloseableHttpResponse response = restHttpClient.execute(targetHost, httpRequest);
        return new ServiceResponse(response, CHARSE_UTF_8);
    }

    private static HttpEntity getMessageEntity(String message) {
        if (StringUtils.isEmpty((CharSequence)message)) {
            return new StringEntity("");
        }
        StringEntity entity = null;
        try {
            entity = new StringEntity(message, ContentType.APPLICATION_JSON);
        }
        catch (Exception e) {
            log.error((Object)"convert post message error.", 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return entity;
    }

    private static void buildHttpRequest(List<Header> headers, HttpUriRequestBase request) {
        if (null == headers) {
            return;
        }
        for (Header header : headers) {
            request.addHeader(header);
        }
    }

    public static enum HttpRequestMethd {
        GET,
        PUT,
        POST,
        DELETE;

    }
}

