/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.client;

import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.constant.RequestObjectType;
import com.huawei.ism.drm.constant.ResponseObjectType;
import com.huawei.ism.drm.rest.client.DefaultResponseHandler;
import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.RESTAdapter;
import com.huawei.ism.drm.rest.client.RestClientRequestExecutor;
import com.huawei.ism.drm.rest.client.RestClientRequestTask;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.ism.drm.rest.client.util.URLContext;
import com.huawei.ism.drm.util.ObjectWrapper;
import com.huawei.ism.drm.util.RestJsonRequest;
import com.huawei.ism.drm.util.ReverseObjectSerializableUtils;
import com.huawei.lego.core.base.thread.MemeryContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHeader;

public class RestClient {
    public static final String SHOW_URL = "show.url";
    private static final Log log = LogFactory.getInstance(RestClient.class);
    private static final int REST_STATUS_SUCCESS_CODE = 200;
    private static final String X_AUTH_USER_KEY = "x-auth-user";
    private static final String X_AUTH_PWD_KEY = "x-auth-key";
    private static final String MACHINE_TO_MACHINE_FLAG = "machine_to_machine_flag";
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private static final int RESPONSE_TIME_OUT = 1800000;
    private static final long FILE_SIZE_MAX = 0x1400000L;
    private CloseableHttpClient httpClient;
    private String ip;
    private int port;
    private String userName;
    private String pwd;
    private int timeout = 1800000;
    private IResponseHandler resHandler;

    public RestClient(String ip, int port, String userName, String pwd) {
        this.ip = ip;
        this.port = port;
        this.userName = userName;
        this.pwd = pwd;
        this.resHandler = new DefaultResponseHandler();
        this.httpClient = RESTAdapter.buildRESTHttpClient(ip, port, this.timeout, new String[0]);
    }

    public RestClient(String ip, int port, String userName, String pwd, IResponseHandler resHandler, String ... protocols) {
        this.ip = ip;
        this.port = port;
        this.userName = userName;
        this.pwd = pwd;
        this.resHandler = resHandler;
        this.httpClient = RESTAdapter.buildRESTHttpClient(ip, port, this.timeout, protocols);
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPwd() {
        if (null != this.pwd && 0 != this.pwd.length()) {
            return WccEncryptor.decrypt((String)this.pwd);
        }
        return this.pwd;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void get(String url) {
        this.doGetRequest(url, this.getHeaders());
    }

    public <T> T getSerializableObject(String url, Class<T> classs) {
        ServiceResponse response = this.doGetRequest(url, this.getHeaders());
        return this.responseToObject(response, classs);
    }

    public String getSerializableObject(String url) {
        ServiceResponse response = this.doGetRequest(url, this.getHeaders());
        if (null == response) {
            return null;
        }
        try {
            JSONObject jsonObj = JSONObject.fromObject((Object)response.getResponseString());
            RestJsonRequest obj = (RestJsonRequest)JSONObject.toBean((JSONObject)jsonObj, RestJsonRequest.class);
            if (obj != null) {
                return obj.getValue();
            }
            log.error((Object)"RestJsonRequest is null");
            return null;
        }
        catch (LegoCheckedException e) {
            log.error((Object)"convert object error.", 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public <T> T getForObject(String url, Map<String, ?> uriVariabels, Class<T> clazz, ResponseObjectType resObjType) {
        ClassicHttpRequest httpRequest;
        URLContext urlContext = this.createURLContext(url, uriVariabels);
        HttpHost targetHost = RESTAdapter.buildHttpHost(urlContext);
        ServiceResponse response = this.doRequest(targetHost, httpRequest = RESTAdapter.buildHttpRequest(RESTAdapter.HttpRequestMethd.GET, urlContext, this.getHeaders(), null));
        if (null == response) {
            throw new LegoCheckedException(1073947393L);
        }
        String responseString = response.getResponseString();
        if (null != resObjType && ResponseObjectType.WrappedObject.name().equals(resObjType.name())) {
            JSONObject jsonObject = JSONObject.fromObject((Object)responseString);
            try {
                return (T)ReverseObjectSerializableUtils.reverseeObj((String)String.valueOf(jsonObject.get("value")), clazz);
            }
            catch (LegoCheckedException e) {
                log.error((Object)("convert object error.  The class is:" + clazz), 90160758787071L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)responseString);
        return (T)JSONObject.toBean((JSONObject)jsonObject, clazz);
    }

    public <T> T getForObject(String url, Class<T> clazz) {
        return this.getForObject(url, null, clazz, ResponseObjectType.Default);
    }

    public <T> T getForObject(String url, Map<String, ?> uriVariables, Class<T> clazz) {
        return this.getForObject(url, uriVariables, clazz, ResponseObjectType.Default);
    }

    public <T> List<T> getForObjects(String url, Map<String, ?> uriVariables, Class<T> clazz) {
        ClassicHttpRequest httpRequest;
        URLContext urlContext = this.createURLContext(url, uriVariables);
        HttpHost targetHost = RESTAdapter.buildHttpHost(urlContext);
        ServiceResponse response = this.doRequest(targetHost, httpRequest = RESTAdapter.buildHttpRequest(RESTAdapter.HttpRequestMethd.GET, urlContext, this.getHeaders(), null));
        if (null == response) {
            throw new LegoCheckedException(1073947393L);
        }
        String responseString = response.getResponseString();
        List result = null;
        try {
            result = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)responseString), clazz);
        }
        catch (LegoCheckedException e) {
            log.error((Object)"Json error", (Throwable)e, 90160758787071L);
            return result;
        }
        return result;
    }

    public String get(String url, Map<String, ?> uriVariables) {
        return this.get(url, uriVariables, this.getHeaders());
    }

    public String get(String url, Map<String, ?> uriVariables, List<Header> requestHeaders) {
        BasicHeader accept = new BasicHeader("Accept", (Object)"application/json");
        requestHeaders.add((Header)accept);
        URLContext urlContext = this.createURLContext(url, uriVariables);
        HttpHost targetHost = RESTAdapter.buildHttpHost(urlContext);
        ClassicHttpRequest httpRequest = RESTAdapter.buildHttpRequest(RESTAdapter.HttpRequestMethd.GET, urlContext, requestHeaders, null);
        ServiceResponse response = this.doRequest(targetHost, httpRequest);
        return this.getResponseString(response);
    }

    public ServiceResponse get(String url, Map<String, ?> uriVariables, Map<String, String> requestHeaders) {
        List<Header> reqHeaderList = this.buildRequestHeaders(requestHeaders);
        BasicHeader accept = new BasicHeader("Accept", (Object)"application/json");
        reqHeaderList.add((Header)accept);
        URLContext urlContext = this.createURLContext(url, uriVariables);
        HttpHost targetHost = RESTAdapter.buildHttpHost(urlContext);
        ClassicHttpRequest httpRequest = RESTAdapter.buildHttpRequest(RESTAdapter.HttpRequestMethd.GET, urlContext, reqHeaderList, null);
        return this.doRequest(targetHost, httpRequest);
    }

    public String delete(String url, Map<String, ?> uriVariables) {
        URLContext urlContext = this.createURLContext(url, uriVariables);
        HttpHost targetHost = RESTAdapter.buildHttpHost(urlContext);
        ClassicHttpRequest httpRequest = RESTAdapter.buildHttpRequest(RESTAdapter.HttpRequestMethd.DELETE, urlContext, this.getHeaders(), null);
        ServiceResponse response = this.doRequest(targetHost, httpRequest);
        return this.getResponseString(response);
    }

    public String delete(String url, String message, Map<String, ?> uriVariables) {
        return this.delete(url, message, uriVariables, this.getHeaders());
    }

    public String delete(String url, String message, Map<String, ?> uriVariables, List<Header> requestHeaders) {
        URLContext urlContext = this.createURLContext(url, uriVariables);
        HttpHost targetHost = RESTAdapter.buildHttpHost(urlContext);
        ClassicHttpRequest httpRequest = RESTAdapter.buildHttpRequest(RESTAdapter.HttpRequestMethd.DELETE, urlContext, requestHeaders, message);
        ServiceResponse response = this.doRequest(targetHost, httpRequest);
        return this.getResponseString(response);
    }

    public String put(String url, String message, Map<String, ?> uriVariables) {
        return this.put(url, message, uriVariables, this.getHeaders());
    }

    public String put(String url, String message, Map<String, ?> uriVariables, List<Header> requestHeaders) {
        URLContext urlContext = this.createURLContext(url, uriVariables);
        HttpHost targetHost = RESTAdapter.buildHttpHost(urlContext);
        ClassicHttpRequest httpRequest = RESTAdapter.buildHttpRequest(RESTAdapter.HttpRequestMethd.PUT, urlContext, requestHeaders, message);
        ServiceResponse response = this.doRequest(targetHost, httpRequest);
        return this.getResponseString(response);
    }

    public ServiceResponse put(String url, String message, Map<String, ?> uriVariables, Map<String, String> requestHeaders) {
        URLContext urlContext = this.createURLContext(url, uriVariables);
        List<Header> reqHeaderList = this.buildRequestHeaders(requestHeaders);
        HttpHost targetHost = RESTAdapter.buildHttpHost(urlContext);
        ClassicHttpRequest httpRequest = RESTAdapter.buildHttpRequest(RESTAdapter.HttpRequestMethd.PUT, urlContext, reqHeaderList, message);
        return this.doRequest(targetHost, httpRequest);
    }

    public String post(String url, String message, Map<String, ?> uriVariables) {
        return this.post(url, message, uriVariables, this.getHeaders());
    }

    public String post(String url, String message, Map<String, ?> uriVariables, List<Header> requestHeaders) {
        URLContext urlContext = this.createURLContext(url, uriVariables);
        HttpHost targetHost = RESTAdapter.buildHttpHost(urlContext);
        ClassicHttpRequest httpRequest = RESTAdapter.buildHttpRequest(RESTAdapter.HttpRequestMethd.POST, urlContext, requestHeaders, message);
        ServiceResponse response = this.doRequest(targetHost, httpRequest);
        return this.getResponseString(response);
    }

    public ServiceResponse post(String url, String message, Map<String, ?> uriVariables, Map<String, String> requestHeaders) {
        URLContext urlContext = this.createURLContext(url, uriVariables);
        List<Header> reqHeaderList = this.buildRequestHeaders(requestHeaders);
        HttpHost targetHost = RESTAdapter.buildHttpHost(urlContext);
        ClassicHttpRequest httpRequest = RESTAdapter.buildHttpRequest(RESTAdapter.HttpRequestMethd.POST, urlContext, reqHeaderList, message);
        return this.doRequest(targetHost, httpRequest);
    }

    public boolean downloadFile(String url, String message, Map<String, ?> uriVariables, List<Header> requestHeaders, String logFileName, String sn) {
        URLContext urlContext = this.createURLContext(url, uriVariables);
        HttpHost targetHost = RESTAdapter.buildHttpHost(urlContext);
        ClassicHttpRequest httpRequest = RESTAdapter.buildHttpRequest(RESTAdapter.HttpRequestMethd.POST, urlContext, requestHeaders, message);
        return this.getDownloadStream(targetHost, httpRequest, logFileName, sn);
    }

    public <T> T postForObject(String url, Map<String, ?> uriVariables, Object requestObject, RequestObjectType reqObjType, Class<T> clazz) {
        JSONObject jsonObject;
        Object finalRequestObject = requestObject;
        if (null != reqObjType && RequestObjectType.WrappedObject.name().equals(reqObjType.name())) {
            ObjectWrapper objWrapper = new ObjectWrapper();
            objWrapper.setValue(ReverseObjectSerializableUtils.serializableObj((Object)requestObject));
            objWrapper.setClasssName(requestObject.getClass().getName());
            finalRequestObject = objWrapper;
        }
        if (null == (jsonObject = JSONObject.fromObject((Object)finalRequestObject))) {
            log.error((Object)"Translating message to jsonobject failed.", 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        String responseString = this.post(url, jsonObject.toString(), uriVariables);
        JSONObject resJsonObject = JSONObject.fromObject((Object)responseString);
        return (T)JSONObject.toBean((JSONObject)resJsonObject, clazz);
    }

    public <T> T postForObject(String url, Map<String, ?> uriVariables, Object requestObject, Class<T> clazz) {
        return this.postForObject(url, uriVariables, requestObject, RequestObjectType.Default, clazz);
    }

    public String invoke(String url, String message, Map<String, ?> uriVariables, HttpMethod method) {
        if (null == method) {
            throw new LegoCheckedException(1073947393L);
        }
        String methodName = method.name();
        if (HttpMethod.GET.name().equals(methodName)) {
            return this.get(url, uriVariables);
        }
        if (HttpMethod.PUT.name().equals(methodName)) {
            return this.put(url, message, uriVariables);
        }
        if (HttpMethod.POST.name().equals(methodName)) {
            return this.post(url, message, uriVariables);
        }
        if (HttpMethod.DELETE.name().equals(methodName)) {
            return this.delete(url, uriVariables);
        }
        return null;
    }

    public String invoke(String url, Map<String, ?> uriVariables, HttpMethod method) {
        return this.invoke(url, null, uriVariables, method);
    }

    public String invoke(String url, HttpMethod method) {
        return this.invoke(url, null, null, method);
    }

    public void postSerializableObj(Object message, String url) {
        String messageObj = ReverseObjectSerializableUtils.serializableObj((Object)message);
        RestJsonRequest request = new RestJsonRequest();
        request.setClasssName(message.getClass().getName());
        request.setValue(messageObj);
        this.doPostRequest(request, url);
    }

    public <T> T postSerializableObj(Object message, String url, Class<T> classs) {
        String messageObj = ReverseObjectSerializableUtils.serializableObj((Object)message);
        RestJsonRequest request = new RestJsonRequest();
        request.setClasssName(message.getClass().getName());
        request.setValue(messageObj);
        ServiceResponse response = this.doPostRequest(request, url);
        if (null == response) {
            throw new LegoCheckedException(1073947393L);
        }
        try {
            JSONObject result = JSONObject.fromObject((Object)response.getResponseString());
            return (T)ReverseObjectSerializableUtils.reverseeObj((String)String.valueOf(result.get("message")), classs);
        }
        catch (LegoCheckedException e) {
            log.error((Object)("convert object error.  The class is:" + classs), 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    private URLContext createURLContext(String url, Map<String, ?> uriVariables) {
        String sURL;
        if (Ipv6AddressUtil.isIPv6Address((String)this.ip)) {
            log.debug((Object)("this ip is ipv6. ip:" + this.ip));
            sURL = "https://" + Ipv6AddressUtil.convertIpv6((String)this.ip) + url;
        } else {
            log.debug((Object)("this ip is ipv4. ip:" + this.ip));
            sURL = "https://" + this.ip + url;
        }
        sURL = RestClient.expand(sURL, uriVariables);
        Object flag = MemeryContext.get((Object)SHOW_URL);
        if (Boolean.TRUE.equals(flag)) {
            log.info((Object)("requestUrl:" + sURL));
        }
        URLContext urlContext = new URLContext(sURL, this.getPort());
        return urlContext;
    }

    public List<Header> getHeaders(Map<String, String> custom) {
        String password;
        HashMap<String, String> results = new HashMap<String, String>(Optional.ofNullable(custom).orElseGet(Collections::emptyMap));
        results.put(MACHINE_TO_MACHINE_FLAG, MACHINE_TO_MACHINE_FLAG);
        if (null != this.getUserName() && !this.getUserName().isEmpty()) {
            results.put(X_AUTH_USER_KEY, this.getUserName());
        }
        if (null != (password = this.getPwd()) && !password.isEmpty()) {
            results.put(X_AUTH_PWD_KEY, password);
        }
        ArrayList<Header> headers = new ArrayList<Header>();
        results.entrySet().forEach(e -> headers.add((Header)new BasicHeader((String)e.getKey(), e.getValue())));
        return headers;
    }

    private List<Header> getHeaders() {
        return this.getHeaders(Collections.emptyMap());
    }

    private ServiceResponse doGetRequest(String url, List<Header> additionalHeaders) {
        BasicHeader accept = new BasicHeader("Accept", (Object)"application/json");
        additionalHeaders.add((Header)accept);
        URLContext urlContext = new URLContext("https://" + this.getIp() + url, this.getPort());
        HttpHost targetHost = RESTAdapter.buildHttpHost(urlContext);
        ClassicHttpRequest httpRequest = RESTAdapter.buildHttpRequest(RESTAdapter.HttpRequestMethd.GET, urlContext, additionalHeaders, null);
        return this.doRequest(targetHost, httpRequest);
    }

    private ServiceResponse doPostRequest(Object message, String url) {
        JSONObject obj = JSONObject.fromObject((Object)message);
        if (null == obj) {
            log.error((Object)"Translating message to json object failed.", 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        URLContext urlContext = new URLContext("https://" + this.getIp() + url, this.getPort());
        HttpHost targetHost = RESTAdapter.buildHttpHost(urlContext);
        ClassicHttpRequest httpRequest = RESTAdapter.buildHttpRequest(RESTAdapter.HttpRequestMethd.POST, urlContext, this.getHeaders(), obj.toString());
        return this.doRequest(targetHost, httpRequest);
    }

    private ServiceResponse doRequest(HttpHost targetHost, ClassicHttpRequest httpRequest) {
        RestClientRequestTask task = new RestClientRequestTask(targetHost, httpRequest, this.httpClient, this.ip);
        Future<ServiceResponse> future = RestClientRequestExecutor.submit(task);
        ServiceResponse response = null;
        try {
            response = future.get(this.timeout, TimeUnit.MILLISECONDS);
            if (null != response) {
                response.setRequest((HttpRequest)httpRequest);
            }
        }
        catch (LegoCheckedException e) {
            log.error((Object)"Failed to request", (Throwable)e, 90160758787071L);
            throw e;
        }
        catch (InterruptedException e) {
            this.doRequestError(e);
        }
        catch (ExecutionException e) {
            this.doRequestError(e);
        }
        catch (TimeoutException e) {
            this.doRequestError(e);
        }
        this.handleResponse(response);
        return response;
    }

    private void doRequestError(Exception e) {
        ExceptionUtil.rethrowException((Throwable)e, (String)"Request failed", (long)1073947398L, (String[])new String[]{this.ip}, (Log)log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean getDownloadStream(HttpHost targetHost, ClassicHttpRequest httpRequest, String logFileName, String sn) {
        block11: {
            boolean bl;
            InputStream inputStream = null;
            try {
                CloseableHttpResponse response = this.httpClient.execute(targetHost, httpRequest);
                int status = response.getCode();
                long length = response.getEntity().getContentLength();
                if (status != 200) {
                    log.error((Object)("download status:" + status), 90160758787071L);
                    boolean bl2 = false;
                    CommonUtil.close((Closeable)inputStream);
                    return bl2;
                }
                if (length > 0x1400000L) {
                    log.error((Object)("download status:" + status + ",length=" + length), 90160758787071L);
                    throw new LegoCheckedException(-1L);
                }
                inputStream = response.getEntity().getContent();
                this.writeFile(logFileName, inputStream, sn);
                bl = true;
                CommonUtil.close((Closeable)inputStream);
            }
            catch (LegoCheckedException e) {
                log.error((Object)"Failed to request", (Throwable)e, 90160758787071L);
                throw e;
            }
            catch (IllegalStateException e2) {
                ExceptionUtil.rethrowException((Throwable)e2, (String)"Request failed", (long)1073947398L, (String[])new String[]{this.ip}, (Log)log);
                break block11;
            }
            catch (IOException e3) {
                ExceptionUtil.rethrowException((Throwable)e3, (String)"Request failed", (long)1073947398L, (String[])new String[]{this.ip}, (Log)log);
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                CommonUtil.close(inputStream);
            }
            return bl;
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeFile(String logFileName, InputStream downloadStream, String sn) {
        FileOutputStream logFileOutputStream = null;
        try {
            int len;
            File file = new File(logFileName);
            if (file.exists() && !file.delete()) {
                log.error((Object)("delete file fail,sn:" + sn), 90160758786816L);
                throw new LegoCheckedException(-1L);
            }
            logFileOutputStream = new FileOutputStream(logFileName);
            byte[] buffer = new byte[1024];
            while ((len = downloadStream.read(buffer)) > -1) {
                logFileOutputStream.write(buffer, 0, len);
            }
            logFileOutputStream.flush();
        }
        catch (FileNotFoundException e) {
            try {
                throw ExceptionUtil.convertException((Throwable)e, (String)("export agent log failed,sn:" + sn), (long)-1L, (String[])new String[0], (Log)log);
                catch (IOException e2) {
                    throw ExceptionUtil.convertException((Throwable)e2, (String)("export agent log failed,sn:" + sn), (long)-1L, (String[])new String[0], (Log)log);
                }
            }
            catch (Throwable throwable) {
                CommonUtil.close(logFileOutputStream);
                throw throwable;
            }
        }
        CommonUtil.close((Closeable)logFileOutputStream);
    }

    private void handleResponse(ServiceResponse response) {
        if (null != this.resHandler) {
            this.resHandler.handleReponse(response);
        }
    }

    public String getReourceCollect(String url) {
        ServiceResponse response = this.doGetRequest(url, this.getHeaders());
        return this.getResponseString(response);
    }

    private <T> T responseToObject(ServiceResponse response, Class<T> classs) {
        if (null == response) {
            return null;
        }
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)response.getResponseString());
            RestJsonRequest obj = (RestJsonRequest)JSONObject.toBean((JSONObject)jsonObject, RestJsonRequest.class);
            if (obj != null) {
                return (T)obj.toObject();
            }
            log.error((Object)"RestJsonRequest is null");
            return null;
        }
        catch (LegoCheckedException e) {
            log.error((Object)("convert object error.  The class is:" + classs), 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("reverse serializable obj classNoteFoundException.  The class is:" + classs), 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    private static String expand(String source, Map<String, ?> uriVariables) {
        if (source.indexOf(123) == -1) {
            return source;
        }
        if (null == uriVariables) {
            return source;
        }
        Matcher matcher = NAMES_PATTERN.matcher(Normalizer.normalize(source, Normalizer.Form.NFKC));
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String match = matcher.group(1);
            String variableName = RestClient.getVariableName(match);
            Object variableValue = uriVariables.get(variableName);
            String variableValueString = RestClient.getVariableValueAsString(variableValue);
            String replacement = Matcher.quoteReplacement(variableValueString);
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private List<Header> buildRequestHeaders(Map<String, String> requestHeaders) {
        if (null == requestHeaders || requestHeaders.isEmpty()) {
            return this.getHeaders();
        }
        ArrayList<Header> results = new ArrayList<Header>();
        for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            BasicHeader header = new BasicHeader(key, (Object)value);
            results.add((Header)header);
        }
        return results;
    }

    private static String getVariableName(String match) {
        int colonIdx = match.indexOf(58);
        return colonIdx != -1 ? match.substring(0, colonIdx) : match;
    }

    private static String getVariableValueAsString(Object variableValue) {
        return variableValue != null ? variableValue.toString() : "";
    }

    public void closeHttpClient() {
        if (null != this.httpClient) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                log.error((Object)("close httpClient error:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            this.httpClient = null;
        }
    }

    protected String getResponseString(ServiceResponse response) {
        if (null == response) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)response.getContentData())) {
            log.info((Object)"ContentData in response is empty. Response statueCode is %s", new Object[]{String.valueOf(response.getStatusCode())});
            return "";
        }
        return response.getResponseString();
    }
}

