/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.client;

import com.huawei.ism.drm.rest.client.RESTAdapter;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.net.SocketTimeoutException;
import java.util.concurrent.Callable;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpHost;

class RestClientRequestTask
implements Callable<ServiceResponse> {
    private static final Log logger = LogFactory.getInstance(RestClientRequestTask.class);
    private HttpHost targetHost;
    private ClassicHttpRequest httpRequest;
    private CloseableHttpClient httpClient;
    private String ipAddress;

    public RestClientRequestTask(HttpHost targetHost, ClassicHttpRequest httpRequest, CloseableHttpClient httpClient, String ipAddress) {
        this.targetHost = targetHost;
        this.httpRequest = httpRequest;
        this.httpClient = httpClient;
        this.ipAddress = ipAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceResponse call() {
        long startTime = System.currentTimeMillis();
        ServiceResponse response = null;
        try {
            response = RESTAdapter.doRequest(this.targetHost, this.httpRequest, this.httpClient);
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)"Connection failed", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(1073947401L, (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"soap request failed", (long)1073947398L, (String[])new String[]{this.ipAddress}, (Log)logger);
        }
        finally {
            if (this.httpRequest instanceof HttpUriRequestBase) {
                long endTime = System.currentTimeMillis();
                logger.debug((Object)("Request( Target Host: " + this.ipAddress + ", Method: " + this.httpRequest.getMethod() + ", Uri: " + this.httpRequest.getRequestUri() + " ), from " + startTime + " to " + endTime + ", elapsed time\uff1a" + (endTime - startTime) + "ms."));
            }
        }
        return response;
    }
}

