/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.client.util;

import com.huawei.ism.drm.rest.client.util.StringContentData;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;

public class ServiceResponse {
    private static final Log log = LogFactory.getInstance(ServiceResponse.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private int statusCode;
    private Header[] responseHeaders;
    private StringContentData contentData;
    private HttpRequest request;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ServiceResponse(CloseableHttpResponse response, String charset) {
        block12: {
            this.statusCode = 500;
            this.responseHeaders = null;
            this.contentData = null;
            this.request = null;
            assert (response != null) : "HttpResponse should not be null";
            InputStream inputStream = null;
            try {
                this.statusCode = response.getCode();
                this.responseHeaders = response.getHeaders();
                if (response.getEntity() != null) {
                    inputStream = response.getEntity().getContent();
                    this.contentData = ServiceResponse.writeToContentData(inputStream, charset);
                } else if (this.statusCode < 400) {
                    this.contentData = new StringContentData("".getBytes(StandardCharsets.UTF_8), charset);
                } else {
                    throw new LegoCheckedException("HTTP response is null. Please check availability of endpoint service.");
                }
                CommonUtil.close((Closeable)inputStream);
            }
            catch (IllegalStateException e) {
                log.error((Object)"ServiceResponse create error IllegalStateException");
            }
            catch (IOException e2) {
                log.error((Object)"ServiceResponse create error IOException");
                break block12;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                CommonUtil.close(inputStream);
            }
        }
    }

    public static StringContentData writeToContentData(InputStream inputStream, String charset) {
        StringContentData output = null;
        byte[] outputBytes = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ServiceResponse.fastChannelCopy(inputStream, baos);
        outputBytes = baos.toByteArray();
        output = new StringContentData(outputBytes, charset);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fastChannelCopy(InputStream inputStream, ByteArrayOutputStream baos) {
        ReadableByteChannel src = Channels.newChannel(inputStream);
        WritableByteChannel dest = Channels.newChannel(baos);
        ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
        try {
            if (src == null) {
                return;
            }
            while (src.read(buffer) != -1) {
                buffer.flip();
                dest.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                dest.write(buffer);
            }
        }
        catch (IOException e) {
            log.error((Object)"ServiceResponse fastChannelCopy error Exception");
        }
        finally {
            CommonUtil.close((Closeable)src);
            CommonUtil.close((Closeable)dest);
            CommonUtil.close((Closeable)inputStream);
            CommonUtil.close((Closeable)baos);
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseString() {
        String responseInString = this.contentData.getContentInString();
        return responseInString;
    }

    public Header[] getResponseHeaders() {
        return this.responseHeaders;
    }

    public int getResponseLength() {
        return this.contentData.getContentLength();
    }

    public StringContentData getContentData() {
        return this.contentData;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\nServiceResponse\n---------------\nHTTP Status: ").append(this.statusCode).append("\nHeaders: \n");
        for (Header header : this.responseHeaders) {
            buffer.append(header.getName()).append(" : ").append(header.getValue()).append("\n");
        }
        buffer.append("Response body: \n").append(this.contentData).append("\n----------------\n");
        return buffer.toString();
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpRequest request) {
        this.request = request;
    }
}

