/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.client.util;

import org.apache.commons.lang3.StringUtils;

public class URLContext {
    private static final String HTTPS_SCHEME = "https";
    private static final String SEPARATOR = "/";
    private static final String URL_SEPARATOR = "//";
    private static final String ALL_SEPARATORS = "/?:*";
    private boolean secureInvocation = false;
    private String contextPath = null;
    private String targetDomain = null;
    private int port = 0;

    public URLContext(String restUrl) {
        this(restUrl, 80);
    }

    public URLContext(String restUrl, int port) {
        this.constructContextPath(restUrl);
        this.port = port;
    }

    private void constructContextPath(String restUrl) {
        restUrl = restUrl + SEPARATOR;
        this.targetDomain = StringUtils.substringBetween((String)restUrl, (String)URL_SEPARATOR, (String)SEPARATOR);
        this.contextPath = StringUtils.substringAfter((String)restUrl, (String)this.targetDomain);
        if (restUrl.startsWith(HTTPS_SCHEME)) {
            this.secureInvocation = true;
        }
        this.removeEnd();
    }

    private void removeEnd() {
        this.contextPath = StringUtils.stripEnd((String)this.contextPath, (String)ALL_SEPARATORS);
    }

    public URLContext addContextPathElement(String contextPathElement) {
        this.contextPath = this.contextPath + SEPARATOR + contextPathElement;
        return this;
    }

    public String getContextPath() {
        assert (this.contextPath != null) : "REST context path should not be null";
        return this.contextPath;
    }

    public String getTargetDomain() {
        return this.targetDomain;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecureInvocation() {
        return this.secureInvocation;
    }
}

