/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.factory;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.openstack.adapter.manager.ICeiloMeterManager;
import com.huawei.ism.drm.openstack.adapter.manager.ICinderManager;
import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.manager.IImageManager;
import com.huawei.ism.drm.openstack.adapter.manager.IKeystoreManager;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CeiloMeterManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManagerMitaka;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.IAMManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.ImageManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.KeystoreManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManagerMitaka;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ManagerFactory {
    private static final ManagerFactory INSTANCE = new ManagerFactory();
    private static final Log logger = LogFactory.getInstance(ManagerFactory.class);
    private Map<String, OpenstackInfo> regOpenstacks = new ConcurrentHashMap<String, OpenstackInfo>();
    private Object lock = new Object();

    private ManagerFactory() {
    }

    public static ManagerFactory getInstance() {
        return INSTANCE;
    }

    public ICinderManager getCinderManager(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"param\uff1aopenstackUuid is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String version = this.getOpenStackVersion(openstackUuid);
        return this.getCinderManagerByVersion(version);
    }

    public ICinderManager getCinderManagerByVersion(String version) {
        return new CinderManagerMitaka();
    }

    public IDrExtendManager getDrExtendManager(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"param: openstackUuid is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String version = this.getOpenStackVersion(openstackUuid);
        return this.getDrExtendManagerByVersion(version);
    }

    public IDrExtendManager getDrExtendManagerByVersion(String version) {
        return new DrExtendManager();
    }

    public IKeystoreManager getKeystoreManager(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            return new KeystoreManager();
        }
        String version = this.getOpenStackVersion(openstackUuid);
        boolean isIAM = this.isUseIAM(openstackUuid);
        return this.getKeystoreManagerByVersion(version, isIAM);
    }

    public IKeystoreManager getKeystoreManagerByVersion(String version, boolean isIAM) {
        if (isIAM) {
            return new IAMManager();
        }
        return new KeystoreManager();
    }

    public INeutronManager getNeutronManager(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            return new NeutronManager();
        }
        String version = this.getOpenStackVersion(openstackUuid);
        return this.getNeutronManagerByVersion(version);
    }

    public INeutronManager getNeutronManagerByVersion(String version) {
        return new NeutronManager();
    }

    public INovaManager getNovaManager(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            return new NovaManagerMitaka();
        }
        String version = this.getOpenStackVersion(openstackUuid);
        return this.getNovaManagerByVersion(version);
    }

    public INovaManager getNovaManagerByVersion(String version) {
        return new NovaManagerMitaka();
    }

    public ICeiloMeterManager getMeterManager(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            return new CeiloMeterManager();
        }
        String version = this.getOpenStackVersion(openstackUuid);
        return this.getMeterManagerByVersion(version);
    }

    public ICeiloMeterManager getMeterManagerByVersion(String version) {
        return new CeiloMeterManager();
    }

    public IImageManager getImageManager(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            return new ImageManager();
        }
        String version = this.getOpenStackVersion(openstackUuid);
        return this.getImageManagerByVersion(version);
    }

    public IImageManager getImageManagerByVersion(String version) {
        return new ImageManager();
    }

    private String getOpenStackVersion(String openstackUuid) {
        OpenstackInfo info = this.getRegOpenstack(openstackUuid);
        if (null != info) {
            return info.getVersion();
        }
        return "";
    }

    public synchronized void removeRegOpenstack(String openStackUUID) {
        if (VerifyUtil.isEmpty((String)openStackUUID)) {
            logger.error((Object)"removeRegOpenstack parmeter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (this.regOpenstacks.containsKey(openStackUUID)) {
            this.regOpenstacks.remove(openStackUUID);
        }
    }

    private boolean isUseIAM(String openstackUuid) {
        OpenstackInfo info = this.getRegOpenstack(openstackUuid);
        if (null != info) {
            return info.isUseIAM();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenstackInfo getRegOpenstack(String openstackUuid) {
        if (VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.error((Object)"openstackUuid is empty.");
            return null;
        }
        if (this.regOpenstacks.containsKey(openstackUuid)) {
            return this.regOpenstacks.get(openstackUuid);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.regOpenstacks.containsKey(openstackUuid)) {
                return this.regOpenstacks.get(openstackUuid);
            }
            OpenstackInfo openInfo = this.getOpenstackInfo(openstackUuid);
            if (null == openInfo) {
                logger.error((Object)("openstack(" + openstackUuid + ") is not exist in system."));
                this.regOpenstacks.remove(openstackUuid);
                return null;
            }
            this.regOpenstacks.put(openstackUuid, openInfo);
            return openInfo;
        }
    }

    private OpenstackInfo getOpenstackInfo(String openstackUuid) {
        FusionSphereOpenStack open = (FusionSphereOpenStack)CommonDAOLocator.getMoDao().getMoByUuid(openstackUuid, Boolean.valueOf(true));
        if (VerifyUtil.isEmpty((Object)open)) {
            logger.warn((Object)("cant find openstack mo:openstackUuid=" + openstackUuid));
            return null;
        }
        long moId = open.getMoId();
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend extend = neMgr.findByMoId(Long.valueOf(moId));
        if (VerifyUtil.isEmpty((Object)extend)) {
            logger.warn((Object)("cant find openstack ne extend info :openstackUuid=" + openstackUuid));
            return null;
        }
        Map paramMap = extend.getExtendParams();
        String isIam = (String)paramMap.get("authType");
        OpenstackInfo openInfo = new OpenstackInfo();
        openInfo.setIp(open.getIpAddress());
        openInfo.setPort((String)paramMap.get("port"));
        openInfo.setDomainName((String)paramMap.get("domain"));
        openInfo.setUser(extend.getNetworkUserName());
        openInfo.setPasswd(extend.getNetworkPassword());
        openInfo.setUseIAM("IAM".equals(isIam));
        openInfo.setUuid(openstackUuid);
        openInfo.setVersion((String)paramMap.get("version"));
        return openInfo;
    }
}

