/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.huawei.ism.drm.openstack.adapter.manager.ICeiloMeterManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.MeterInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.util.endpointutil.ServiceEndpointUtil;
import java.util.List;

public class CeiloMeterManager
implements ICeiloMeterManager {
    private static Log logger = LogFactory.getInstance(CeiloMeterManager.class);

    @Override
    public AsyncTaskResponse reportMeterInfo(List<MeterInfo> metersInfo, String meterName, String regionUuid, String tokenId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty(metersInfo) || VerifyUtil.isEmpty((String)meterName)) {
            logger.error((Object)"Parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String sendJson = JsonUtil.listToJsonArray(metersInfo);
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "metering");
        String url = OpenstackEnumDefine.REQUEST_URL.CEILOMETER_POST.getUri();
        String newUrlStr = urlStr + String.format(url, meterName);
        String respStr = ClientUtil.sendPostRequest(newUrlStr, sendJson, tokenId);
        logger.debug((Object)("ReportMeterInfo response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("Response string is empty , url is" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        List<MeterInfo> respList = JsonUtil.jsonArrayToList(respStr, MeterInfo.class);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (metersInfo.size() == respList.size()) {
            response.setSuccess(true);
            logger.debug((Object)"Successful report MeterInfo, meterName : %s , regionUuid : %s ", new Object[]{meterName, regionUuid});
            return response;
        }
        response.setSuccess(false);
        logger.error((Object)("Bad Request reportMeterInfo: " + newUrlStr));
        response.setErrorCode("3145729");
        return response;
    }
}

