/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManagerBase;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.msg.IAsyncTaskResponseChecker;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.cache.OpenstackCache;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackStorageResourcePool;
import com.huawei.ism.drm.openstack.sdk.msg.CreateVhaCsdrRingInfo;
import com.huawei.ism.drm.openstack.sdk.msg.ReplicationDriverDataInfo;
import com.huawei.ism.drm.openstack.sdk.msg.StoragePoolInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VhaCsdrRingInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolReplicaCgCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolReplicaCgUpdateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.util.endpointutil.ServiceEndpointUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DrExtendManager
extends DrExtendManagerBase {
    private static Log logger = LogFactory.getInstance(DrExtendManager.class);
    private static final List<String> REPLICATION_CAN_DELETE_STATUS = new ArrayList<String>(Arrays.asList(OpenstackEnumDefine.REPLICATION_STATUS_E.DELETING.getValue(), OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue(), OpenstackEnumDefine.REPLICATION_STATUS_E.ERROR.getValue(), OpenstackEnumDefine.REPLICATION_STATUS_E.ERROR_DELETING.getValue()));
    private static final List<String> NORMAL_REPLICATION_CAN_DELETE_STATUS = new ArrayList<String>(Arrays.asList(OpenstackEnumDefine.REPLICATION_STATUS_E.DELETING.getValue(), OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue()));
    private static final long EACH_PAIR_OVER_TIME = 60000L;

    @Override
    public List<VolumeReplicationInfo> getVolumeReplications(String regionUuid, String tokenId, String projUuid, Map<String, String> uriVariables, boolean isSummary) {
        if (VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)regionUuid)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<VolumeReplicationInfo> repInfolist = new ArrayList<VolumeReplicationInfo>();
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + (isSummary ? this.getSummaryUrl(uriVariables, projId) : this.getDetailUrl(uriVariables, projId));
        String limit = String.valueOf(1000);
        if (VerifyUtil.isEmpty(uriVariables)) {
            uriVariables = new HashMap<String, String>();
        }
        uriVariables.put("limit", limit);
        int offset = 0;
        String respStr = null;
        while (true) {
            uriVariables.put("offset", String.valueOf(offset));
            respStr = ClientUtil.sendGetRequest(newUrlStr, uriVariables, tokenId, new int[0]);
            List<VolumeReplicationInfo> list = this.getVolumeRepliInfosFromRespStr(respStr);
            repInfolist.addAll(list);
            if (list.size() < 1000) break;
            offset += 1000;
        }
        return repInfolist;
    }

    private List<VolumeReplicationInfo> getVolumeRepliInfosFromRespStr(String respStr) {
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (VerifyUtil.isEmpty((Object)jsonNode) || jsonNode.path("replications").isMissingNode()) {
            logger.error((Object)("bad Request getVolumeReplications, response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        List<VolumeReplicationInfo> repInfolist = JsonUtil.jsonArrayToList(jsonNode.path("replications").toString(), VolumeReplicationInfo.class);
        logger.debug((Object)("getVolumeReplications detail. response str=" + repInfolist.size()));
        return repInfolist;
    }

    private List<VolumeReplicationCgInfo> getVolumeReplicationCgInfoFromRespStr(String respStr) {
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || jsonNode.path("replicationcgs").isMissingNode()) {
            logger.error((Object)"bad Request getVolumeReplicationCgInfo.");
            throw new LegoCheckedException(0x300001L);
        }
        List<VolumeReplicationCgInfo> repCgInfolist = JsonUtil.jsonArrayToList(jsonNode.path("replicationcgs").toString(), VolumeReplicationCgInfo.class);
        logger.debug((Object)("getVolumeReplicationCgInfo detail. response str=" + repCgInfolist.size()));
        return repCgInfolist;
    }

    private String getDetailUrl(Map<String, String> uriVariables, String projId) {
        if (VerifyUtil.isEmpty(uriVariables)) {
            return String.format(OpenstackEnumDefine.REQUEST_URL.DR_LIST_VOLREP_DETAILS.getUri(), projId);
        }
        return String.format(OpenstackEnumDefine.REQUEST_URL.DR_LIST_VOLREP_DETAILS_CG.getUri(), projId);
    }

    private String getSummaryUrl(Map<String, String> uriVariables, String projId) {
        if (VerifyUtil.isEmpty(uriVariables)) {
            return String.format(OpenstackEnumDefine.REQUEST_URL.DR_LIST_VOLREPS.getUri(), projId);
        }
        return String.format(OpenstackEnumDefine.REQUEST_URL.DR_LIST_VOLREPS_CG.getUri(), projId);
    }

    @Override
    public VolumeReplicationInfo queryVolumeReplication(String regionUuid, String tokenId, String projUuid, String replicationId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationId)) {
            logger.error((Object)"query volume replication failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_QUERY_VOLREP.getUri(), projId, replicationId);
        logger.debug((Object)("query volume replication.request str=" + newUrlStr));
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        logger.debug((Object)("query volume replication success. reponse str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("query volume replication failed.respStr is null.request str=" + newUrlStr + ", reponse str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            logger.error((Object)("query volume replication success.request str=" + newUrlStr + ", reponse str=" + respStr));
            return null;
        }
        if (jsonNode.path("replication").isMissingNode()) {
            logger.error((Object)("query volume replication failed.bad Request queryVolumeReplication.request str=" + newUrlStr + ", reponse str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        VolumeReplicationInfo info = JsonUtil.jsonToBean(jsonNode.path("replication").toString(), VolumeReplicationInfo.class);
        return info;
    }

    @Override
    public AsyncTaskResponse createVolumeReplication(VolumeReplicationInfo volReplicaCreateInfo, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)volReplicaCreateInfo)) {
            logger.error((Object)"Failed to create volume replication.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_CREATE_VOLREP.getUri(), projId);
        String tempStr = JsonUtil.beanToJson(volReplicaCreateInfo);
        JSONObject bodyJson = new JSONObject();
        bodyJson.put((Object)"replication", (Object)tempStr);
        String respStr = ClientUtil.sendPostRequest(newUrlStr, bodyJson.toString(), tokenId);
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(1073948407L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || jsonNode.path("replication").isMissingNode()) {
            logger.error((Object)("bad Request createVolumeReplication :" + volReplicaCreateInfo));
            throw new LegoCheckedException(1073948407L);
        }
        VolumeReplicationInfo info = JsonUtil.jsonToBean(jsonNode.path("replication").toString(), VolumeReplicationInfo.class);
        if (null == info) {
            logger.error((Object)("convert to VolumeReplicationInfo return null, Str=" + jsonNode.path("replication").toString()));
            throw new LegoCheckedException(0x300001L);
        }
        if (OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(info.getStatus())) {
            response.setSuccess(true);
            response.setTaskResult(info);
            return response;
        }
        return this.checkCreateVolReplicationResponse(regionUuid, tokenId, projUuid, info);
    }

    @Override
    protected AsyncTaskResponse deleteVolumeReplicationCall(String regionUuid, String tokenId, String projUuid, String replicationId, boolean isForce, boolean isSingleDel) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationId)) {
            logger.error((Object)"delete volume replication failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String message = this.getDelMessageBody(false, isForce, isSingleDel);
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_DELETE_VOLREP.getUri(), projId, replicationId);
        logger.debug((Object)("delete volume replication replicationId=" + replicationId + ",request str=" + newUrlStr));
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, message, tokenId);
        logger.debug((Object)("delete volume replication replicationId=" + replicationId + ",response str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeleteVolReplicationResponse(regionUuid, tokenId, projUuid, replicationId, isSingleDel);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            logger.error((Object)("delete volume replication success. replicationId=" + replicationId));
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        logger.error((Object)("delete volume replication replicationId=" + replicationId + " failed.bad Request.request str=" + newUrlStr + " ,response str=" + respStr));
        response.setErrorCode("3145729");
        return response;
    }

    @Override
    public List<VolumeReplicationCgInfo> getVolumeReplicationCGs(String regionUuid, String tokenId, String projUuid, Map<String, String> uriVariables, int ... retryTimes) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            logger.error((Object)("parameter is empty, regionUuid=" + regionUuid + " projUuid=" + projUuid));
            throw new LegoCheckedException(1073947393L);
        }
        String cacheKey = Joiner.on((String)"_@_").join((Object[])new String[]{OpenStackCommonUtil.getIdFromUuid(regionUuid), OpenStackCommonUtil.getIdFromUuid(projUuid)});
        if (OpenstackCache.containsKey(OpenstackCache.CacheType.OPENSTACK_REP_CG_LIST, cacheKey)) {
            List cgList = (List)OpenstackCache.getCache(OpenstackCache.CacheType.OPENSTACK_REP_CG_LIST, cacheKey);
            return new ArrayList<VolumeReplicationCgInfo>(cgList);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_LIST_VOLREPCG_DETAILS.getUri(), projId);
        ArrayList<VolumeReplicationCgInfo> repCgInfolist = new ArrayList<VolumeReplicationCgInfo>();
        if (VerifyUtil.isEmpty(uriVariables)) {
            uriVariables = new HashMap<String, String>();
        }
        String limit = String.valueOf(1000);
        uriVariables.put("limit", limit);
        int offset = 0;
        while (true) {
            uriVariables.put("offset", String.valueOf(offset));
            String respStr = ClientUtil.sendGetRequest(newUrlStr, uriVariables, tokenId, retryTimes);
            List<VolumeReplicationCgInfo> list = this.getVolumeReplicationCgInfoFromRespStr(respStr);
            repCgInfolist.addAll(list);
            if (list.size() < 1000) break;
            offset += 1000;
        }
        OpenstackCache.putCache(OpenstackCache.CacheType.OPENSTACK_REP_CG_LIST, cacheKey, new ArrayList(repCgInfolist));
        return repCgInfolist;
    }

    @Override
    public VolumeReplicationCgInfo queryVolumeReplicationCG(String regionUuid, String tokenId, String projUuid, String replicationCgId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            logger.error((Object)"Failed to query volume replicationcg.parameter is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_QUERY_VOLREPCG.getUri(), projId, OpenStackCommonUtil.getIdFromUuid(replicationCgId));
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        logger.debug((Object)(" query VolumeReplicationCG. request str=" + newUrlStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)(" query VolumeReplicationCG failed. response string is empty,request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        logger.debug((Object)("succeed querying VolumeReplicationCG. response str=" + respStr));
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            logger.error((Object)("query VolumeReplicationCG failed. jsonNode is null.response str=" + respStr));
            return null;
        }
        if (jsonNode.path("replicationcg").isMissingNode()) {
            logger.error((Object)("query VolumeReplicationCG failed,bad Request getVolumeReplicationCG.response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        logger.debug((Object)(" query VolumeReplicationCG succeed. response str=" + respStr));
        VolumeReplicationCgInfo info = JsonUtil.jsonToBean(jsonNode.path("replicationcg").toString(), VolumeReplicationCgInfo.class);
        return info;
    }

    @Override
    public VolumeReplicationCgInfo queryVolumeReplicationCGWithCache(String regionUuid, String tokenId, String projUuid, String replicationCgId, int ... retryTimes) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            logger.error((Object)("parameter is empty, regionUuid=" + regionUuid + " projUuid=" + projUuid + " replicationCgId=" + replicationCgId));
            throw new LegoCheckedException(1073947393L);
        }
        String cgId = OpenStackCommonUtil.getIdFromUuid(replicationCgId);
        List<VolumeReplicationCgInfo> cgList = this.getVolumeReplicationCGs(regionUuid, tokenId, projUuid, null, retryTimes);
        VolumeReplicationCgInfo info = cgList.stream().filter(cgInfo -> cgId.equals(cgInfo.getId())).findFirst().orElse(null);
        return info;
    }

    public VhaCsdrRingInfo queryVolumeReplicationRing(String regionUuid, String tokenId, String projUuid, String replicationRingId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationRingId)) {
            logger.error((Object)"Failed to query volume replication ring detail.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_QUERY_REPLICATION_RING.getUri(), projId, OpenStackCommonUtil.getIdFromUuid(replicationRingId));
        logger.debug((Object)("Query volume replication ring detail.request str=" + newUrlStr));
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        logger.debug((Object)("Query volume replication ring detail.response str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("Failed to query volume replication ring detail.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            logger.error((Object)("Failed to query volume replication ring detail.jsonNode string is empty or missing.request str=" + newUrlStr + ", response str=" + respStr));
            return null;
        }
        if (jsonNode.path("dr_star").isMissingNode()) {
            logger.error((Object)("Failed to query volume replication ring detail.bad Request getReplicationRing.request str=" + newUrlStr + ", response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        VhaCsdrRingInfo info = JsonUtil.jsonToBean(jsonNode.path("dr_star").toString(), VhaCsdrRingInfo.class);
        return info;
    }

    @Override
    public VolumeReplicationCgInfo queryRealtimeVolumeReplicationCG(String regionUuid, String tokenId, String projUuid, String replicationCgId, int ... retryParams) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            logger.error((Object)"Failed to query realtime volumeReplicationCG.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_QUERY_VOLREPCG_REAL.getUri(), projId, OpenStackCommonUtil.getIdFromUuid(replicationCgId));
        logger.debug((Object)("Query realtime volumeReplicationCG.request str=" + newUrlStr));
        String respStr = ClientUtil.sendGetRequest(newUrlStr, null, tokenId, retryParams);
        logger.debug((Object)("Query realtime volumeReplicationCG.response str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("Failed to query realtime volumeReplicationCG.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            return null;
        }
        if (jsonNode.path("replicationcg").isMissingNode()) {
            logger.error((Object)("Failed to query realtime volumeReplicationCG.bad Request queryRealtimeVolumeReplicationCG.request str=" + newUrlStr + ", response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        VolumeReplicationCgInfo info = JsonUtil.jsonToBean(jsonNode.path("replicationcg").toString(), VolumeReplicationCgInfo.class);
        return info;
    }

    @Override
    public AsyncTaskResponse createVolumeReplicationCG(VolReplicaCgCreateInfo createRepCgInfo, String regionUuid, String tokenId, String projUuid) {
        List<VolumeReplicationInfo> replicationInfos;
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)createRepCgInfo)) {
            logger.error((Object)"Parameter is empty, regionUuid:%s, projUuid:%s, createRepCgInfo:%s,protectGroup name:%s", new Object[]{regionUuid, projUuid, createRepCgInfo, createRepCgInfo.getName()});
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_CREATE_VOLREPCG.getUri(), projId);
        String tempStr = JsonUtil.beanToJson(createRepCgInfo);
        JSONObject requestJson = new JSONObject();
        requestJson.put((Object)"replicationcg", (Object)tempStr);
        logger.debug((Object)("create replicationcg request str=" + tempStr + ",protectGroup name=" + createRepCgInfo.getName()));
        String respStr = ClientUtil.sendPostRequest(newUrlStr, requestJson.toString(), tokenId);
        logger.debug((Object)("create replicationcg response str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("create replicationcg failed.response string is empty. createRepCgInfo=" + createRepCgInfo + ", request str=" + tempStr + ",protectGroup name=" + createRepCgInfo.getName()));
            throw new LegoCheckedException(1073948407L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || jsonNode.path("replicationcg").isMissingNode()) {
            logger.error((Object)("create replicationcg failed.bad Request createVolumeReplicationCG, createRepCgInfo:" + createRepCgInfo + ", request str=" + tempStr + " request str=" + tempStr + ",protectGroup name=" + createRepCgInfo.getName()));
            throw new LegoCheckedException(1073948407L);
        }
        HashSet<String> addReplications = new HashSet<String>(OpenStackCommonUtil.getListFromStr(createRepCgInfo.getReplications(), ","));
        logger.info((Object)("addReplications" + addReplications));
        VolumeReplicationCgInfo info = JsonUtil.jsonToBean(jsonNode.path("replicationcg").toString(), VolumeReplicationCgInfo.class);
        if (null == info) {
            logger.error((Object)("create replicationcg failed.convert to VolumeReplicationCgInfo return null, response str=" + respStr + " request str=" + tempStr + ",protectGroup name=" + createRepCgInfo.getName()));
            throw new LegoCheckedException(0x300001L);
        }
        if (OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(info.getStatus()) && this.checkReplicationInCG(replicationInfos = this.getRepsByRepCgId(info.getId(), regionUuid, tokenId, projUuid), addReplications, null)) {
            logger.info((Object)("create replicationcg success.Added replications is ReplicationCG, queryed replicationInfos=" + replicationInfos + ",added Replications" + addReplications + ",protectGroup name=" + createRepCgInfo.getName()));
            response.setSuccess(true);
            response.setTaskResult(info);
            return response;
        }
        return this.checkCreateVolReplicationCGResponse(regionUuid, tokenId, projUuid, info, addReplications);
    }

    public AsyncTaskResponse createVolumeReplicationRing(CreateVhaCsdrRingInfo createRepRingInfo, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)createRepRingInfo)) {
            logger.error((Object)("create volume replication ring.parameter is empty, protectGroup name=" + createRepRingInfo.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_CREATE_RING_ACTION.getUri(), projId);
        logger.debug((Object)("create volume replication ring.request str=" + newUrlStr + ", protectGroup name=" + createRepRingInfo.getName()));
        String tempStr = JsonUtil.beanToJson(createRepRingInfo);
        JSONObject requestJson = new JSONObject();
        requestJson.put((Object)"dr_star", (Object)tempStr);
        String respStr = ClientUtil.sendPostRequest(newUrlStr, requestJson.toString(), tokenId);
        logger.debug((Object)("create volume replication ring.reponse str=" + respStr + ", protectGroup name=" + createRepRingInfo.getName()));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("create volume replication ring failed.response string is empty.reponse str=" + respStr + ", protectGroup name=" + createRepRingInfo.getName() + ", request str=" + newUrlStr));
            throw new LegoCheckedException(1073948140L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || jsonNode.path("dr_star").isMissingNode()) {
            logger.error((Object)("create volume replication ring failed.bad Request createVolumeReplicationRing :" + createRepRingInfo + "reponse str=" + respStr + ", protectGroup name=" + createRepRingInfo.getName() + ", request str=" + newUrlStr));
            throw new LegoCheckedException(1073948140L);
        }
        List<String> addReplicationCGList = OpenStackCommonUtil.getListFromStr(createRepRingInfo.getReplicationcgs(), ",");
        HashSet<String> addReplicationUUIDCGs = new HashSet<String>();
        for (String cgID : addReplicationCGList) {
            addReplicationUUIDCGs.add(OpenStackCommonUtil.getIdFromUuid(cgID));
        }
        logger.debug((Object)("addReplicationUUIDCGs" + addReplicationUUIDCGs + "protectGroup name=" + createRepRingInfo.getName()));
        VhaCsdrRingInfo info = JsonUtil.jsonToBean(jsonNode.path("dr_star").toString(), VhaCsdrRingInfo.class);
        if (null == info) {
            logger.error((Object)("create volume replication ring failed.convert to VhaCsdrRingInfo return null, str=" + jsonNode.path("replicationcg").toString() + ",protectGroup name=" + createRepRingInfo.getName()));
            throw new LegoCheckedException(0x300001L);
        }
        return this.checkCreateVolReplicationRingResponse(regionUuid, tokenId, projUuid, info, addReplicationUUIDCGs);
    }

    @Override
    public AsyncTaskResponse updateVolumeReplicationCG(VolReplicaCgUpdateInfo updateRepCgInfo, String replicationCgId, String regionUuid, String tokenId, String projUuid) {
        List<VolumeReplicationInfo> replicationInfos;
        if (VerifyUtil.isEmpty((String)replicationCgId) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)updateRepCgInfo)) {
            logger.error((Object)"update volume replication CG failed.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_UPDATE_VOLREPCG.getUri(), projId, replicationCgId);
        String tempStr = JsonUtil.beanToJson(updateRepCgInfo);
        JSONObject requestJson = new JSONObject();
        requestJson.put((Object)"replicationcg", (Object)tempStr);
        logger.debug((Object)("update volume replication CG .request url=" + newUrlStr + ",cgid=" + replicationCgId));
        logger.debug((Object)("update volume replication CG .request stringBody=" + tempStr + ",cgid=" + replicationCgId));
        String respStr = ClientUtil.sendPutRequest(newUrlStr, requestJson.toString(), tokenId);
        logger.debug((Object)("update volume replication CG .response stringBody=" + respStr + ",cgid=" + replicationCgId));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)("update volume replication CG failed.response string is empty.request url=" + newUrlStr + ",cgid=" + replicationCgId));
            throw new LegoCheckedException(0x300001L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            logger.error((Object)("update volume replication CG failed.request url=" + newUrlStr + ", request stringBody=" + tempStr + ", response stringBody=" + respStr + ", cgid=" + replicationCgId));
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        if (jsonNode.path("replicationcg").isMissingNode()) {
            logger.error((Object)("update volume replication CG failed.bad Request updateVolumeReplicationCG.request url=" + newUrlStr + ", request stringBody=" + tempStr + ", response stringBody=" + respStr + ", cgid=" + replicationCgId));
            response.setSuccess(false);
            response.setErrorCode("3145729");
            return response;
        }
        HashSet<String> addReplications = new HashSet<String>(OpenStackCommonUtil.getListFromStr(updateRepCgInfo.getAddReplicas(), ","));
        HashSet<String> removeReplications = new HashSet<String>(OpenStackCommonUtil.getListFromStr(updateRepCgInfo.getRemoveReplicas(), ","));
        VolumeReplicationCgInfo info = JsonUtil.jsonToBean(jsonNode.path("replicationcg").toString(), VolumeReplicationCgInfo.class);
        if (null == info) {
            logger.error((Object)("update volume replication CG failed.convert to VolumeReplicationCgInfo return null.request url=" + newUrlStr + ", request stringBody=" + tempStr + ", response stringBody=" + respStr + ", cgid=" + replicationCgId));
            throw new LegoCheckedException(0x300001L);
        }
        if (OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(info.getStatus()) && this.checkReplicationInCG(replicationInfos = this.getRepsByRepCgId(info.getId(), regionUuid, tokenId, projUuid), addReplications, removeReplications)) {
            logger.info((Object)("update volume replication CG succeed.cgid=" + info.getId()));
            response.setSuccess(true);
            response.setTaskResult(info.getId());
            return response;
        }
        return this.checkUpdateVolReplicationCGResponse(regionUuid, tokenId, projUuid, info.getId(), addReplications, removeReplications);
    }

    @Override
    public AsyncTaskResponse updateReplicationCGBandwidth(DmEnumDefine.SPEED_LEVEL_E speed, String replicationCgId, String regionUuid, String tokenId, String projUuid) {
        String message;
        if (VerifyUtil.isEmpty((String)replicationCgId) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_UPDATE_VOLREPCG.getUri(), projId, replicationCgId);
        String respStr = ClientUtil.sendPutRequest(newUrlStr, message = "{\"replicationcg\":{\"replication_bandwidth\":" + speed.getValue() + "}}", tokenId);
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        if (jsonNode.path("replicationcg").isMissingNode()) {
            logger.error((Object)("bad Request updateVolumeReplicationCG :" + respStr));
            response.setSuccess(false);
            response.setErrorCode("3145729");
            return response;
        }
        VolumeReplicationCgInfo info = JsonUtil.jsonToBean(jsonNode.path("replicationcg").toString(), VolumeReplicationCgInfo.class);
        if (null == info) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        if (OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(info.getStatus()) && speed.getValue() == info.getReplicaBandwidth()) {
            response.setSuccess(true);
            response.setTaskResult(info.getId());
            return response;
        }
        return this.checkUpdateCGBandwidthResponse(regionUuid, tokenId, projUuid, info.getId(), speed.getValue());
    }

    private AsyncTaskResponse checkUpdateCGBandwidthResponse(final String regionUuid, final String tokenId, final String projUuid, final String replicationCgId, final int speed) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(replicationCgId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationCgInfo cg = DrExtendManager.this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationCgId);
                if (null == cg) {
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(cg.getStatus())) {
                    if (speed == cg.getReplicaBandwidth()) {
                        response.setSuccess(true);
                        response.setTaskResult(replicationCgId);
                        return true;
                    }
                } else if (!OpenstackEnumDefine.REPLICATION_STATUS_E.UPDATING.getValue().equals(cg.getStatus())) {
                    logger.error((Object)("cg status is not excepted, excepted status: available, current status : " + cg.getStatus() + ", cg id: " + replicationCgId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public AsyncTaskResponse updateReplicationCGRecoverStrategy(OpenstackEnumDefine.RecoverStrategy recoverStrategy, String replicationCgId, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((Object)recoverStrategy)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)replicationCgId) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        replicationCgId = OpenStackCommonUtil.getIdFromUuid(replicationCgId);
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_UPDATE_VOLREPCG.getUri(), projId, replicationCgId);
        AsyncTaskResponse response = new AsyncTaskResponse();
        VolumeReplicationCgInfo currentCg = this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationCgId);
        if (this.checkRecoverStrategy(currentCg, recoverStrategy)) {
            response.setSuccess(true);
            response.setTaskResult(currentCg.getId());
            return response;
        }
        String message = "{\"replicationcg\":{\"recover_strategy\":\"" + recoverStrategy.getUpdateVal() + "\"}}";
        String respStr = ClientUtil.sendPutRequest(newUrlStr, message, tokenId);
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || !jsonNode.path("itemNotFound").isMissingNode()) {
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        if (jsonNode.path("replicationcg").isMissingNode()) {
            logger.error((Object)("bad Request updateVolumeReplicationCG :" + respStr));
            response.setSuccess(false);
            response.setErrorCode("3145729");
            return response;
        }
        VolumeReplicationCgInfo info = JsonUtil.jsonToBean(jsonNode.path("replicationcg").toString(), VolumeReplicationCgInfo.class);
        if (null == info) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        if (OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(info.getStatus()) && this.checkRecoverStrategy(info, recoverStrategy)) {
            response.setSuccess(true);
            response.setTaskResult(info.getId());
            return response;
        }
        return this.checkUpdateCGRecoverStrategyResponse(regionUuid, tokenId, projUuid, info.getId(), recoverStrategy);
    }

    private AsyncTaskResponse checkUpdateCGRecoverStrategyResponse(final String regionUuid, final String tokenId, final String projUuid, final String replicationCgId, final OpenstackEnumDefine.RecoverStrategy recoverStrategy) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(replicationCgId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationCgInfo cg = DrExtendManager.this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationCgId);
                if (null == cg) {
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(cg.getStatus())) {
                    if (DrExtendManager.this.checkRecoverStrategy(cg, recoverStrategy)) {
                        response.setSuccess(true);
                        response.setTaskResult(replicationCgId);
                        return true;
                    }
                } else if (!OpenstackEnumDefine.REPLICATION_STATUS_E.UPDATING.getValue().equals(cg.getStatus())) {
                    logger.error((Object)("cg status is not excepted, excepted status: available, current status : " + cg.getStatus() + ", cg id: " + replicationCgId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private boolean checkRecoverStrategy(VolumeReplicationCgInfo cg, OpenstackEnumDefine.RecoverStrategy recoverStrategy) {
        JSONObject jSONObject;
        String replicationExtendedStatus = cg.getReplicationExtendedStatus();
        if (!VerifyUtil.isEmpty((String)replicationExtendedStatus) && (jSONObject = JSONObject.fromObject((Object)replicationExtendedStatus)).containsKey((Object)"recover_strategy")) {
            String strategy = jSONObject.getString("recover_strategy");
            if (recoverStrategy.getQueryVal().equals(strategy)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public AsyncTaskResponse deleteVolumeReplicationCG(String regionUuid, String tokenId, String projUuid, String replicationCgId, boolean isForce, boolean isSingleDel) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            logger.error((Object)"Failed to delete volumeReplicationCG.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String message = this.getDelMessageBody(true, isForce, isSingleDel);
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_DELETE_VOLREPCG.getUri(), projId, replicationCgId);
        logger.debug((Object)("Delete volumeReplicationCG.request str=" + newUrlStr));
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, message, tokenId);
        logger.debug((Object)("Delete volumeReplicationCG.reponse str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeleteVolReplicationCGResponse(regionUuid, tokenId, projUuid, replicationCgId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        logger.error((Object)("Faild to delete volumeReplicationCG.bad Request deleteVolumeReplicationCG: " + replicationCgId + "request str=" + newUrlStr + ", reponse str=" + respStr));
        response.setErrorCode("3145729");
        return response;
    }

    private String getDelMessageBody(boolean isCg, boolean isForce, boolean isSingleDel) {
        JSONObject ret = new JSONObject();
        JSONObject bodyJson = new JSONObject();
        bodyJson.put((Object)"force", (Object)Boolean.toString(isForce));
        bodyJson.put((Object)"single_delete", (Object)Boolean.toString(isSingleDel));
        String key = "replicationcg";
        if (!isCg) {
            key = "replication";
        }
        ret.put((Object)key, (Object)bodyJson);
        return ret.toString();
    }

    @Override
    public AsyncTaskResponse syncVolumeReplicationCG(String regionUuid, String tokenId, String projUuid, String replicationCgId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            logger.error((Object)"Failed to sync volumeReplicationCG.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String newReplicationCgId = OpenStackCommonUtil.getIdFromUuid(replicationCgId);
        VolumeReplicationCgInfo cg = this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, newReplicationCgId);
        if (null == cg) {
            logger.error((Object)("Failed to sync volumeReplicationCG.cg is empty.cgid=" + replicationCgId));
            throw new LegoCheckedException(2117645L);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(cg.getReplicationStatus())) {
            response.setSuccess(true);
            return response;
        }
        if (!OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(cg.getStatus()) || !OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue().equals(cg.getReplicationStatus()) && !OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVESTOPPED.getValue().equals(cg.getReplicationStatus()) && !OpenstackEnumDefine.REPLICATION_REP_STATUS_E.INACTIVE.getValue().equals(cg.getReplicationStatus())) {
            logger.error((Object)("Failed to sync volumeReplicationCG.cgid=" + replicationCgId + ",cg status is=" + cg.getStatus() + ",not avaiable. or cg replicationStatus is " + cg.getReplicationStatus() + ", not active or inactive or activestopped status."));
            if ("hypermetro".equals(cg.getReplicaModel())) {
                throw new LegoCheckedException(1073949707L, new String[]{newReplicationCgId});
            }
            throw new LegoCheckedException(1073949708L, new String[]{newReplicationCgId});
        }
        String message = "{\"os-sync-replicationcg\":{}}";
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_VOLREPCG_ACTION.getUri(), projId, newReplicationCgId);
        logger.debug((Object)("Sync volumeReplicationCG.request str=" + newUrlStr));
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        logger.debug((Object)("Sync volumeReplicationCG.response str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            response.setSuccess(true);
            return response;
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        response.setSuccess(false);
        if (json.containsKey((Object)"itemNotFound")) {
            logger.error((Object)("Failed to sync volumeReplicationCG.itemNotFound :replicationCgId=" + replicationCgId));
            response.setErrorCode("2117645");
            return response;
        }
        logger.error((Object)("Failed to sync volumeReplicationCG.bad Request SyncVolumeReplicationCG :replicationCgId=" + replicationCgId + ", request str=" + newUrlStr + ", response str=" + respStr));
        response.setErrorCode("3145729");
        return response;
    }

    @Override
    public AsyncTaskResponse splitVolumeReplicationCG(String regionUuid, String tokenId, String projUuid, String replicationCgId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            logger.error((Object)"Failed to split volumeReplicationCG.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String message = "{\"os-failover-replicationcg\":{}}";
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_VOLREPCG_ACTION.getUri(), projId, replicationCgId);
        logger.debug((Object)("Split volumeReplicationCG.request str=" + newUrlStr));
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        logger.debug((Object)("Split volumeReplicationCG.response str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkSplitVolReplicationCGResponse(regionUuid, tokenId, projUuid, replicationCgId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            logger.error((Object)("Failed to split volumeReplicationCG.itemNotFound :" + replicationCgId + ", request str=" + newUrlStr));
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        return this.checkSplitVolReplicationCGResponse(regionUuid, tokenId, projUuid, replicationCgId);
    }

    @Override
    public AsyncTaskResponse splitRingVolumeReplicationCG(String regionUuid, String tokenId, String projUuid, String replicationCgId, String ringeID, String readWritePolicy) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicationCgId)) {
            logger.error((Object)"Failed to split ring volumeReplicationCG.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String message = this.getSplitRingMessageBody(replicationCgId, readWritePolicy);
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_VOLREPCG_RING_ACTION.getUri(), projId, ringeID);
        logger.debug((Object)("split ring volumeReplicationCG.request str=" + newUrlStr + ", message body=" + message));
        String respStr = ClientUtil.sendPostRequest(newUrlStr, message, tokenId);
        logger.debug((Object)("split ring volumeReplicationCG.respStr str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkSplitVolReplicationCGResponse(regionUuid, tokenId, projUuid, replicationCgId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            logger.error((Object)("Failed to split ring volumeReplicationCG.itemNotFound :" + replicationCgId + ", request str=" + newUrlStr));
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        return this.checkSplitVolReplicationCGResponse(regionUuid, tokenId, projUuid, replicationCgId);
    }

    private String getSplitRingMessageBody(String replicationCgId, String readWritePolicy) {
        JSONObject ret = new JSONObject();
        JSONObject bodyJson = new JSONObject();
        bodyJson.put((Object)"replicationcg_id", (Object)replicationCgId);
        bodyJson.put((Object)"read_write_policy", (Object)readWritePolicy);
        String key = "os-failover-star";
        ret.put((Object)key, (Object)bodyJson);
        return ret.toString();
    }

    @Override
    public List<OpenStackStorageResourcePool> getStoragePoolInfo(String regionUuid, String tokenId, String projUuid, boolean queryDetail) {
        String respStr;
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_LIST_STORAGEPOOLS.getUri(), projId);
        if (queryDetail) {
            uriVariables.put("detail", "true");
        }
        if (VerifyUtil.isEmpty((String)(respStr = ClientUtil.sendGetRequest(newUrlStr, uriVariables, tokenId, new int[0])))) {
            logger.error((Object)("Failed to get storage pool info.response string is empty.request str=" + newUrlStr));
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"pools")) {
            logger.error((Object)("Failed to get storage pool info.bad Request getStoragePoolInfo.request str=" + newUrlStr + ",response str=" + respStr));
            throw new LegoCheckedException(0x300001L);
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        List<StoragePoolInfo> poolInfoList = this.getPoolBeanFromJson(json);
        ArrayList<OpenStackStorageResourcePool> openstackPoolList = new ArrayList<OpenStackStorageResourcePool>();
        for (StoragePoolInfo pool : poolInfoList) {
            OpenStackStorageResourcePool resPool = new OpenStackStorageResourcePool(pool);
            int hashcode = OpenStackCommonUtil.generateHashCode(regionUuid, projUuid, pool.getName());
            resPool.setUuid(openstackUuid + ":" + hashcode);
            resPool.setRegionUuid(regionUuid);
            resPool.setProjectUuid(projUuid);
            openstackPoolList.add(resPool);
        }
        return openstackPoolList;
    }

    private List<StoragePoolInfo> getPoolBeanFromJson(JSONObject json) {
        ArrayList<StoragePoolInfo> poolList = new ArrayList<StoragePoolInfo>();
        JSONArray poolArray = JSONArray.fromObject((Object)json.get("pools"));
        int zize = poolArray.size();
        for (int i = 0; i < zize; ++i) {
            JSONObject poolJson = poolArray.getJSONObject(i);
            StoragePoolInfo pool = (StoragePoolInfo)JSONObject.toBean((JSONObject)poolJson, StoragePoolInfo.class);
            poolList.add(pool);
        }
        return poolList;
    }

    @Override
    public List<VolumeReplicationInfo> getRepsByRepCgId(String replicationCgId, String regionUuid, String tokenId, String projUuid) {
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("replicationcg_id", replicationCgId);
        return this.getVolumeReplications(regionUuid, tokenId, projUuid, uriVariables, true);
    }

    private AsyncTaskResponse checkDeleteVolReplicationCGResponse(final String regionUuid, final String tokenId, final String projUuid, final String replicationCgId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponseTimeout(replicationCgId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationCgInfo cg = DrExtendManager.this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationCgId);
                if (null == cg) {
                    response.setSuccess(true);
                    return true;
                }
                if (!REPLICATION_CAN_DELETE_STATUS.contains(cg.getStatus())) {
                    logger.error((Object)("cg status is not excepted, excepted status: deleting or avaiable or error_deleting or error, current status : " + cg.getStatus() + ", cg id: " + replicationCgId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkCreateVolReplicationResponse(final String regionUuid, final String tokenId, final String projUuid, final VolumeReplicationInfo info) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(info, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationInfo replication = DrExtendManager.this.queryVolumeReplication(regionUuid, tokenId, projUuid, info.getId());
                if (null == replication) {
                    logger.error((Object)("Failed to check create volReplication.replication is null.replicationID=" + info.getId()));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(replication.getStatus())) {
                    response.setSuccess(true);
                    response.setTaskResult(replication);
                    return true;
                }
                if (!OpenstackEnumDefine.REPLICATION_STATUS_E.CREATING.getValue().equals(replication.getStatus())) {
                    logger.error((Object)("replication status is not excepted, excepted status: available, current status : " + replication.getStatus() + ", replication id: " + info.getId()));
                    response.setSuccess(false);
                    response.setTaskResult(replication);
                    response.setErrorCode("1073948407");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkCreateVolReplicationCGResponse(final String regionUuid, final String tokenId, final String projUuid, final VolumeReplicationCgInfo replicationCg, final Set<String> replicationSet) {
        Long inputRetryTimes = null;
        if (!VerifyUtil.isEmpty(replicationSet)) {
            inputRetryTimes = 60000L * (long)replicationSet.size() / 10000L;
            logger.debug((Object)"checkCreateVolReplicationCGResponse inputRetryTimes:%s", new Object[]{String.valueOf(inputRetryTimes)});
        }
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponseTimeout(replicationCg, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                logger.info((Object)("start query VolumeReplicationCG,cg id=" + replicationCg.getId() + "protectGroup name=" + replicationCg.getName()));
                VolumeReplicationCgInfo cg = DrExtendManager.this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationCg.getId());
                if (null == cg) {
                    logger.error((Object)("query VolumeReplicationCG failed,cg is null, cg id=" + replicationCg.getId() + "protectGroup name=" + replicationCg.getName()));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(cg.getStatus())) {
                    List<VolumeReplicationInfo> replicationInfos = DrExtendManager.this.getRepsByRepCgId(replicationCg.getId(), regionUuid, tokenId, projUuid);
                    if (DrExtendManager.this.checkReplicationInCG(replicationInfos, replicationSet, null)) {
                        logger.info((Object)("query VolumeReplicationCG success.Added replication is in ReplicationCG.cg id=" + replicationCg.getId() + "Query replicationInfos=" + replicationInfos + ",add replicationids=" + replicationSet.toString() + "protectGroup name=" + replicationCg.getName()));
                        response.setSuccess(true);
                        response.setTaskResult(cg);
                        return true;
                    }
                } else if (!OpenstackEnumDefine.REPLICATION_STATUS_E.CREATING.getValue().equals(cg.getStatus())) {
                    logger.error((Object)("query VolumeReplicationCG failed.cg status is not excepted, excepted status: available, current status : " + cg.getStatus() + ", cg id: " + replicationCg.getId() + "protectGroup name=" + replicationCg.getName()));
                    response.setSuccess(false);
                    response.setTaskResult(replicationCg);
                    response.setErrorCode("1073948407");
                    return true;
                }
                logger.debug((Object)("queryed VolumeReplicationCG,cg id=" + replicationCg.getId() + ", cg info=" + cg + "protectGroup name=" + replicationCg.getName()));
                return false;
            }
        }, inputRetryTimes);
        return response;
    }

    private AsyncTaskResponse checkCreateVolReplicationRingResponse(final String regionUuid, final String tokenId, final String projUuid, final VhaCsdrRingInfo replicationRing, final Set<String> replicationSet) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponseTimeout(replicationRing, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VhaCsdrRingInfo ringInfo = DrExtendManager.this.queryVolumeReplicationRing(regionUuid, tokenId, projUuid, replicationRing.getId());
                if (null == ringInfo) {
                    logger.error((Object)("check create replication ring failed. ringinfo is null,protectGroup name=" + replicationRing.getName()));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(ringInfo.getStatus())) {
                    if (DrExtendManager.this.checkReplicationCGInRing(ringInfo, replicationSet, null)) {
                        logger.info((Object)("check create replication ring succeed,protectGroup name=" + replicationRing.getName() + ", ringID=" + ringInfo.getId()));
                        response.setSuccess(true);
                        response.setTaskResult(ringInfo);
                        return true;
                    }
                    logger.error((Object)("check create replication ring failed.ring status is created, cg id of ring is expected. expeteced CG ID is" + replicationSet.toString() + ", cg id of current created ring is " + ringInfo.getReplicationcgLists().toString() + ", protectGroup name=" + replicationRing.getName() + ", ring id: " + ringInfo.getId()));
                    response.setSuccess(false);
                    response.setTaskResult(ringInfo);
                    response.setErrorCode("1073948140");
                    return true;
                }
                if (!OpenstackEnumDefine.REPLICATION_STATUS_E.CREATING.getValue().equals(ringInfo.getStatus())) {
                    logger.error((Object)("check create replication ring failed.ring status is not excepted, excepted status: available, current status : " + ringInfo.getStatus() + ", ring id: " + ringInfo.getId() + ", protectGroup name=" + replicationRing.getName()));
                    response.setSuccess(false);
                    response.setTaskResult(ringInfo);
                    response.setErrorCode("1073948140");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private AsyncTaskResponse checkUpdateVolReplicationCGResponse(final String regionUuid, final String tokenId, final String projUuid, final String replicationCgId, final Set<String> addReplications, final Set<String> removeReplications) {
        Long inputRetryTimes = null;
        int pairSize = 0;
        if (!VerifyUtil.isEmpty(addReplications)) {
            pairSize += addReplications.size();
        }
        if (!VerifyUtil.isEmpty(removeReplications)) {
            pairSize += removeReplications.size();
        }
        if (pairSize > 0) {
            inputRetryTimes = 60000L * (long)pairSize / 10000L;
            logger.debug((Object)"checkUpdateVolReplicationCGResponse inputRetryTimes:%s", new Object[]{String.valueOf(inputRetryTimes)});
        }
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponseTimeout(replicationCgId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationCgInfo cg = DrExtendManager.this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationCgId);
                if (null == cg) {
                    logger.info((Object)("check update volume replicationCG response,cg is null,cg id: " + replicationCgId));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(cg.getStatus())) {
                    List<VolumeReplicationInfo> replicationInfos = DrExtendManager.this.getRepsByRepCgId(replicationCgId, regionUuid, tokenId, projUuid);
                    if (DrExtendManager.this.checkReplicationInCG(replicationInfos, addReplications, removeReplications)) {
                        logger.info((Object)("check update volume replicationCG response succeed,cg id: " + replicationCgId));
                        response.setSuccess(true);
                        response.setTaskResult(replicationCgId);
                        return true;
                    }
                } else if (!OpenstackEnumDefine.REPLICATION_STATUS_E.UPDATING.getValue().equals(cg.getStatus())) {
                    logger.error((Object)("check update volume replicationCG response failed.cg status is not excepted, excepted status: available, current status : " + cg.getStatus() + ", cg id: " + replicationCgId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                logger.debug((Object)("check update volume replicationCG response,cg id: " + replicationCgId + ",cginfo=" + cg));
                return false;
            }
        }, inputRetryTimes);
        return response;
    }

    private AsyncTaskResponse checkDeleteVolReplicationResponse(final String regionUuid, final String tokenId, final String projUuid, final String replicationId, final boolean isSingleDel) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(replicationId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationInfo replication = DrExtendManager.this.queryVolumeReplication(regionUuid, tokenId, projUuid, replicationId);
                if (null == replication) {
                    logger.error((Object)("check delete volume replication response success.repliation id: " + replicationId));
                    response.setSuccess(true);
                    return true;
                }
                if (!isSingleDel && !REPLICATION_CAN_DELETE_STATUS.contains(replication.getStatus())) {
                    logger.error((Object)("normal delete pair : repliation status is not excepted, excepted status: deleting or avaiable or error_deleting or error, current status : " + replication.getStatus() + ", repliation id: " + replicationId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                if (isSingleDel && !NORMAL_REPLICATION_CAN_DELETE_STATUS.contains(replication.getStatus())) {
                    logger.error((Object)("single delete pair : repliation status is not excepted, excepted status: deleting or avaiablecurrent status : " + replication.getStatus() + ", repliation id: " + replicationId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private boolean checkReplicationInCG(List<VolumeReplicationInfo> replicationInfos, Set<String> addReplications, Set<String> removeReplications) {
        if (null == replicationInfos) {
            logger.error((Object)"checkReplicationInCG failed. replicationInfos is null");
            return false;
        }
        logger.debug((Object)("start checkReplicationInCG, addReplications=" + addReplications.toString() + ", removeReplications=" + (removeReplications != null ? removeReplications.toString() : "") + "query replicationInfos=" + replicationInfos.toString()));
        HashSet<String> replicationIdSet = new HashSet<String>();
        for (VolumeReplicationInfo info : replicationInfos) {
            if (VerifyUtil.isEmpty((String)info.getId())) {
                logger.error((Object)("VolumeReplicationInfo id is null. volumeReplicationInfo =" + info));
                continue;
            }
            replicationIdSet.add(info.getId());
        }
        logger.debug((Object)("addReplications size =" + addReplications.size() + " query return:" + replicationIdSet));
        if (!VerifyUtil.isEmpty(addReplications) && !replicationIdSet.containsAll(addReplications)) {
            logger.error((Object)"addReplications size is not equal to query size");
            return false;
        }
        if (!VerifyUtil.isEmpty(removeReplications)) {
            for (String replicationId : removeReplications) {
                if (!replicationIdSet.contains(replicationId)) continue;
                logger.error((Object)("replicationId can not be removed from cg,replicationId=" + replicationId));
                return false;
            }
        }
        return true;
    }

    private boolean checkReplicationCGInRing(VhaCsdrRingInfo ringInfo, Set<String> addReplications, Set<String> removeReplications) {
        if (null == ringInfo) {
            logger.error((Object)"ringInfo is null");
            return false;
        }
        HashSet<String> replicationCGIdSet = new HashSet<String>();
        for (VolumeReplicationCgInfo info : ringInfo.getReplicationcgLists()) {
            if (VerifyUtil.isEmpty((String)info.getId())) continue;
            replicationCGIdSet.add(info.getId());
        }
        logger.debug((Object)("addReplications size =" + addReplications.size() + " query return:" + replicationCGIdSet + ", protectGroup name=" + ringInfo.getName()));
        if (!VerifyUtil.isEmpty(addReplications) && !replicationCGIdSet.containsAll(addReplications)) {
            logger.error((Object)("added cgs:" + addReplications + "not in ring" + replicationCGIdSet + ", protectGroup name=" + ringInfo.getName()));
            return false;
        }
        if (!VerifyUtil.isEmpty(removeReplications)) {
            for (String replicationId : removeReplications) {
                if (!replicationCGIdSet.contains(replicationId)) continue;
                logger.error((Object)("removed cgs:" + replicationId + "is in ring" + replicationCGIdSet + ", protectGroup name=" + ringInfo.getName()));
                return false;
            }
        }
        return true;
    }

    private AsyncTaskResponse checkSplitVolReplicationCGResponse(String regionUuid, String tokenId, String projUuid, String replicationCgId) {
        return AsyncTaskResponse.queryTaskResponse(replicationCgId, response -> {
            VolumeReplicationCgInfo cg = this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicationCgId);
            if (null == cg) {
                logger.error((Object)"Failed to check split volume replicationCG. Cg not found, cg id:%s", new Object[]{replicationCgId});
                response.setSuccess(false);
                response.setErrorCode("2117645");
                return true;
            }
            String status = cg.getStatus();
            if (!OpenstackEnumDefine.REPLICATION_STATUS_E.FAILOVERING.getValue().equals(status) && !OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(status)) {
                logger.error((Object)"Failed to check split volume replicationCG. Cg status is not excepted, excepted status: failovering or available, current status:%s, cg id:%s", new Object[]{status, replicationCgId});
                response.setSuccess(false);
                response.setErrorCode("3145729");
                return true;
            }
            String replicationStatus = cg.getReplicationStatus();
            if (OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(status) && (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVESTOPPED.getValue().equals(replicationStatus) || OpenstackEnumDefine.REPLICATION_REP_STATUS_E.INACTIVE.getValue().equals(replicationStatus))) {
                String failoverRet = this.getCgFailoverRet(cg);
                if (OpenstackEnumDefine.REPLICATION_STATUS_E.FAILOVER_RET_FAILED.getValue().equals(failoverRet)) {
                    logger.error((Object)"Failed to check split volume replicationCG. Cg Status:%s, Cg ReplicationStatus:%s, Cg FailoverRet is:%s", new Object[]{status, replicationStatus, failoverRet});
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                } else {
                    response.setSuccess(true);
                }
                return true;
            }
            logger.debug((Object)"Failed to check split volume replicationCG. Cg ReplicationExtendedStatus status is not excepted, excepted status: split, current status:%s, cg id:%s", new Object[]{replicationStatus, replicationCgId});
            return false;
        });
    }

    private String getCgFailoverRet(VolumeReplicationCgInfo cg) {
        String driverDataStr = cg.getReplicationDriverData();
        if (!VerifyUtil.isEmpty((String)driverDataStr)) {
            ReplicationDriverDataInfo driverData = JsonUtil.jsonToBean(driverDataStr, ReplicationDriverDataInfo.class);
            return driverData != null ? driverData.getFailoverRet() : "";
        }
        return "";
    }

    @Override
    public AsyncTaskResponse reverseVolumeReplicationCG(boolean replicationMaster, String replicaCgUuid, String regionUuid, String tokenId, String projUuid) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)replicaCgUuid)) {
            logger.error((Object)"Failed to reverse volume replicationCG.parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String replicaCgId = OpenStackCommonUtil.getIdFromUuid(replicaCgUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_REVERSE_VOLREPCG.getUri(), projId, replicaCgId);
        String msg = "{\"os-reverse-replicationcg\":{\"replication_master\":" + replicationMaster + "}}";
        logger.debug((Object)("Reverse volume replicationCG.request str=" + newUrlStr + ",message=" + msg));
        String respStr = ClientUtil.sendPostRequest(newUrlStr, msg, tokenId);
        logger.debug((Object)("Reverse volume replicationCG.respStr str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkReverseVolRepCg(regionUuid, tokenId, projUuid, replicaCgId, replicationMaster);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            logger.error((Object)("Failed to reverse volume replicationCG.itemNotFound. replicaCgId:" + replicaCgId + ", request str=" + newUrlStr + ",message=" + msg + ", respStr str=" + respStr));
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        return this.checkReverseVolRepCg(regionUuid, tokenId, projUuid, replicaCgId, replicationMaster);
    }

    private AsyncTaskResponse checkReverseVolRepCg(final String regionUuid, final String tokenId, final String projUuid, final String replicaCgId, final boolean replicationMaster) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(replicaCgId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationCgInfo cg = DrExtendManager.this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicaCgId);
                if (null == cg) {
                    logger.error((Object)("Failed to check reverse volumeReplicationCG.replicaCgId=" + replicaCgId));
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (cg.isMasterFlag() == replicationMaster) {
                    response.setSuccess(true);
                    response.setTaskResult(cg);
                    return true;
                }
                logger.error((Object)("Failed to check reverse volumeReplicationCG.cg (master)status is not excepted, excepted status: " + replicationMaster + ", current status : " + cg.isMasterFlag() + ", cg id: " + replicaCgId));
                return false;
            }
        });
        return response;
    }

    @Override
    public List<VolumeReplicationInfo> getRealtimeVolumeReplications(String regionUuid, String tokenId, String projUuid, Map<String, String> uriVariables) {
        if (VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)regionUuid)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<VolumeReplicationInfo> repInfolist = new ArrayList<VolumeReplicationInfo>();
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_LIST_VOLREPS_DETAILS_CG_REAL.getUri(), projId);
        String limit = String.valueOf(1000);
        if (VerifyUtil.isEmpty(uriVariables)) {
            uriVariables = new HashMap<String, String>();
        }
        uriVariables.put("limit", limit);
        int offset = 0;
        String respStr = null;
        while (true) {
            uriVariables.put("offset", String.valueOf(offset));
            respStr = ClientUtil.sendGetRequest(newUrlStr, uriVariables, tokenId, new int[0]);
            List<VolumeReplicationInfo> list = this.getVolumeRepliInfosFromRespStr(respStr);
            repInfolist.addAll(list);
            if (list.size() < 1000) break;
            offset += 1000;
        }
        return repInfolist;
    }

    @Override
    public AsyncTaskResponse openRing(String regionUuid, String tokenId, String projUuid, String ringID) {
        JSONObject ret = new JSONObject();
        ret.put((Object)"os-open-star", (Object)new JSONObject());
        String action = ret.toString();
        return this.sendRingAction(regionUuid, tokenId, projUuid, ringID, action);
    }

    @Override
    public AsyncTaskResponse closeRing(String regionUuid, String tokenId, String projUuid, String ringID, boolean singleClose) {
        String action = "{\"os-close-star\":{\"single_close\":" + singleClose + "}}";
        return this.sendRingAction(regionUuid, tokenId, projUuid, ringID, action);
    }

    private AsyncTaskResponse sendRingAction(String regionUuid, String tokenId, String projUuid, String ringID, String action) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)ringID)) {
            logger.error((Object)"Parameter is empty, regionUuid:%s, projUuid:%s, ringID:%s", new Object[]{regionUuid, projUuid, ringID});
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.RING_ACTION.getUri(), projId, OpenStackCommonUtil.getIdFromUuid(ringID));
        String respStr = ClientUtil.sendPostRequest(newUrlStr, action, tokenId);
        logger.debug((Object)("send Ring Action(open or close ring). request str=" + newUrlStr + ",response str=" + respStr));
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (VerifyUtil.isEmpty((String)respStr)) {
            response.setSuccess(true);
            return response;
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        response.setSuccess(false);
        logger.error((Object)("send Ring Action(open or close ring) faild. request str=" + newUrlStr + ",response str=" + respStr));
        if (json.containsKey((Object)"itemNotFound")) {
            logger.error((Object)("send Ring Action(open or close ring) faild.itemNotFound :" + ringID));
            response.setSuccess(false);
            response.setErrorCode("2117645");
        }
        return response;
    }

    @Override
    public AsyncTaskResponse deleteRing(String regionUuid, String tokenId, String projUuid, String ringId, boolean isForce, boolean isSingleDel) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)ringId)) {
            logger.error((Object)"Parameter is empty, regionUuid:%s, projUuid:%s, ringID:%s", new Object[]{regionUuid, projUuid, ringId});
            throw new LegoCheckedException(1073947393L);
        }
        String message = this.getDelRingMessageBody(isForce, isSingleDel);
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_DELETE_RING.getUri(), projId, ringId);
        logger.debug((Object)("Delete ring request str=" + newUrlStr));
        String respStr = ClientUtil.sendDeleteRequest(newUrlStr, message, tokenId);
        logger.debug((Object)("Delete ring reponse str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeleteRingResponse(regionUuid, tokenId, projUuid, ringId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (json.containsKey((Object)"itemNotFound")) {
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        logger.error((Object)("Failed to delete ring.bad Request deleteRing ringID: " + ringId + ", request str=" + newUrlStr + ", reponse str=" + respStr));
        response.setErrorCode("3145729");
        return response;
    }

    private String getDelRingMessageBody(boolean isForce, boolean isSingleDel) {
        JSONObject ret = new JSONObject();
        JSONObject bodyJson = new JSONObject();
        bodyJson.put((Object)"force", (Object)isForce);
        bodyJson.put((Object)"single_delete", (Object)isSingleDel);
        String key = "dr_star";
        ret.put((Object)key, (Object)bodyJson);
        return ret.toString();
    }

    private AsyncTaskResponse checkDeleteRingResponse(final String regionUuid, final String tokenId, final String projUuid, final String ringId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponseTimeout(ringId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VhaCsdrRingInfo ring = DrExtendManager.this.queryVolumeReplicationRing(regionUuid, tokenId, projUuid, ringId);
                if (null == ring) {
                    response.setSuccess(true);
                    return true;
                }
                if (!OpenstackEnumDefine.REPLICATION_STATUS_E.DELETING.getValue().equals(ring.getStatus())) {
                    logger.error((Object)("delete ring failed.ring status is not excepted, excepted status: deleting, current status : " + ring.getStatus() + ", ring id: " + ringId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                if (OpenstackEnumDefine.REPLICATION_STATUS_E.ERROR_DELETING.getValue().equals(ring.getStatus())) {
                    logger.error((Object)("delete ring failed, status : " + ring.getStatus() + ", ring id: " + ringId));
                    response.setSuccess(false);
                    response.setErrorCode("3145729");
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    @Override
    public void updateReplication(String regionUuid, String tokenId, String projUuid, VolumeReplicationInfo updateRepInfo) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((Object)updateRepInfo)) {
            logger.error((Object)"parameter is empty:regionUuid=%s,projUuid=%s,updateRepInfo=%s", new Object[]{regionUuid, projUuid, updateRepInfo});
            throw new LegoCheckedException(1073947393L);
        }
        String replicationId = OpenStackCommonUtil.getIdFromUuid(updateRepInfo.getId());
        String volumeId = OpenStackCommonUtil.getIdFromUuid(updateRepInfo.getVolumeId());
        if (VerifyUtil.isEmpty((String)replicationId) || VerifyUtil.isEmpty((String)volumeId)) {
            logger.error((Object)"parameter is empty:replicationId=%s,volumeId=%s", new Object[]{replicationId, volumeId});
            throw new LegoCheckedException(1073947393L);
        }
        VolumeReplicationInfo repInfo = this.queryVolumeReplication(regionUuid, tokenId, projUuid, replicationId);
        if (null == repInfo) {
            logger.error((Object)"replication:%s not found", new Object[]{replicationId});
            throw new LegoCheckedException(2117645L);
        }
        if (volumeId.equals(repInfo.getVolumeId())) {
            logger.info((Object)"replication:%s volume:%s is right", new Object[]{repInfo.getName(), repInfo.getVolumeId()});
            return;
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_QUERY_VOLREP.getUri(), projId, replicationId);
        JSONObject replicationJson = new JSONObject();
        replicationJson.put((Object)"volume_id", (Object)volumeId);
        JSONObject requestJson = new JSONObject();
        requestJson.put((Object)"replication", (Object)replicationJson);
        logger.debug((Object)"updateReplicationVolId.request url=%s, body=%s", new Object[]{newUrlStr, requestJson.toString()});
        String respStr = ClientUtil.sendPutRequest(newUrlStr, requestJson.toString(), tokenId);
        logger.debug((Object)"updateReplicationVolId success. reponse str=%s", new Object[]{respStr});
        repInfo = this.queryVolumeReplication(regionUuid, tokenId, projUuid, replicationId);
        if (null == repInfo) {
            logger.error((Object)"replication:%s not found", new Object[]{replicationId});
            throw new LegoCheckedException(2117645L);
        }
        if (!volumeId.equals(repInfo.getVolumeId())) {
            logger.error((Object)"replication:%s volume:%s is not modified", new Object[]{repInfo.getName(), repInfo.getVolumeId()});
            throw new LegoCheckedException(1073949697L, new String[]{replicationId});
        }
        logger.info((Object)"replication:%s volume:%s is right", new Object[]{repInfo.getName(), repInfo.getVolumeId()});
    }

    @Override
    public AsyncTaskResponse reverseRing(String regionUuid, String tokenId, String projUuid, String ringID, String replicationCgId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)ringID)) {
            logger.error((Object)"parameter is empty:regionUuid=%s,projUuid=%s,ringID=%s", new Object[]{regionUuid, projUuid, ringID});
            throw new LegoCheckedException(1073947393L);
        }
        String projId = OpenStackCommonUtil.getIdFromUuid(projUuid);
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "agent");
        String newUrlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.DR_DELETE_RING.getUri(), projId, ringID);
        logger.debug((Object)("reverse ring.request str=" + newUrlStr));
        String respStr = ClientUtil.sendPutRequest(newUrlStr, null, tokenId);
        logger.debug((Object)("reverse ring.respStr str=" + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkReverseRingResponse(regionUuid, tokenId, projUuid, ringID, replicationCgId);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            logger.error((Object)"Failed to reverse ring.itemNotFound :%s, request str:%s", new Object[]{replicationCgId, newUrlStr});
            AsyncTaskResponse response = new AsyncTaskResponse();
            response.setSuccess(false);
            response.setErrorCode("2117645");
            return response;
        }
        return this.checkReverseRingResponse(regionUuid, tokenId, projUuid, ringID, replicationCgId);
    }

    private AsyncTaskResponse checkReverseRingResponse(final String regionUuid, final String tokenId, final String projUuid, final String ringID, final String replicaCgId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(replicaCgId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                VolumeReplicationCgInfo cg = DrExtendManager.this.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, replicaCgId);
                if (null == cg) {
                    logger.error((Object)"Failed to check reverse ring.ringId is %s, normal replicaCgId is %s", new Object[]{ringID, replicaCgId});
                    response.setSuccess(false);
                    response.setErrorCode("2117645");
                    return true;
                }
                if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(cg.getReplicationStatus())) {
                    response.setSuccess(true);
                    response.setTaskResult(cg);
                    return true;
                }
                response.setSuccess(false);
                response.setErrorCode(String.valueOf(1073949719L));
                response.setErrorParameter(new String[]{ringID});
                logger.error((Object)"Failed to check reverse Ring.cg (master)status is not excepted, excepted status: standby, current replication status : %s, ring id: %s, checked cg id:%s", new Object[]{cg.getReplicationStatus(), ringID, replicaCgId});
                return false;
            }
        });
        return response;
    }
}

