/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.huawei.ism.drm.openstack.adapter.manager.IImageManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackImage;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.util.endpointutil.ServiceEndpointUtil;
import java.util.List;

public class ImageManager
implements IImageManager {
    private static Log logger = LogFactory.getInstance(NovaManager.class);

    @Override
    public List<OpenStackImage> getImages(String regionUuid, String tokenId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "image");
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.IMAGE_QUERY_IMAGE.getUri(), new Object[0]);
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"images")) {
            logger.error((Object)"bad Request getServers");
            throw new LegoCheckedException(0x300001L);
        }
        List<OpenStackImage> list = JsonUtil.jsonArrayToList(json.getString("images"), OpenStackImage.class);
        return list;
    }
}

