/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.manager.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.huawei.ism.drm.openstack.adapter.manager.INeutronManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.msg.IAsyncTaskResponseChecker;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackNetwork;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPort;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackSubnet;
import com.huawei.ism.drm.openstack.sdk.msg.CreatePortInfo;
import com.huawei.ism.drm.openstack.sdk.msg.NetworkInfo;
import com.huawei.ism.drm.openstack.sdk.msg.PortInfo;
import com.huawei.ism.drm.openstack.sdk.msg.SubnetInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.om.util.endpointutil.ServiceEndpointUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NeutronManager
implements INeutronManager {
    private static Log logger = LogFactory.getInstance(NeutronManager.class);

    @Override
    public List<OpenStackNetwork> getNetworks(String openstackUuid, String regionUuid, String tokenId, String projUuid) {
        String respStr;
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "network");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            logger.error((Object)("urlStr is empty:regionUuid=" + regionUuid));
            throw new LegoCheckedException(1073947393L);
        }
        String newUrlStr = urlStr + OpenstackEnumDefine.REQUEST_URL.NETWORKING_QUERY_NETWORK.getUri();
        HashMap<String, String> uriParamMap = null;
        if (!VerifyUtil.isEmpty((String)projUuid)) {
            uriParamMap = new HashMap<String, String>();
            uriParamMap.put("tenant_id", OpenStackCommonUtil.getIdFromUuid(projUuid));
        }
        if (VerifyUtil.isEmpty((String)(respStr = ClientUtil.sendGetRequest(newUrlStr, uriParamMap, tokenId, new int[0])))) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        List<NetworkInfo> infoList = JsonUtil.jsonArrayToList(json.getString("networks"), NetworkInfo.class);
        ArrayList<OpenStackNetwork> list = new ArrayList<OpenStackNetwork>();
        for (NetworkInfo info : infoList) {
            OpenStackNetwork network = new OpenStackNetwork();
            network.setUuid(openstackUuid + ":" + info.getId());
            network.setProjectUuid(openstackUuid + ":" + info.getProjectId());
            network.setNetworkType(info.getNetworkType());
            network.setName(info.getName());
            network.setStatus(Integer.valueOf(OpenstackEnumDefine.NETNE_STATUS_E.getStatus((String)info.getStatus()).getValue()));
            network.setRegionUuid(regionUuid);
            network.setShared(Boolean.valueOf(info.isShared()));
            network.setTopMoUuid(openstackUuid);
            list.add(network);
        }
        return list;
    }

    @Override
    public List<OpenStackSubnet> getSubnets(String openstackUuid, String regionUuid, String tokenId, String projUuid, Map<String, String> reqParam) {
        String newUrlStr;
        String respStr;
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "network");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            logger.error((Object)("urlStr is empty:regionUuid=" + regionUuid));
            throw new LegoCheckedException(1073947393L);
        }
        if (null == reqParam) {
            reqParam = new HashMap<String, String>();
        }
        if (VerifyUtil.isEmpty((String)(respStr = ClientUtil.sendGetRequest(newUrlStr = VerifyUtil.isEmpty((String)reqParam.get("network_id")) ? urlStr + OpenstackEnumDefine.REQUEST_URL.NETWORKING_QUERY_SUBNET.getUri() : urlStr + OpenstackEnumDefine.REQUEST_URL.NETWORKING_QUERY_SUBNET_BY_NETWORK.getUri(), reqParam, tokenId, new int[0])))) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        List<SubnetInfo> infoList = JsonUtil.jsonArrayToList(json.getString("subnets"), SubnetInfo.class);
        ArrayList<OpenStackSubnet> list = new ArrayList<OpenStackSubnet>();
        for (SubnetInfo info : infoList) {
            OpenStackSubnet subnet = new OpenStackSubnet();
            subnet.setUuid(openstackUuid + ":" + info.getId());
            subnet.setName(info.getName());
            subnet.setEnableDhcp(Boolean.valueOf(info.isEnableDhcp()));
            subnet.setNetworkUuid(openstackUuid + ":" + info.getNetworkId());
            subnet.setProjectUuid(openstackUuid + ":" + info.getProjectId());
            subnet.setGatewayIp(info.getGatewayIp());
            subnet.setIpVersion(info.getIpVersion());
            subnet.setTopMoUuid(openstackUuid);
            list.add(subnet);
        }
        return list;
    }

    @Override
    public List<OpenStackPort> getPorts(String openstackUuid, String regionUuid, String tokenId, String projUuid) {
        String respStr;
        if (VerifyUtil.isEmpty((String)openstackUuid) || VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "network");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            logger.error((Object)("urlStr is empty:regionUuid=" + regionUuid));
            throw new LegoCheckedException(1073947393L);
        }
        String newUrlStr = urlStr + OpenstackEnumDefine.REQUEST_URL.NETWORKING_QUERY_PORT.getUri();
        HashMap<String, String> uriParamMap = null;
        if (!VerifyUtil.isEmpty((String)projUuid)) {
            uriParamMap = new HashMap<String, String>();
            uriParamMap.put("tenant_id", OpenStackCommonUtil.getIdFromUuid(projUuid));
        }
        if (VerifyUtil.isEmpty((String)(respStr = ClientUtil.sendGetRequest(newUrlStr, uriParamMap, tokenId, new int[0])))) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        List<PortInfo> infoList = JsonUtil.jsonArrayToList(json.getString("ports"), PortInfo.class);
        ArrayList<OpenStackPort> list = new ArrayList<OpenStackPort>();
        for (PortInfo info : infoList) {
            OpenStackPort port = new OpenStackPort(openstackUuid, info);
            port.setName(info.getName());
            port.setTopMoUuid(openstackUuid);
            list.add(port);
        }
        return list;
    }

    @Override
    public OpenStackPort getPort(String regionUuid, String tokenId, String portId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)portId)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String urlStr = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "network");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            logger.error((Object)("urlStr is empty:regionUuid=" + regionUuid));
            throw new LegoCheckedException(1073947393L);
        }
        String newUrlStr = urlStr + String.format(OpenstackEnumDefine.REQUEST_URL.NETWORKING_QUERY_ONEPORT.getUri(), portId);
        String respStr = ClientUtil.sendGetRequest(newUrlStr, tokenId);
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(0x300001L);
        }
        JsonNode jsonNode = JsonUtil.getJsonNodeFromStr(respStr);
        if (null == jsonNode || this.checkPortNotFound(respStr)) {
            return null;
        }
        if (jsonNode.path("port").isMissingNode()) {
            logger.error((Object)"bad Request queryVolume");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        PortInfo info = JsonUtil.jsonToBean(json.getString("port"), PortInfo.class);
        if (null == info) {
            logger.error((Object)("convert PortInfo return null, str=" + json.getString("port")));
            throw new LegoCheckedException(0x300001L);
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        OpenStackPort port = new OpenStackPort(openstackUuid, info);
        port.setName(info.getName());
        port.setTopMoUuid(openstackUuid);
        port.setType(info.getType());
        return port;
    }

    @Override
    public AsyncTaskResponse createPort(String regionUuid, String tokenId, String projUuid, CreatePortInfo port) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || null == port) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)port.getNetworkId())) {
            logger.error((Object)"parameter in port is error");
            throw new LegoCheckedException(1073947393L);
        }
        port.setProjectId(OpenStackCommonUtil.getIdFromUuid(projUuid));
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "network");
        String urlStr = baseUrl + OpenstackEnumDefine.REQUEST_URL.NETWORKING_QUERY_PORT.getUri();
        String portStr = JsonUtil.beanToJson(port);
        JSONObject reqestJson = new JSONObject();
        reqestJson.put((Object)"port", (Object)portStr);
        String respStr = ClientUtil.sendPostRequest(urlStr, reqestJson.toString(), tokenId);
        logger.info((Object)("createPort response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(1073948905L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (!json.containsKey((Object)"port")) {
            logger.error((Object)("bad Request createport :" + portStr));
            response.setSuccess(false);
            response.setErrorCode("1073948905");
            return response;
        }
        PortInfo info = JsonUtil.jsonToBean(json.getString("port"), PortInfo.class);
        response.setSuccess(true);
        response.setTaskResult(info);
        return response;
    }

    @Override
    public void updatePortAdminState(String regionUuid, String tokenId, String projUuid, String portId, boolean adminState) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)projUuid) || VerifyUtil.isEmpty((String)portId)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "network");
        String urlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.NETWORKING_UPDATE_PORT.getUri(), portId);
        String isUp = adminState ? "true" : "false";
        String paramStr = "{\"port\": {\"admin_state_up\":" + isUp + "}}";
        String respStr = ClientUtil.sendPutRequest(urlStr, paramStr, tokenId);
        logger.info((Object)("update response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            logger.error((Object)"response string is empty");
            throw new LegoCheckedException(1073948910L);
        }
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (!json.containsKey((Object)"port")) {
            logger.error((Object)("bad Request updateport :" + paramStr));
            throw new LegoCheckedException(1073948910L);
        }
        PortInfo info = JsonUtil.jsonToBean(json.getString("port"), PortInfo.class);
        if (null == info || adminState != info.isAdminStateUp()) {
            logger.error((Object)("expect adminstate is " + adminState + ", but actual str=" + json.getString("port")));
            throw new LegoCheckedException(1073948910L);
        }
    }

    @Override
    public AsyncTaskResponse deletePort(String regionUuid, String tokenId, String portId) {
        if (VerifyUtil.isEmpty((String)regionUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)portId)) {
            logger.error((Object)"parameter is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String baseUrl = ServiceEndpointUtil.getInstance().getBaseUrl(regionUuid, "network");
        String urlStr = baseUrl + String.format(OpenstackEnumDefine.REQUEST_URL.NETWORKING_DELETE_PORT.getUri(), portId);
        String respStr = ClientUtil.sendDeleteRequest(urlStr, tokenId);
        logger.info((Object)("delete port response: " + respStr));
        if (VerifyUtil.isEmpty((String)respStr)) {
            return this.checkDeletePortResponse(regionUuid, tokenId, portId);
        }
        AsyncTaskResponse response = new AsyncTaskResponse();
        if (this.checkPortNotFound(respStr)) {
            response.setSuccess(true);
            return response;
        }
        response.setSuccess(false);
        logger.error((Object)("bad Request delete port: " + portId));
        response.setErrorCode("3145729");
        return response;
    }

    private AsyncTaskResponse checkDeletePortResponse(final String regionUuid, final String tokenId, final String portId) {
        AsyncTaskResponse response = AsyncTaskResponse.queryTaskResponse(portId, new IAsyncTaskResponseChecker(){

            @Override
            public boolean checkResult(AsyncTaskResponse response) {
                OpenStackPort volume = NeutronManager.this.getPort(regionUuid, tokenId, portId);
                if (null == volume) {
                    response.setSuccess(true);
                    return true;
                }
                return false;
            }
        });
        return response;
    }

    private boolean checkPortNotFound(String respStr) {
        String info;
        JSONObject json = JSONObject.fromObject((Object)respStr);
        if (json.containsKey((Object)"itemNotFound")) {
            return true;
        }
        JSONObject rootNode = (JSONObject)json.get("NeutronError");
        return null != rootNode && "PortNotFound".equals(info = (String)rootNode.get("type"));
    }
}

