/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.msg;

import com.huawei.ism.drm.openstack.adapter.msg.IAsyncTaskResponseChecker;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;

public class AsyncTaskResponse {
    public static final String ERROR_DATA_NOT_FOUND = "2117645";
    public static final String ERROR_TIME_OUT = "1073947433";
    public static final String ERROR_BAD_REQUEST = "3145729";
    public static final String ERROR_STATUS_NOTEXCEPTED = "3145729";
    public static final String ERROR_UNKNOWN_ERROR = "3145729";
    public static final long SLEEP_TIME_ONCE = 10000L;
    public static final long SLEEP_TIME_FOR_FIRST_SECOND = 3000L;
    public static final long DEFAULT_REST_TIMEOUT = 600L;
    public static final long DEFAULT_TIMEOUT = 1800L;
    private static final Log logger = LogFactory.getInstance(AsyncTaskResponse.class);
    private boolean success = false;
    private String errorCode;
    private String[] errorParameter;
    private Object taskResult;

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String[] getErrorParameter() {
        return this.errorParameter;
    }

    public void setErrorParameter(String[] errorParameter) {
        this.errorParameter = errorParameter;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Object getTaskResult() {
        return this.taskResult;
    }

    public void setTaskResult(Object taskResult) {
        this.taskResult = taskResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncTaskResponse queryTaskResponse(Object timeoutResult, IAsyncTaskResponseChecker checker) {
        if (null == checker) {
            return null;
        }
        AsyncTaskResponse result = new AsyncTaskResponse();
        int i = 0;
        while ((long)i < AsyncTaskResponse.getDefaultRetryTimes()) {
            try {
                AsyncTaskResponse asyncTaskResponse = result;
                synchronized (asyncTaskResponse) {
                    if (i <= 2) {
                        result.wait(3000L);
                    } else {
                        result.wait(10000L);
                    }
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)"Get error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            if (checker.checkResult(result)) {
                return result;
            }
            ++i;
        }
        logger.error((Object)("wait result timeout, timeoutResult id: " + timeoutResult));
        result.setSuccess(false);
        result.setErrorCode(ERROR_TIME_OUT);
        result.setTaskResult(timeoutResult);
        return result;
    }

    public static AsyncTaskResponse queryTaskResponseTimeout(Object timeoutResult, IAsyncTaskResponseChecker checker) {
        return AsyncTaskResponse.queryTaskResponseTimeout(timeoutResult, checker, null);
    }

    public static AsyncTaskResponse queryTaskResponseTimeout(Object timeoutResult, IAsyncTaskResponseChecker checker, Long inputRetryTimes) {
        if (null == checker) {
            return null;
        }
        AsyncTaskResponse result = new AsyncTaskResponse();
        long retryTimes = AsyncTaskResponse.getRetryTimes();
        if (null != inputRetryTimes && inputRetryTimes > retryTimes) {
            retryTimes = inputRetryTimes;
            logger.debug((Object)"queryTaskResponseTimeout reset task timeout:%s", new Object[]{String.valueOf(retryTimes)});
        }
        for (long i = 0L; i < retryTimes; ++i) {
            if (i <= 2L) {
                CommonUtil.sleep((long)3000L);
            } else {
                CommonUtil.sleep((long)10000L);
            }
            if (!checker.checkResult(result)) continue;
            return result;
        }
        logger.error((Object)("wait result timeout, timeoutResult id: " + timeoutResult + ", retryTimes=" + retryTimes));
        result.setSuccess(false);
        result.setErrorCode(ERROR_TIME_OUT);
        result.setTaskResult(timeoutResult);
        return result;
    }

    private static long getRetryTimes() {
        return AsyncTaskResponse.getRetryTimes("openstack_async_interface_timeout", 1800L);
    }

    private static long getRetryTimes(String configKey, long defaultValue) {
        long timeoutMiliSec = LegoConfig.getInstance().getNumber(configKey, defaultValue) * 1000L;
        long retryTimes = timeoutMiliSec / 10000L + 1L;
        logger.debug((Object)"get retry times:%s for configKey:%s", new Object[]{String.valueOf(retryTimes), configKey});
        return retryTimes;
    }

    private static long getDefaultRetryTimes() {
        return AsyncTaskResponse.getRetryTimes("openstack.rest.default.timeout", 600L);
    }
}

