/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.adapter.util;

import com.huawei.ism.drm.openstack.adapter.handler.OpenStackResponseHandler;
import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.virtualization.observer.ObserverManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;

public class ClientUtil {
    private static Log logger = LogFactory.getInstance(ClientUtil.class);
    private static int printMaxLength = 10240;
    private static int retryInterval = 1000;
    private static int retryMaxTimes = 3;
    private static int defaultConnTimeout = 180000;

    public static String sendPutRequest(String urlStr, String message, String tokenId) {
        String respStr = null;
        for (int i = 0; i <= retryMaxTimes; ++i) {
            try {
                respStr = ClientUtil.sendPutRequestOnce(urlStr, message, tokenId);
                break;
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() != 1073947401L && e.getErrorCode() != 1073947398L || i >= retryMaxTimes) {
                    throw e;
                }
                logger.info((Object)("connect to openstack failed,will retry,retryTimes=" + i + " url=" + urlStr));
                CommonUtil.sleep((long)retryInterval);
                continue;
            }
        }
        return respStr;
    }

    private static String sendPutRequestOnce(String urlStr, String message, String tokenId) {
        String respStr = null;
        logger.debug((Object)("Send put Msg: urlStr=" + urlStr + " message=" + message));
        try {
            URL urlObj = new URL(urlStr);
            RestClient client = ClientUtil.getClient(urlObj, defaultConnTimeout);
            respStr = client.put(urlObj.getPath(), message, null, ClientUtil.getHeaders(tokenId, null));
        }
        catch (LegoCheckedException e) {
            if (401L == e.getErrorCode()) {
                logger.error((Object)("auth failed:urlStr=" + urlStr));
                ObserverManager.getInstance((String)"OPENSTACK_AUTH_FAILED").asyncNotifyAllObservers((Object)tokenId);
                e = new LegoCheckedException(0x300001L);
            }
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("sendPostRequest error:" + urlStr), (long)0x300001L, null, (Log)logger);
        }
        logger.debug((Object)("Recieve put response: respStr=" + respStr));
        return respStr;
    }

    public static String sendPostRequest(String urlStr, String message, String tokenId) {
        return ClientUtil.sendPostRequestWithTimeout(urlStr, message, tokenId, defaultConnTimeout);
    }

    public static String sendPostRequestWithTimeout(String urlStr, String message, String tokenId, int timeout) {
        String respStr = null;
        for (int i = 0; i <= retryMaxTimes; ++i) {
            try {
                respStr = ClientUtil.sendPostRequestOnce(urlStr, message, tokenId, timeout);
                break;
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() != 1073947401L && e.getErrorCode() != 1073947398L || i >= retryMaxTimes) {
                    throw e;
                }
                logger.info((Object)("connect to openstack failed,will retry,retryTimes=" + i + " url=" + urlStr));
                CommonUtil.sleep((long)retryInterval);
                continue;
            }
        }
        return respStr;
    }

    private static String sendPostRequestOnce(String urlStr, String message, String tokenId, int timeout) {
        String respStr = null;
        logger.debug((Object)("Send post Msg: urlStr=" + urlStr + " message=" + message));
        try {
            URL urlObj = new URL(urlStr);
            RestClient client = ClientUtil.getClient(urlObj, timeout);
            respStr = client.post(urlObj.getPath(), message, null, ClientUtil.getHeaders(tokenId, null));
        }
        catch (LegoCheckedException e) {
            if (401L == e.getErrorCode()) {
                logger.error((Object)("auth failed:urlStr=" + urlStr));
                ObserverManager.getInstance((String)"OPENSTACK_AUTH_FAILED").asyncNotifyAllObservers((Object)tokenId);
                e = new LegoCheckedException(0x300001L);
            }
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("sendPostRequest error:" + urlStr), (long)0x300001L, null, (Log)logger);
        }
        logger.debug((Object)("Recieve post response: respStr=" + respStr));
        return respStr;
    }

    public static String sendDeleteRequest(String urlStr, String tokenId) {
        return ClientUtil.sendDeleteRequest(urlStr, null, tokenId);
    }

    public static String sendDeleteRequest(String urlStr, String message, String tokenId) {
        String respStr = null;
        for (int i = 0; i <= retryMaxTimes; ++i) {
            try {
                respStr = ClientUtil.sendDeleteRequestOnce(urlStr, message, tokenId);
                break;
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() != 1073947401L && e.getErrorCode() != 1073947398L || i >= retryMaxTimes) {
                    throw e;
                }
                logger.info((Object)("connect to openstack failed,will retry,retryTimes=" + i + " url=" + urlStr));
                CommonUtil.sleep((long)retryInterval);
                continue;
            }
        }
        return respStr;
    }

    private static String sendDeleteRequestOnce(String urlStr, String message, String tokenId) {
        String respStr = null;
        logger.debug((Object)("Send delete Msg: urlStr=" + urlStr + " message=" + message));
        try {
            URL urlObj = new URL(urlStr);
            RestClient client = ClientUtil.getClient(urlObj, defaultConnTimeout);
            respStr = client.delete(urlObj.getPath(), message, null, ClientUtil.getHeaders(tokenId, null));
        }
        catch (LegoCheckedException e) {
            if (401L == e.getErrorCode()) {
                logger.error((Object)("auth failed:urlStr=" + urlStr));
                ObserverManager.getInstance((String)"OPENSTACK_AUTH_FAILED").asyncNotifyAllObservers((Object)tokenId);
                e = new LegoCheckedException(0x300001L);
            }
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("sendDeleteRequest error:" + urlStr), (long)0x300001L, null, (Log)logger);
        }
        logger.debug((Object)("Recieve delete Msg: respStr=" + respStr));
        return respStr;
    }

    public static String sendGetRequest(String urlStr, String tokenId) {
        return ClientUtil.sendGetRequest(urlStr, null, tokenId, new int[0]);
    }

    public static String sendGetRequest(String urlStr, Map<String, ?> uriVariables, String tokenId, int ... retryTimes) {
        return ClientUtil.sendGetRequest(urlStr, uriVariables, tokenId, null, retryTimes);
    }

    public static String sendGetRequest(String urlStr, Map<String, ?> uriVariables, String tokenId, Map<String, String> headerMap, int ... customerRetryTimes) {
        String respStr = null;
        int actualRetryTimes = retryMaxTimes;
        if (!VerifyUtil.isEmpty((Object)customerRetryTimes) && 0 != customerRetryTimes.length) {
            actualRetryTimes = customerRetryTimes[0];
        }
        for (int i = 0; i <= actualRetryTimes; ++i) {
            try {
                respStr = ClientUtil.sendGetRequestOnce(urlStr, uriVariables, tokenId, headerMap);
                break;
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() != 1073947401L && e.getErrorCode() != 1073947398L || i >= actualRetryTimes) {
                    throw e;
                }
                logger.info((Object)("connect to openstack failed,will retry,retryTimes=" + i + " url=" + urlStr));
                CommonUtil.sleep((long)retryInterval);
                continue;
            }
        }
        return respStr;
    }

    private static String sendGetRequestOnce(String urlStr, Map<String, ?> uriVariables, String tokenId, Map<String, String> headerMap) {
        String respStr = null;
        logger.debug((Object)("Send get Msg: urlStr=" + urlStr + " uriVariables=" + uriVariables + " headerMap=" + headerMap));
        try {
            URL urlObj = new URL(urlStr);
            String newUrlStr = urlObj.getPath();
            if (!VerifyUtil.isEmpty((String)urlObj.getQuery())) {
                newUrlStr = newUrlStr + "?" + urlObj.getQuery();
            }
            RestClient client = ClientUtil.getClient(urlObj, defaultConnTimeout);
            respStr = client.get(newUrlStr, uriVariables, ClientUtil.getHeaders(tokenId, headerMap));
        }
        catch (LegoCheckedException e) {
            if (401L == e.getErrorCode()) {
                logger.error((Object)("auth failed:urlStr=" + urlStr));
                ObserverManager.getInstance((String)"OPENSTACK_AUTH_FAILED").asyncNotifyAllObservers((Object)tokenId);
                e = new LegoCheckedException(0x300001L);
            }
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("sendGetRequest error:" + urlStr), (long)0x300001L, null, (Log)logger);
        }
        if (logger.isDebugEnabled() && null != respStr) {
            int substrLength = respStr.length() > printMaxLength ? printMaxLength : respStr.length();
            logger.debug((Object)("Recieve get Msg: respStr=" + SecurityUtil.desensitization((String)respStr.substring(0, substrLength))));
        }
        return respStr;
    }

    private static RestClient getClient(URL urlObj, int timeout) {
        String host = urlObj.getHost();
        int port = urlObj.getPort();
        RestClient client = new RestClient(host, port, null, null, (IResponseHandler)new OpenStackResponseHandler(), new String[0]);
        client.setTimeout(timeout);
        return client;
    }

    private static List<Header> getHeaders(String tokenId, Map<String, String> headerMap) {
        ArrayList<Header> headers = new ArrayList<Header>();
        BasicHeader header = new BasicHeader("x-auth-token", (Object)tokenId);
        headers.add((Header)header);
        if (!VerifyUtil.isEmpty(headerMap)) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                if (VerifyUtil.isEmpty((String)entry.getKey()) || VerifyUtil.isEmpty((String)entry.getValue())) continue;
                BasicHeader customizeHead = new BasicHeader(entry.getKey(), (Object)entry.getValue());
                headers.add((Header)customizeHead);
            }
        }
        return headers;
    }
}

