/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.cert.component;

import com.huawei.ism.drm.cert.component.DependedCertificateService;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.ism.drm.openstack.model.OpenStackServiceEndPoint;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class OpenstackDependedCertificateService
extends DependedCertificateService
implements SystemStatusChangedListener {
    private static Log logger = LogFactory.getInstance(OpenstackDependedCertificateService.class);
    private IOpenstackResourceService openstackResourceService;
    private List<String> originalRegions = new ArrayList<String>();
    private List<CertificateSummary> originalCertificateSummaries = new ArrayList<CertificateSummary>();
    private String originalField = "";

    public OpenstackDependedCertificateService(String keyStoreFileName, String keyStorePriField, List<String> certs, String operateCommand, String rollbackCommand, String region) {
        super(keyStoreFileName, keyStorePriField, certs, operateCommand, rollbackCommand);
        int index;
        int n = index = region != null ? region.indexOf(58) : -1;
        if (index > 0) {
            this.initialize(region.substring(0, index), region.substring(index + 1));
        }
    }

    private void initialize(String field, String configKey) {
        this.originalCertificateSummaries = new ArrayList<CertificateSummary>(this.getCertificateSummaries());
        this.originalField = field;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            try {
                FusionSphereOpenStack openstack = OpenStackCommonUtil.getOpenstack();
                if (null == openstack || null == openstack.getUuid()) {
                    logger.warn((Object)"openstack is null.");
                    return;
                }
                Set regionsSet = this.openstackResourceService.getEndPointFromDB(openstack.getUuid()).stream().map(endPoint -> OpenStackCommonUtil.getIdFromUuid(endPoint.getRegionUuid())).collect(Collectors.toSet());
                ArrayList<String> regions = new ArrayList<String>(regionsSet);
                if (regions.isEmpty()) {
                    logger.warn((Object)"regions is null.");
                    return;
                }
                this.initialByRegions(this.originalField, regions);
            }
            catch (Exception e) {
                logger.error((Object)"initial region cert error:", (Throwable)e);
            }
        }
    }

    private void initialByRegions(String field, List<String> regions) {
        this.getCertificateSummaries().clear();
        ArrayList<CertificateSummary> summaries = new ArrayList<CertificateSummary>();
        for (CertificateSummary summary : this.originalCertificateSummaries) {
            int size = regions.size();
            for (int i = 0; i < size; ++i) {
                summaries.add(this.duplicate(summary, field, regions.get(i)));
            }
        }
        this.getCertificateSummaries().addAll(summaries);
        this.originalRegions = new ArrayList<String>(regions);
        this.originalField = field;
    }

    private CertificateSummary initialize(CertificateSummary summary, String field, String region) {
        String certName = summary.getCertName();
        summary.setCertName(certName + "-" + region);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(field, region);
        summary.setExtendMap(map);
        return summary;
    }

    private CertificateSummary duplicate(CertificateSummary summary, String field, String region) {
        return this.initialize(this.getClone(summary), field, region);
    }

    private CertificateSummary getClone(CertificateSummary summary) {
        try {
            return (CertificateSummary)summary.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"clone error:", (Throwable)e);
            throw new LegoCheckedException(0x300001L);
        }
    }

    public void registerOpenstackCert(List<OpenStackServiceEndPoint> endPointList) {
        try {
            HashSet<String> oldRegions;
            if (!this.getSystemCertificateService().available()) {
                logger.info((Object)"systemCertificateService not available.");
                return;
            }
            Set regions = endPointList.stream().map(endPoint -> OpenStackCommonUtil.getIdFromUuid(endPoint.getRegionUuid())).collect(Collectors.toSet());
            if (regions.containsAll(oldRegions = new HashSet<String>(this.originalRegions)) && oldRegions.containsAll(regions)) {
                logger.info((Object)"region not change,no need register cert.");
                return;
            }
            this.initialByRegions(this.originalField, new ArrayList<String>(regions));
            this.getSystemCertificateService().registerCertificate();
        }
        catch (Exception e) {
            logger.error((Object)"registerOpenstackCert error!", (Throwable)e);
        }
    }

    public void setOpenstackResourceService(IOpenstackResourceService openstackResourceService) {
        this.openstackResourceService = openstackResourceService;
    }
}

