/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.cert.task;

import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.ism.drm.cert.task.CertificateDockingTask;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.cert.OpenStackCertificateConstants;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;

public class OpenStackCertificateDockingTask
extends CertificateDockingTask {
    private static final Log logger = LogFactory.getInstance(OpenStackCertificateDockingTask.class);
    private boolean register;

    public OpenStackCertificateDockingTask(String taskName, String taskType, List<CertificateSummary> summaries, boolean register) {
        super(taskName, taskType, summaries);
        this.register = register;
    }

    public boolean handle(List<CertificateSummary> summaries) {
        JSONObject result;
        if (null == summaries) {
            logger.error((Object)"register summary is null.");
            throw new LegoCheckedException(1073947393L);
        }
        logger.info((Object)("register certificate summary, size: " + summaries.size()));
        String region = LegoConfig.getNodeConfig().getKeyValue("config.hcs.node.region");
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.cert.management.url");
        if (VerifyUtil.isEmpty((String)region) || VerifyUtil.isEmpty((String)urlStr)) {
            logger.error((Object)"register certificate, but server url or region is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject registerJsonObject = new JSONObject();
        registerJsonObject.put((Object)"serviceName", (Object)"eReplication");
        registerJsonObject.put((Object)"region", (Object)region);
        registerJsonObject.put((Object)"serviceUrl", (Object)OpenStackCertificateConstants.CertificateServiceUrl.load());
        if (this.register) {
            logger.info((Object)"register all certificate.");
            registerJsonObject.put((Object)"certs", (Object)this.resolveRegisterInfo());
        }
        logger.info((Object)("openstack register certificate request: " + registerJsonObject));
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        String tokenId = TokenUtil.getInstance().getTokenId(open, null);
        String fullUrl = "https://" + urlStr + OpenStackCertificateConstants.RequestUrl.REGISTER.getUri();
        String response = ClientUtil.sendPostRequest(fullUrl, registerJsonObject.toString(), tokenId);
        logger.info((Object)("openstack register certificate response: " + response));
        if (VerifyUtil.isEmpty((String)response)) {
            logger.error((Object)"openstack register certificate response is empty.");
            throw new LegoCheckedException(0x300001L);
        }
        try {
            result = JSONObject.fromObject((Object)response);
        }
        catch (Exception e) {
            logger.error((Object)"resolve certificate register response failed.", (Throwable)e);
            return false;
        }
        if (null != result && result.containsKey((Object)"resultCode")) {
            String resultCode = result.getString("resultCode");
            if ("00000000".equals(resultCode)) {
                logger.info((Object)"register certificate succeed.");
                return true;
            }
            logger.error((Object)("register certificate failed, error: " + result.getString("errorMsg")));
            return false;
        }
        return false;
    }

    private String resolveRegisterInfo() {
        JSONArray certs = JSONArray.fromObject((Object)this.getCertificateSummaries());
        logger.info((Object)("register certificate size: " + certs.size()));
        return certs.toString();
    }
}

