/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.discovery.synchronizer;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.commons.DiscoverContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.AbstractSynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.model.MoListOrMap;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;

public class OpenstackSynchronizer
extends AbstractSynchronizer {
    private static Log logger = LogFactory.getInstance(OpenstackSynchronizer.class);

    public MoListOrMap synchronizeDataAndConstructMo(SynchronizeParameter param, MoListOrMap moListOrMap) {
        logger.info((Object)"this is OpenstackSynchronizer", 90160758786988L);
        String siteId = param.getDiscoveryPolicy().getLocation();
        DiscoverContext context = new DiscoverContext(param, moListOrMap);
        Map paramMap = param.getDiscoveryPolicy().getParamMap();
        NeMgrProtocolExtend extend = new NeMgrProtocolExtend();
        FusionSphereOpenStack fsos = new FusionSphereOpenStack();
        String disCoveryType = "register";
        CommonTemplate discoverTemplate = CommonTemplateManager.getInstance().getDiscoverTemplateByDeviceType(param.getSysOid());
        if (null == discoverTemplate) {
            logger.error((Object)("sysoid is error:sysoid=" + param.getSysOid()), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        fsos.setUuid(param.getDeviceIp());
        fsos.setLinkIp(param.getDeviceIp());
        fsos.setSn(fsos.getUuid());
        HashMap extParam = new HashMap();
        extParam.put("port", paramMap.get("port"));
        extParam.put("domain", paramMap.get("domain"));
        String version = (String)paramMap.get("version");
        extParam.put("version", VerifyUtil.isEmpty((String)version) ? "6.0" : version);
        String authType = (String)paramMap.get("authType");
        extParam.put("authType", VerifyUtil.isEmpty((String)authType) ? "KeyStone" : authType);
        String regions = (String)paramMap.get("discoveryregions");
        if (null != regions && !regions.isEmpty()) {
            extParam.put("discoveryregions", regions);
        }
        extend.setExtendParams(extParam);
        extend.setNetworkIpAddress(param.getDeviceIp());
        extend.setNetworkUserName((String)paramMap.get("username"));
        extend.setNetworkPassword((String)paramMap.get("password"));
        context.setAttribute("StorageDevice", (Object)fsos);
        context.setAttribute("DiscoveryType", (Object)disCoveryType);
        context.setAttribute("NeMgrProtocolExtend", (Object)extend);
        context.setAttribute("siteId", (Object)siteId);
        context.setAttribute("OperatorId", (Object)param.getDiscoveryPolicy().getOperatorId());
        discoverTemplate.process((AbstractContext)context);
        return null;
    }
}

