/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.license;

import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.galax.sdk.service.IGalaxSiteResService;
import com.huawei.ism.drm.license.LicenseOverflowStackControl;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpenStackVmLicenseCheckObserverImpl
implements IObjectObserver {
    private static final Log logger = LogFactory.getInstance(OpenStackVmLicenseCheckObserverImpl.class);
    private IGalaxSiteResService openStackResService;

    public void setOpenStackResService(IGalaxSiteResService openStackResService) {
        this.openStackResService = openStackResService;
    }

    public int getPriority() {
        return 1;
    }

    public void before(MessageEvent event) {
        VirtualizationCommonUtil commonUtil = VirtualizationCommonUtil.getInstance();
        List objectList = event.getObjectList(ProtectGroup.class);
        int messageType = event.getMessageType();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        if (!this.isSuccessMessage(messageType)) {
            return;
        }
        for (DRMObject object : objectList) {
            ProtectGroup protectGroup = (ProtectGroup)object;
            if (!this.isOpenStackVm(protectGroup)) {
                logger.debug((Object)("pg is not need to check:" + protectGroup.getName()));
                continue;
            }
            int licenseCount = this.getOpenStackVmLicenseCount(protectGroup);
            int licenseType = protectGroup.getTemplate().getType();
            if (messageType == 3) {
                ProtectGroup curPg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroup.getUuid());
                int curPoLicenseCount = this.getOpenStackVmLicenseCount(curPg);
                licenseCount -= curPoLicenseCount;
            } else if (messageType == 21) {
                String beforeUpgradeType = (String)protectGroup.getProps().get("BEFORE_UPGRADE_TYPE");
                licenseType = this.getLicenseTypeWhenUpgradeOrDowngrade(beforeUpgradeType);
            } else {
                logger.debug((Object)"calc license when receive create message.");
            }
            logger.debug((Object)"begin check License for pg:%s, license will be used :%s", new Object[]{protectGroup.getName(), licenseCount});
            commonUtil.overflowStackLicense(licenseType, licenseCount);
        }
    }

    private int getLicenseTypeWhenUpgradeOrDowngrade(String modifiedType) {
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(modifiedType)) {
            return 29;
        }
        return 22;
    }

    public void after(MessageEvent event) {
        List objectList = event.getObjectList(ProtectGroup.class);
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        int messageType = event.getMessageType();
        VirtualizationCommonUtil commonUtil = VirtualizationCommonUtil.getInstance();
        for (DRMObject object : objectList) {
            ProtectGroup protectGroup = (ProtectGroup)object;
            if (!this.isOpenStackVm(protectGroup)) {
                logger.debug((Object)("pg is not need to check:" + protectGroup.getName()));
                continue;
            }
            int licenseCount = -1 * this.getOpenStackVmLicenseCount(protectGroup);
            int licenseType = protectGroup.getTemplate().getType();
            if (messageType == 2) {
                logger.info((Object)"receive delete message, begin release license.");
            } else if (messageType == 4) {
                Map msgMap = event.getMessageMap();
                Set deleteProtectObject = (Set)msgMap.get("TASK_RESULT_REMOVED_ITEM_LIST_KEY");
                licenseCount = -1 * this.getProtectObjectsLicenseCount(deleteProtectObject);
            } else if (messageType == 22) {
                String instanceType = (String)protectGroup.getProps().get("serviceInstanceType");
                licenseType = this.getLicenseTypeWhenUpgradeOrDowngrade(instanceType);
            } else {
                logger.debug((Object)"no need do license release.");
                return;
            }
            logger.debug((Object)"begin modify License for pg:%s, license will be release :%s", new Object[]{protectGroup.getName(), licenseCount});
            commonUtil.overflowStackLicense(licenseType, licenseCount);
            this.sendLiceseAlarm(messageType, protectGroup);
        }
    }

    private void sendLiceseAlarm(int messageType, ProtectGroup protectGroup) {
        if (messageType == 2 || messageType == 4) {
            logger.debug((Object)("begin check License for pg:" + protectGroup.getName()));
            ILicenseControl licenseCtr = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
            licenseCtr.checkLicenseOutOfControlAlarm(true);
        }
    }

    private int getOpenStackVmLicenseCount(ProtectGroup protectGroup) {
        Set polist = protectGroup.getPolist();
        if (null != polist) {
            int poLicenseCount = 0;
            for (ProtectObject protectObject : protectGroup.getPolist()) {
                poLicenseCount += this.getProtectObjectLicenseCount(protectObject);
            }
            return poLicenseCount;
        }
        return 0;
    }

    private int getProtectObjectsLicenseCount(Set<ProtectObject> protectObjects) {
        int poLicenseCount = 0;
        if (null != protectObjects) {
            for (ProtectObject protectObject : protectObjects) {
                poLicenseCount += this.getProtectObjectLicenseCount(protectObject);
            }
        }
        return poLicenseCount;
    }

    private int getProtectObjectLicenseCount(ProtectObject protectObject) {
        if ("BMS".equals(protectObject.getProps().get("vm_type"))) {
            return 10;
        }
        return 1;
    }

    public void onFinal(MessageEvent event) {
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        int messageType = event.getMessageType();
        LicenseOverflowStackControl licenseCtr = LicenseOverflowStackControl.getInstance();
        for (DRMObject object : objectList) {
            if (!(object instanceof ProtectGroup)) continue;
            ProtectGroup protectGroup = (ProtectGroup)object;
            if (!this.isOpenStackVm(protectGroup)) {
                logger.debug((Object)("pg is not need to check:" + protectGroup.getName()));
                continue;
            }
            if (this.isSuccessMessage(messageType)) {
                licenseCtr.noticeTaskSuccess();
                continue;
            }
            if (!this.isFailedMessage(messageType)) continue;
            licenseCtr.noticeTaskError();
        }
    }

    private boolean isSuccessMessage(int messageType) {
        return Arrays.asList(0, 3, 21).contains(messageType);
    }

    private boolean isFailedMessage(int messageType) {
        return Arrays.asList(24, 23, 25).contains(messageType);
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }

    private boolean isOpenStackVm(ProtectGroup protectGroup) {
        if (12 != protectGroup.getPoType()) {
            return false;
        }
        return null != this.openStackResService.getDrResourceBySn(protectGroup.getPoProviderSN());
    }
}

