/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.path.builder;

import com.huawei.ism.drm.openstack.protection.path.builder.OpenStackArraySyncReplicaProtectionPath;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPath;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;

public class OpenStackVhaAsyncReplicaProtectionPath
extends OpenStackArraySyncReplicaProtectionPath {
    protected static final String LINK_SYMBOL = " -- ";
    private static final Log logger = LogFactory.getInstance(OpenStackVhaAsyncReplicaProtectionPath.class);

    @Override
    protected ProtectionPath constructSiteProtectionPath(ProtectGroup pg) {
        ArrayList<String> sitePathDetails = new ArrayList<String>();
        ProtectionPath siteProtectionPath = new ProtectionPath();
        boolean isCsdrVhaModel = OpenStackCommonUtil.isCsdrCshaMode(pg);
        String siteRelation = pg.getProductSiteName() + (isCsdrVhaModel ? " --> " : LINK_SYMBOL) + pg.getProductSiteName() + (isCsdrVhaModel ? LINK_SYMBOL : " --> ") + pg.getProductSiteName() + "\n";
        sitePathDetails.add(siteRelation);
        siteProtectionPath.setPathDetails(sitePathDetails);
        return siteProtectionPath;
    }

    @Override
    protected ProtectionPath constructRdProtectionPath(ProtectGroup pg) {
        ArrayList<String> rdPathDetails = new ArrayList<String>();
        ProtectionPath rdProtectionPath = new ProtectionPath();
        Boolean isCsdrVhaModel = OpenStackCommonUtil.isCsdrCshaMode(pg);
        String orginalAz = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("originalAvailableZone"));
        String projName = (String)pg.getProps().get("projectName");
        String drProjName = (String)pg.getProps().get("drProjectName");
        String azName = (String)pg.getProps().get("zoneName");
        String drAzName = (String)pg.getProps().get("drZoneName");
        StringBuffer rdRelationBuff = new StringBuffer();
        ArrayList<String> volumeUuids = new ArrayList<String>();
        for (ProtectObject po : pg.getPolist()) {
            PoReplicaInfo poReplicaInfo = this.getPoReplicaInfo(po, "replicationInfo");
            for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
                if (!OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus().equals(pairInfo.getVolumeStatus())) {
                    logger.info((Object)("volume's replica pair is not protected, status: " + pairInfo.getVolumeStatus()));
                    continue;
                }
                if (volumeUuids.contains(pairInfo.getVolumeUuid())) continue;
                volumeUuids.add(pairInfo.getVolumeUuid());
                rdRelationBuff.append(pairInfo.getVolumeName()).append("(").append(projName).append("/").append(azName).append(")");
                rdRelationBuff.append(isCsdrVhaModel != false ? " --> " : LINK_SYMBOL);
                rdRelationBuff.append(this.getDrVolumName(pairInfo.getVolumeName(), isCsdrVhaModel, orginalAz, isCsdrVhaModel != false ? drAzName : azName)).append("(").append(isCsdrVhaModel != false ? drProjName : projName).append("/").append(isCsdrVhaModel != false ? drAzName : azName).append(")");
                rdRelationBuff.append(isCsdrVhaModel != false ? LINK_SYMBOL : " --> ");
                rdRelationBuff.append(this.getDrVolumName(pairInfo.getVolumeName(), isCsdrVhaModel, orginalAz, drAzName)).append("(").append(drProjName).append("/").append(drAzName).append(")");
                rdRelationBuff.append(";\n");
            }
        }
        rdPathDetails.add(rdRelationBuff.toString());
        rdProtectionPath.setPathDetails(rdPathDetails);
        return rdProtectionPath;
    }

    protected String getDrVolumName(String volumeName, Boolean isCsdrVhaModel, String orginalAz, String azName) {
        int length = volumeName.length();
        if (orginalAz.equals(azName)) {
            return volumeName.substring(0, length - 3);
        }
        if (!isCsdrVhaModel.booleanValue()) {
            return OpenStackCommonUtil.getNameBySuff(volumeName, "-DR");
        }
        return volumeName;
    }

    @Override
    public int getPolicyTemplateType() {
        return 34;
    }
}

