/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.replica.builder;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.rollback.RollBackTaskManager;
import com.huawei.ism.drm.base.util.dao.SessionUtil;
import com.huawei.ism.drm.common.sdk.model.RollBackTaskInfo;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.ConfigPhVmTask;
import com.huawei.ism.drm.openstack.protection.service.CreateReplicationTask;
import com.huawei.ism.drm.openstack.protection.service.CreateReplicationTaskResult;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackProject;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolAttachment;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolumeType;
import com.huawei.ism.drm.openstack.sdk.msg.VolReplicaCgCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationInfo;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.AbstractServiceInstanceCreateImpl;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public abstract class ArrayReplicationReplicaBuilder
implements IReplicaBuilder {
    private static final Object CREATE_HYPERMETRE_PAIAR_LOCK = new Object();
    private static Log logger = LogFactory.getInstance(ArrayReplicationReplicaBuilder.class);
    private IVolumeService volumeService;

    public IVolumeService getVolumeService() {
        return this.volumeService;
    }

    public void setVolumeService(IVolumeService volumeService) {
        this.volumeService = volumeService;
    }

    public void buildReplica(ProtectGroup pg) {
        logger.info((Object)("start to create protectgroup replica:pgName=" + pg.getName()));
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Collection)pg.getPolist())) {
            logger.error((Object)"pg or polist is empty");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> drVolTypeMap = new HashMap<String, String>();
        if (!this.checkDrVolTypeExist(pg, drVolTypeMap, null)) {
            logger.error((Object)("drvoltype is empty,pgName=" + pg.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.checkSrcVolTypeFromSameDev(pg) || !this.checkVolTypeFromSameDev(pg, drVolTypeMap.values())) {
            logger.error((Object)("drvoltype is not from the same storage device,pgName=" + pg.getName() + " drVolTypes=" + drVolTypeMap.values()));
            throw new LegoCheckedException(1073948413L);
        }
        HashMap<String, PoReplicaPairInfo> protectedPairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, List<ProtectObject>> protectedVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unprotectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        this.getPairInfoMap(pg, protectedPairInfoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
        if (!this.checkVolumeStatus(pg, protectedPairInfoMap)) {
            logger.error((Object)("drvoltype is not from the same storage device,pgName=" + pg.getName() + " drVolTypes=" + drVolTypeMap.values()));
            throw new LegoCheckedException(1073948416L);
        }
        HashMap<String, List<ProtectObject>> needProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unNeedProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        this.getAddedPoVolumeInfoMap(pg, protectedPairInfoMap, needProtectVolUuidPoMap, unNeedProtectVolUuidPoMap);
        logger.info((Object)("needProtectVolUuidPoMap size=" + needProtectVolUuidPoMap.size()));
        logger.info((Object)("unNeedProtectVolUuidPoMap size=" + unNeedProtectVolUuidPoMap.size()));
        Map<String, OpenStackVolume> uuidVolMap = this.getUuidVolMap(pg);
        HashMap<String, PoReplicaInfo> poReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        Map<String, PoReplicaPairInfo> newCreatePairInfoMap = null;
        try {
            newCreatePairInfoMap = this.protectVolumes(pg, uuidVolMap, drVolTypeMap, poReplicaInfoMap, needProtectVolUuidPoMap);
            this.afterCreatePair(pg, poReplicaInfoMap);
        }
        catch (LegoCheckedException e) {
            this.mergeShareVolume(poReplicaInfoMap);
            this.startRollback(pg, poReplicaInfoMap, null, null, null);
            logger.error((Object)("build replica failed:pgName=" + pg.getName()));
            throw e;
        }
        catch (Exception e) {
            this.mergeShareVolume(poReplicaInfoMap);
            this.startRollback(pg, poReplicaInfoMap, null, null, null);
            ExceptionUtil.rethrowException((Throwable)e, (String)"build replica failed", (long)0x300001L, (String[])new String[0], (Log)logger);
        }
        this.dealUnNeedProtectVolume(pg, unNeedProtectVolUuidPoMap, protectedPairInfoMap, protectedVolUuidPoMap, poReplicaInfoMap);
        this.dealUnProtectedVolume(unprotectVolUuidPoMap, newCreatePairInfoMap, "replicationInfo");
        String aSrcVolTypeName = ((OpenStackVolume)CommonUtil.getFirstElement(uuidVolMap.values())).getVolType();
        String aDrVolTypeName = (String)CommonUtil.getFirstElement(drVolTypeMap.values());
        this.updatePgProp(pg, aSrcVolTypeName, aDrVolTypeName, null);
        this.updatePoProp(pg, poReplicaInfoMap, uuidVolMap);
        this.updateUnprotectVolumePoPropsInfo(pg);
        this.makePgReplica(pg);
    }

    public void updateUnprotectVolumePoPropsInfo(ProtectGroup pg) {
        ProtectObject po2;
        if (null == pg) {
            logger.error((Object)"update pair info and volume config, pg is null.");
            return;
        }
        boolean poISBMS = false;
        Iterator iterator = pg.getPolist().iterator();
        if (iterator.hasNext() && OpenStackCommonUtil.isBareMetalServer(po2 = (ProtectObject)iterator.next())) {
            poISBMS = true;
        }
        if (!poISBMS) {
            logger.info((Object)("only ECS need to add unprotect Volume pair.protectGroup name=" + pg.getName()));
            return;
        }
        for (ProtectObject po2 : pg.getPolist()) {
            String poHyperMetroReplicaInfoStr;
            String poReplicaInfoStr = (String)po2.getProps().get("replicationInfo");
            PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(poReplicaInfoStr, PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                logger.error((Object)("poReplicaInfo json to bean failed:poReplicaInfoStr=" + poReplicaInfoStr + ", protectGroup name=" + pg.getName() + ",protectObject name=" + po2.getName()));
                throw new LegoCheckedException(1073947393L);
            }
            JSONArray volArr = (JSONArray)po2.getProperty("volumeConfig", JSONArray.class);
            PoReplicaInfo poHyperMetroReplicaInfo = null;
            if ((pg.getTemplate().getType() == 34 || pg.getTemplate().getType() == 37) && null == (poHyperMetroReplicaInfo = JsonUtil.jsonToBean(poHyperMetroReplicaInfoStr = (String)po2.getProps().get("hypermetor_replicationInfo"), PoReplicaInfo.class))) {
                logger.error((Object)("poReplicaInfo is null, protectGroup name=" + pg.getName() + ",protectObject name=" + po2.getName()));
                throw new LegoCheckedException(1073947393L);
            }
            String uuid = po2.getMoUuid();
            String regionUuid = (String)pg.getProps().get("regionId");
            String projUuid = (String)pg.getProps().get("projectId");
            Set protectdVolUuids = poReplicaInfo.getPairInfos().stream().filter(item -> OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus().equals(item.getVolumeStatus())).map(PoReplicaPairInfo::getVolumeUuid).collect(Collectors.toSet());
            Set allVolUuidInPairInfo = poReplicaInfo.getPairInfos().stream().map(PoReplicaPairInfo::getVolumeUuid).collect(Collectors.toSet());
            HashSet<String> volConfigUuids = new HashSet<String>();
            for (int i = 0; i < volArr.size(); ++i) {
                JSONObject vol = volArr.getJSONObject(i);
                String volumeUuid = vol.getString("volumeId");
                volConfigUuids.add(volumeUuid);
            }
            List volList = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).getVolumesByVm(regionUuid, projUuid, false, new String[]{uuid});
            for (OpenStackVolume volume : volList) {
                if (!protectdVolUuids.contains(volume.getUuid()) && !allVolUuidInPairInfo.contains(volume.getUuid())) {
                    this.addPair(poReplicaInfo, poHyperMetroReplicaInfo, volume);
                }
                if (volConfigUuids.contains(volume.getUuid())) continue;
                this.addVol(pg, volArr, volume);
            }
            po2.getProps().put("replicationInfo", JsonUtil.beanToJson(poReplicaInfo));
            po2.getProps().put("volumeConfig", volArr.toString());
            if (poHyperMetroReplicaInfo == null) continue;
            po2.getProps().put("hypermetor_replicationInfo", JsonUtil.beanToJson(poHyperMetroReplicaInfo));
        }
    }

    private void addVol(ProtectGroup pg, JSONArray volArr, OpenStackVolume volume) {
        JSONObject vol = new JSONObject();
        vol.set((Object)"volumeId", (Object)volume.getUuid());
        vol.set((Object)"volumeType", (Object)volume.getVolType());
        vol.set((Object)"drVolumeType", (Object)"");
        if (pg.getTemplate().getType() == 34 || pg.getTemplate().getType() == 37) {
            vol.set((Object)"drHyperVolumeType", (Object)"");
        }
        volArr.add((Object)vol);
    }

    private void addPair(PoReplicaInfo poReplicaInfo, PoReplicaInfo poHyperMetroReplicaInfo, OpenStackVolume volume) {
        PoReplicaPairInfo addPairInfo = new PoReplicaPairInfo();
        poReplicaInfo.getPairInfos().add(addPairInfo);
        if (poHyperMetroReplicaInfo != null) {
            poHyperMetroReplicaInfo.getPairInfos().add(addPairInfo);
        }
        addPairInfo.setVolumeName(volume.getName());
        addPairInfo.setVolumeType(volume.getVolType());
        addPairInfo.setVolumeUuid(volume.getUuid());
        addPairInfo.setSize(volume.getSize().intValue());
        addPairInfo.setVolumeStatus(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.UNPROTECTED.getStatus());
    }

    protected void afterCreatePair(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap) {
        Set<ProtectObject> addPoSet = pg.getPolist();
        String upgradeType = (String)pg.getProps().get("BEFORE_UPGRADE_TYPE");
        if (!VerifyUtil.isEmpty((Collection)pg.getReplicaList()) && !ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(upgradeType)) {
            addPoSet = this.getWillAddPoSet(pg);
        }
        ArrayList configVmTaskList = new ArrayList();
        for (ProtectObject po : addPoSet) {
            String poUuid = po.getUuid();
            String phvmId = (String)po.getProps().get("occupied_vm");
            if (VerifyUtil.isEmpty((String)phvmId)) {
                logger.error((Object)("phvmId is null, can't set phvmId, protectObject name=" + po.getName() + ",protectObject uuid=" + poUuid + ",protectGroup name=" + pg.getName()));
                continue;
            }
            PoReplicaInfo replicaInfo = poReplicaInfoMap.get(poUuid);
            if (VerifyUtil.isEmpty((Object)replicaInfo)) {
                logger.warn((Object)("replicaInfo is null, can't find pairreplicaInfo, protectObject name=" + po.getName() + ",protectObject uuid=" + poUuid + ",protectGroup name=" + pg.getName()));
                replicaInfo = this.createPoReplicaInfo(pg, po);
                poReplicaInfoMap.put(po.getUuid(), replicaInfo);
            }
            configVmTaskList.add(new ConfigPhVmTask(replicaInfo, phvmId, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue(), pg.getName()));
            po.getProps().remove("occupied_vm");
            this.addTagToVm(replicaInfo);
        }
        if (VerifyUtil.isEmpty(configVmTaskList)) {
            logger.info((Object)("createVmTaskList is empty.protectGroup name=" + pg.getName()));
            return;
        }
        OpenStackCommonUtil.executeTask(configVmTaskList, ExecutionService.ExecuteType.FAILED_ABORT, true);
    }

    protected void addTagToVm(PoReplicaInfo poReplicationInfo) {
        if (poReplicationInfo == null) {
            logger.error((Object)"param error,PoReplicaInfo is null");
            return;
        }
        String reginUuid = poReplicationInfo.getRegionUuid();
        String projectUuid = poReplicationInfo.getProjUuid();
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(reginUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        if (VerifyUtil.isEmpty((String)reginUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)openstackUuid)) {
            logger.info((Object)"Some param is null, reginUuid:%s, projectUuid:%s, openstackUuid:%s", new Object[]{reginUuid, projectUuid, openstackUuid});
            return;
        }
        novaMgr.addTagToVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), "__type_pd");
    }

    protected boolean checkSrcVolTypeFromSameDev(ProtectGroup pg) {
        List<OpenStackVolumeType> srcVolumeTypes = this.getSrcVolumeTypes(pg.getPolist());
        if (VerifyUtil.isEmpty(srcVolumeTypes)) {
            logger.error((Object)" empty volumeTypes.", 90160758787071L);
            throw new LegoCheckedException(1073949728L);
        }
        return this.volumeService.isVolTypesFromSameDev(srcVolumeTypes);
    }

    protected List<OpenStackVolumeType> getSrcVolumeTypes(Collection<ProtectObject> pos) {
        ArrayList<String> vmUuids = new ArrayList<String>();
        for (ProtectObject po : pos) {
            if (VerifyUtil.isEmpty((String)po.getMoUuid())) {
                logger.error((Object)("mouuid is empty. poUuid=" + po.getUuid()), 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            vmUuids.add(po.getMoUuid());
        }
        ProtectGroup pg = ((ProtectObject)CommonUtil.getFirstElement(pos)).getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        List volumeTypes = this.volumeService.getVolumeTypesUsedByVMs(regionUuid, projectUuid, vmUuids);
        return volumeTypes;
    }

    protected void dealUnProtectedVolume(Map<String, List<ProtectObject>> unprotectVolUuidPoMap, Map<String, PoReplicaPairInfo> newCreatePairInfoMap, String replicaKey) {
        if (VerifyUtil.isEmpty(unprotectVolUuidPoMap) || VerifyUtil.isEmpty(newCreatePairInfoMap)) {
            logger.info((Object)"no unprotected volume or no new create pairinfo");
            return;
        }
        HashMap<String, PoReplicaPairInfo> filledNewCreatePairInfoMap = new HashMap<String, PoReplicaPairInfo>(newCreatePairInfoMap);
        this.fillPairMap(unprotectVolUuidPoMap, filledNewCreatePairInfoMap, replicaKey);
        for (Map.Entry<String, List<ProtectObject>> entry : unprotectVolUuidPoMap.entrySet()) {
            String volumeUuid = entry.getKey();
            for (ProtectObject po : entry.getValue()) {
                if (!filledNewCreatePairInfoMap.keySet().contains(volumeUuid)) continue;
                String replicaInfoStr = po.getProperty(replicaKey);
                if (VerifyUtil.isEmpty((String)replicaInfoStr)) {
                    logger.warn((Object)"can not find replicaKey:%s for po:%s", new Object[]{replicaKey, po.getName()});
                    continue;
                }
                PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
                if (null == replicaInfo) {
                    logger.error((Object)"convert json failed:");
                    continue;
                }
                this.removeOldPair(volumeUuid, po, replicaInfo);
                replicaInfo.getPairInfos().add(filledNewCreatePairInfoMap.get(volumeUuid));
                String newReplicaInfoStr = JsonUtil.beanToJson(replicaInfo);
                po.getProps().put(replicaKey, newReplicaInfoStr);
            }
        }
    }

    private void removeOldPair(String volumeUuid, ProtectObject po, PoReplicaInfo replicaInfo) {
        PoReplicaPairInfo findPairInfo = null;
        for (PoReplicaPairInfo pairInfo : replicaInfo.getPairInfos()) {
            if (!pairInfo.getVolumeUuid().equals(volumeUuid)) continue;
            findPairInfo = pairInfo;
            break;
        }
        if (!VerifyUtil.isEmpty(findPairInfo)) {
            replicaInfo.getPairInfos().remove(findPairInfo);
        } else {
            logger.warn((Object)"can not find po:%s pair for:%s", new Object[]{po.getName(), volumeUuid});
        }
    }

    private void fillPairMap(Map<String, List<ProtectObject>> unprotectVolUuidPoMap, Map<String, PoReplicaPairInfo> newCreatePairInfoMap, String replicaKey) {
        if (!"remote_replicationInfo".equals(replicaKey)) {
            return;
        }
        for (List<ProtectObject> pos : unprotectVolUuidPoMap.values()) {
            if (VerifyUtil.isEmpty(pos)) continue;
            for (ProtectObject po : pos) {
                this.fillPairMapByPo(newCreatePairInfoMap, po);
            }
        }
    }

    private void fillPairMapByPo(Map<String, PoReplicaPairInfo> newCreatePairInfoMap, ProtectObject po) {
        String replicaInfoStr = (String)po.getProps().get("hypermetor_replicationInfo");
        if (VerifyUtil.isEmpty((String)replicaInfoStr)) {
            return;
        }
        PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
        if (null == replicaInfo) {
            logger.error((Object)"convert json failed:%s", new Object[]{po.getName()});
            return;
        }
        for (PoReplicaPairInfo pairInfo : replicaInfo.getPairInfos()) {
            if (newCreatePairInfoMap.containsKey(pairInfo.getVolumeUuid())) {
                newCreatePairInfoMap.put(pairInfo.getDrVolumeUuid(), newCreatePairInfoMap.get(pairInfo.getVolumeUuid()));
                continue;
            }
            if (!newCreatePairInfoMap.containsKey(pairInfo.getDrVolumeUuid())) continue;
            newCreatePairInfoMap.put(pairInfo.getVolumeUuid(), newCreatePairInfoMap.get(pairInfo.getDrVolumeUuid()));
        }
    }

    protected void dealUnNeedProtectVolume(ProtectGroup pg, Map<String, List<ProtectObject>> unNeedProtectVolUuidPoMap, Map<String, PoReplicaPairInfo> protectedPairInfoMap, Map<String, List<ProtectObject>> protectedVolUuidPoMap, Map<String, PoReplicaInfo> poReplicaInfoMap) {
        for (Map.Entry<String, List<ProtectObject>> entry : unNeedProtectVolUuidPoMap.entrySet()) {
            String volUuid = entry.getKey();
            for (ProtectObject po : entry.getValue()) {
                PoReplicaInfo poReplicaInfo;
                if (!poReplicaInfoMap.containsKey(po.getUuid())) {
                    poReplicaInfo = this.createPoReplicaInfo(pg, po);
                    poReplicaInfoMap.put(po.getUuid(), poReplicaInfo);
                }
                poReplicaInfo = poReplicaInfoMap.get(po.getUuid());
                PoReplicaPairInfo protectdPairInfo = protectedPairInfoMap.get(volUuid);
                String volumeStatus = protectdPairInfo.getVolumeStatus();
                if (volumeStatus.equals(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus())) {
                    logger.info((Object)("the volume has been protected: volumeUuid=" + volUuid));
                    poReplicaInfo.getPairInfos().add(protectdPairInfo);
                    continue;
                }
                if (!volumeStatus.equals(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.REMOVED.getStatus())) continue;
                this.updatePoPropOfRemovedVol(volUuid, protectedVolUuidPoMap.get(volUuid));
                protectedPairInfoMap.get(volUuid).setVolumeStatus(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus());
                poReplicaInfo.getPairInfos().add(protectdPairInfo);
            }
        }
    }

    protected void getAddedPoVolumeInfoMap(ProtectGroup pg, Map<String, PoReplicaPairInfo> protectedPairInfoMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap, Map<String, List<ProtectObject>> unNeedProtectVolUuidPoMap) {
        boolean isUpgrade = !VerifyUtil.isEmpty((String)((String)pg.getProps().get("BEFORE_UPGRADE_TYPE")));
        for (ProtectObject po : pg.getPolist()) {
            if (!(isUpgrade || po.getPoStatus() != ProtectObjectStatusEnum.INVALID.getValue() && VerifyUtil.isEmpty((String)((String)po.getProps().get("replicationInfo"))))) {
                logger.info((Object)("the po is invalid or has protected:poName=" + po.getName()));
                continue;
            }
            JSONArray volConfigArray = JSONArray.fromObject(po.getProps().get("volumeConfig"));
            for (int i = 0; i < volConfigArray.size(); ++i) {
                JSONObject volJson = volConfigArray.getJSONObject(i);
                String volUuid = volJson.getString("volumeId");
                if (isUpgrade) {
                    if (protectedPairInfoMap.containsKey(volUuid)) {
                        this.putProtectObjectToMap(volUuid, po, needProtectVolUuidPoMap);
                        continue;
                    }
                } else if (!protectedPairInfoMap.containsKey(volUuid)) {
                    this.putProtectObjectToMap(volUuid, po, needProtectVolUuidPoMap);
                    continue;
                }
                if (!unNeedProtectVolUuidPoMap.containsKey(volUuid)) {
                    unNeedProtectVolUuidPoMap.put(volUuid, new ArrayList());
                }
                unNeedProtectVolUuidPoMap.get(volUuid).add(po);
            }
        }
        logger.info((Object)("needProtectVolUuidPoMap size=" + needProtectVolUuidPoMap.size()));
        logger.info((Object)("unNeedProtectVolUuidPoMap size=" + unNeedProtectVolUuidPoMap.size()));
    }

    private void putProtectObjectToMap(String volUuid, ProtectObject po, Map<String, List<ProtectObject>> needProtectVolUuidPoMap) {
        if (!needProtectVolUuidPoMap.containsKey(volUuid)) {
            needProtectVolUuidPoMap.put(volUuid, new ArrayList());
        }
        needProtectVolUuidPoMap.get(volUuid).add(po);
    }

    protected void makePgReplica(ProtectGroup pg) {
        if (pg.getReplicaList().isEmpty()) {
            ProtectGroupReplica pgReplica = new ProtectGroupReplica();
            pgReplica.setId(UUIDGenerator.getUUID());
            pgReplica.setIndex(1);
            pgReplica.setName("REMOTEREPLICA-" + pg.getName() + 1);
            pgReplica.setProductArray(pg.getPoProviderSN());
            pgReplica.setRecoveryArray(pg.getPoProviderSN());
            pgReplica.setType(this.getProtectType());
            pgReplica.setStatus(1 == this.getProtectType() || 2 == this.getProtectType() ? DrmEnumDefine.REPLICA_STATUS.ACTIVE_STATUS.getValue() : DrmEnumDefine.REPLICA_STATUS.UNACTIVE_STATUS.getValue());
            pgReplica.setPg(pg);
            pgReplica.setRecoverySite(pg.getProductSiteId());
            pg.getReplicaList().add(pgReplica);
        } else {
            for (ProtectGroupReplica replica : pg.getReplicaList()) {
                if (replica.getPg() != null) continue;
                replica.setPg(pg);
            }
        }
    }

    protected boolean checkVolumeStatus(ProtectGroup pg, Map<String, PoReplicaPairInfo> pairInfoMap) {
        for (ProtectObject po : pg.getPolist()) {
            String replicaInfoStr = (String)po.getProps().get("replicationInfo");
            if (!VerifyUtil.isEmpty((String)replicaInfoStr)) continue;
            JSONArray volConfigArray = JSONArray.fromObject(po.getProps().get("volumeConfig"));
            for (int i = 0; i < volConfigArray.size(); ++i) {
                JSONObject json = volConfigArray.getJSONObject(i);
                String volumeUuid = json.getString("volumeId");
                if (null == volumeUuid || !pairInfoMap.containsKey(volumeUuid)) continue;
                PoReplicaPairInfo pairInfo = pairInfoMap.get(volumeUuid);
                String status = pairInfo.getVolumeStatus();
                if (!OpenstackEnumDefine.VOL_PROTECT_STATUS_E.CONFIGING.getStatus().equals(status) && !OpenstackEnumDefine.VOL_PROTECT_STATUS_E.RELEASING.getStatus().equals(status)) continue;
                return false;
            }
        }
        return true;
    }

    protected void getPairInfoMap(ProtectGroup pg, Map<String, PoReplicaPairInfo> protectedPairInfoMap, Map<String, List<ProtectObject>> protectedVolUuidPoMap, Map<String, List<ProtectObject>> unprotectVolUuidPoMap) {
        for (ProtectObject po : pg.getPolist()) {
            PoReplicaInfo replicaInfo;
            String replicaInfoStr = (String)po.getProps().get("replicationInfo");
            if (VerifyUtil.isEmpty((String)replicaInfoStr) || null == (replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class))) continue;
            for (PoReplicaPairInfo pairInfo : replicaInfo.getPairInfos()) {
                ArrayList poList;
                String volumeUuid = pairInfo.getVolumeUuid();
                if (OpenstackEnumDefine.VOL_PROTECT_STATUS_E.UNPROTECTED.getStatus().equals(pairInfo.getVolumeStatus())) {
                    if (!unprotectVolUuidPoMap.containsKey(volumeUuid)) {
                        poList = new ArrayList();
                        unprotectVolUuidPoMap.put(volumeUuid, poList);
                    }
                    unprotectVolUuidPoMap.get(volumeUuid).add(po);
                    continue;
                }
                if (!protectedPairInfoMap.keySet().contains(volumeUuid)) {
                    protectedPairInfoMap.put(volumeUuid, pairInfo);
                }
                if (!protectedVolUuidPoMap.containsKey(volumeUuid)) {
                    poList = new ArrayList();
                    protectedVolUuidPoMap.put(volumeUuid, poList);
                }
                protectedVolUuidPoMap.get(volumeUuid).add(po);
            }
        }
    }

    protected void updatePgProp(ProtectGroup pg, String srcVolTypeName, String drVolTypeName, String aHyperMetorDrVolTypeName) {
        String hyperMetroProjectUuid;
        String hyperMetroRegionUuid;
        String regionUuid = (String)pg.getProps().get("regionId");
        String projectUuid = (String)pg.getProps().get("projectId");
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjectUuid = (String)pg.getProps().get("drProjectId");
        if (!VerifyUtil.isEmpty((String)regionUuid)) {
            String regionName = CommonDAOLocator.getMoDao().getMoByUuid(regionUuid, Boolean.valueOf(true)).getName();
            pg.getProps().put("regionName", regionName);
        }
        if (!VerifyUtil.isEmpty((String)projectUuid)) {
            String projectName = this.getProjectName(projectUuid);
            pg.getProps().put("projectName", projectName);
        }
        if (!VerifyUtil.isEmpty((String)drRegionUuid)) {
            String drRegionName = CommonDAOLocator.getMoDao().getMoByUuid(drRegionUuid, Boolean.valueOf(true)).getName();
            pg.getProps().put("drRegionName", drRegionName);
        }
        if (!VerifyUtil.isEmpty((String)drProjectUuid)) {
            String drProjectName = this.getProjectName(drProjectUuid);
            pg.getProps().put("drProjectName", drProjectName);
        }
        if (!VerifyUtil.isEmpty((String)srcVolTypeName)) {
            String localDevSn = this.getDevSnFromVolumeType(srcVolTypeName, regionUuid, projectUuid);
            pg.getProps().put("localStorageDevSn", localDevSn);
        }
        if (!VerifyUtil.isEmpty((String)drVolTypeName)) {
            String remoteDevSn = this.getDevSnFromVolumeType(drVolTypeName, drRegionUuid, drProjectUuid);
            pg.getProps().put("remoteStorageDevSn", remoteDevSn);
        }
        if (VerifyUtil.isEmpty((String)aHyperMetorDrVolTypeName)) {
            return;
        }
        if (OpenStackBasicUtil.isCsdrVhaMode(pg)) {
            hyperMetroRegionUuid = drRegionUuid;
            hyperMetroProjectUuid = drProjectUuid;
        } else {
            hyperMetroRegionUuid = regionUuid;
            hyperMetroProjectUuid = projectUuid;
        }
        String remoteDevSn = this.getDevSnFromVolumeType(aHyperMetorDrVolTypeName, hyperMetroRegionUuid, hyperMetroProjectUuid);
        pg.getProps().put("remoteDRHyperMetorStorageDevSn", remoteDevSn);
    }

    private String getProjectName(String projectUuid) {
        OpenStackProject openStackProject = ((IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class)).getProjectByProjectUUid(projectUuid);
        if (!VerifyUtil.isEmpty((Object)openStackProject)) {
            return openStackProject.getName();
        }
        logger.error((Object)("openStackProject null,projectUuid:" + projectUuid));
        throw new LegoCheckedException(65540L);
    }

    private String getDevSnFromVolumeType(String volumeTypeName, String regionUuid, String projectUuid) {
        HashSet<String> nameSet = new HashSet<String>();
        nameSet.add(volumeTypeName);
        List volTypeList = this.volumeService.getVolumeTypesByName(nameSet, regionUuid, projectUuid);
        OpenStackVolumeType type = (OpenStackVolumeType)CommonUtil.getFirstElement((Collection)volTypeList);
        String devSn = "";
        if (!VerifyUtil.isEmpty((Object)type)) {
            devSn = type.getDevSn();
        }
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)" the devSn can not be empty, devSn is null, volumeTypeName is %s", new Object[]{volumeTypeName});
            throw new LegoCheckedException(1073947394L);
        }
        logger.info((Object)"devSn is %s", new Object[]{devSn});
        return devSn;
    }

    protected boolean checkDrVolTypeExist(ProtectGroup pg, Map<String, String> drVolTypeMap, Map<String, String> drHyperMetroVolTypeMap) {
        String azIdentity = this.getAzIdentity(pg);
        List<OpenStackVolTypeMapping> volTypeList = this.getOpenStackVolTypeMappings(pg, azIdentity);
        List<OpenStackVolTypeMapping> vhaHyperMetorVolTypeList = this.filterVolTypeMappingsByServiceType(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue(), azIdentity);
        for (ProtectObject po : pg.getPolist()) {
            JSONArray jsonArray = JSONArray.fromObject(po.getProps().get("volumeConfig"));
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject json = jsonArray.getJSONObject(i);
                String volumeUuid = (String)json.get("volumeId");
                String drVolTypeName = (String)json.get("drVolumeType");
                if (VerifyUtil.isEmpty((String)drVolTypeName) && json.containsKey((Object)"volumeType")) {
                    String srVolType = json.getString("volumeType");
                    drVolTypeName = AbstractServiceInstanceCreateImpl.findDrVolType(srVolType, volTypeList, pg);
                    logger.debug((Object)("findDrVolType:" + drVolTypeName));
                }
                if (VerifyUtil.isEmpty((String)drVolTypeName)) {
                    if (34 != pg.getTemplate().getType() && 37 != pg.getTemplate().getType()) {
                        return false;
                    }
                    if (OpenStackCommonUtil.isBareMetalServer(po)) continue;
                    JSONObject newPoVolCfgJson = this.updataPoPropsVolumeConfig(pg, po, json);
                    if (VerifyUtil.isEmpty((Object)newPoVolCfgJson.get("drVolumeType"))) {
                        return false;
                    }
                    json = newPoVolCfgJson;
                    drVolTypeName = (String)json.get("drVolumeType");
                }
                if (!drVolTypeMap.containsKey(volumeUuid)) {
                    drVolTypeMap.put(volumeUuid, drVolTypeName);
                }
                this.dealVolTypeForRing(pg, drHyperMetroVolTypeMap, vhaHyperMetorVolTypeList, json, volumeUuid);
            }
        }
        return true;
    }

    private String getAzIdentity(ProtectGroup pg) {
        String azName = (String)pg.getProps().get("zoneName");
        String drAzName = (String)pg.getProps().get("drZoneName");
        String regionName = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("regionId"));
        String drRegionName = OpenStackCommonUtil.getIdFromUuid((String)pg.getProps().get("drRegionId"));
        return OpenStackVolTypeMapping.getAzIdentity((String)regionName, (String)azName, (String)drRegionName, (String)drAzName);
    }

    private void dealVolTypeForRing(ProtectGroup pg, Map<String, String> drHyperMetroVolTypeMap, List<OpenStackVolTypeMapping> vhaHyperMetorVolTypeList, JSONObject json, String volumeUuid) {
        boolean isCshaArray;
        boolean isvhaArray = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.getValue().equals(pg.getProps().get("serviceInstanceType")) && 34 == pg.getTemplate().getType();
        boolean bl = isCshaArray = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue().equals(pg.getProps().get("serviceInstanceType")) && 37 == pg.getTemplate().getType();
        if (isvhaArray || isCshaArray) {
            String drHyperMetorVolTypeName;
            String string = drHyperMetorVolTypeName = json.containsKey((Object)"drHyperVolumeType") ? (String)json.get("drHyperVolumeType") : null;
            if (VerifyUtil.isEmpty((String)drHyperMetorVolTypeName) && json.containsKey((Object)"volumeType")) {
                logger.warn((Object)"can not find drHyperMetorVolTypeName from json.");
                drHyperMetorVolTypeName = AbstractServiceInstanceCreateImpl.findDrVolType(json.getString("volumeType"), vhaHyperMetorVolTypeList, pg);
            }
            logger.info((Object)("drHyperMetorVolTypeName:" + drHyperMetorVolTypeName));
            if (!VerifyUtil.isEmpty((String)drHyperMetorVolTypeName)) {
                drHyperMetroVolTypeMap.put(volumeUuid, drHyperMetorVolTypeName);
            }
        }
    }

    private List<OpenStackVolTypeMapping> getOpenStackVolTypeMappings(ProtectGroup pg, String azIdentity) {
        String serviceType = (String)pg.getProps().get("serviceInstanceType");
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.isCurrent(serviceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.isCurrent(serviceType)) {
            serviceType = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue();
        }
        return this.filterVolTypeMappingsByServiceType(serviceType, azIdentity);
    }

    private List<OpenStackVolTypeMapping> filterVolTypeMappingsByServiceType(String serviceType, String azIdentity) {
        List volTypeList = null;
        if (!VerifyUtil.isEmpty((Object)ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)serviceType))) {
            String openStackUuid = OpenStackCommonUtil.getOpenstack().getUuid();
            volTypeList = ((IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class)).getVolTypeMappingsFromDB(openStackUuid);
            Iterator volTypeIterator = volTypeList.iterator();
            while (volTypeIterator.hasNext()) {
                OpenStackVolTypeMapping openStackVolTypeMapping = (OpenStackVolTypeMapping)volTypeIterator.next();
                if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)serviceType) != ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)openStackVolTypeMapping.getType())) {
                    volTypeIterator.remove();
                    continue;
                }
                if (VerifyUtil.isEmpty((String)openStackVolTypeMapping.getAzIdentity()) || openStackVolTypeMapping.getAzIdentity().equals(azIdentity)) continue;
                volTypeIterator.remove();
            }
            logger.debug((Object)("volTypeList is:" + volTypeList));
        }
        return volTypeList;
    }

    protected boolean checkVolTypeFromSameDev(ProtectGroup pg, Collection<String> drVolTypeNames) {
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        HashSet<String> drVolTypeSet = new HashSet<String>();
        for (String drVolType : drVolTypeNames) {
            drVolTypeSet.add(drVolType);
        }
        List volTypeList = this.volumeService.getVolumeTypesByName(drVolTypeSet, drRegionUuid, drProjUuid);
        if (VerifyUtil.isEmpty((Collection)volTypeList) || drVolTypeSet.size() != volTypeList.size()) {
            logger.error((Object)"query voltype failed ,result is empty");
            throw new LegoCheckedException(1073949726L);
        }
        return this.volumeService.isVolTypesFromSameDev(volTypeList);
    }

    protected void updatePoProp(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, OpenStackVolume> uuidVolMap) {
        String cgUuid = (String)pg.getProps().get("replicaCgUuid");
        String drCgUuid = (String)pg.getProps().get("drReplicaCgUuid");
        String zoneName = (String)pg.getProps().get("zoneName");
        String regionName = (String)pg.getProps().get("regionName");
        String projectName = (String)pg.getProps().get("projectName");
        for (ProtectObject po : pg.getPolist()) {
            po.getProps().put("regionId", regionName);
            po.getProps().put("projectName", projectName);
            po.getProps().put("zoneName", zoneName);
            this.buildDeviceName(po, uuidVolMap);
            PoReplicaInfo replicaInfo = poReplicaInfoMap.get(po.getUuid());
            if (null == replicaInfo) {
                logger.info((Object)("this po has protected:poName=" + po.getName()));
                continue;
            }
            replicaInfo.setCgUuid(cgUuid);
            replicaInfo.setDrCgUuid(drCgUuid);
            replicaInfo.setAllVolumeStatus(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus());
            po.getProps().put("replicationInfo", JsonUtil.beanToJson(replicaInfo));
        }
    }

    protected void updatePoPropForRing(ProtectGroup pg, Map<String, PoReplicaInfo> poHyperMetorReplicaInfoMap, Map<String, OpenStackVolume> uuidVolMap, Map<String, PoReplicaInfo> poRemoteReplicaInfoMap) {
        String cgUuid = (String)pg.getProps().get("hyperProCgUuid");
        String drCgUuid = (String)pg.getProps().get("hyperProdrCgUuid");
        String cgRemoteUuid = (String)pg.getProps().get("hyperProRemoteCgUuid");
        String drRemoteCgUuid = (String)pg.getProps().get("hyperProRemotedrCgUuid");
        String zoneName = (String)pg.getProps().get("zoneName");
        String regionName = (String)pg.getProps().get("regionName");
        String projectName = (String)pg.getProps().get("projectName");
        for (ProtectObject po : pg.getPolist()) {
            po.getProps().put("regionId", regionName);
            po.getProps().put("projectName", projectName);
            po.getProps().put("zoneName", zoneName);
            PoReplicaInfo replicaInfo = poHyperMetorReplicaInfoMap.get(po.getUuid());
            if (null == replicaInfo) {
                logger.info((Object)("The protected object has been protected. protectGroup name= " + po.getName()));
                continue;
            }
            replicaInfo.setCgUuid(cgUuid);
            replicaInfo.setDrCgUuid(drCgUuid);
            replicaInfo.setAllVolumeStatus(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus());
            po.getProps().put("hypermetor_replicationInfo", JsonUtil.beanToJson(replicaInfo));
            PoReplicaInfo replicaInfoRemote = poRemoteReplicaInfoMap.get(po.getUuid());
            if (null == replicaInfoRemote) {
                logger.info((Object)("this po has protected:protectGroup name=" + po.getName()));
                continue;
            }
            replicaInfoRemote.setCgUuid(cgRemoteUuid);
            replicaInfoRemote.setDrCgUuid(drRemoteCgUuid);
            replicaInfoRemote.setAllVolumeStatus(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus());
            po.getProps().put("remote_replicationInfo", JsonUtil.beanToJson(replicaInfoRemote));
        }
    }

    private void buildDeviceName(ProtectObject po, Map<String, OpenStackVolume> uuidVolMap) {
        if (null == uuidVolMap) {
            logger.error((Object)"po used volume is empty");
            return;
        }
        logger.debug((Object)("uuidVolMap uuids :" + uuidVolMap.keySet()));
        Collection<OpenStackVolume> vols = uuidVolMap.values();
        for (OpenStackVolume volume : vols) {
            volume.generateAttachmentInfo();
            String deviceName = this.getDeviceName(po, volume);
            boolean hasStorageInfo = this.modifyOldStorageDeviceName(po, volume, deviceName);
            if (hasStorageInfo || null == deviceName || deviceName.trim().isEmpty()) {
                logger.debug((Object)("po(" + po.getName() + ") has ProtectObjectStorageInfo or deviceName(" + deviceName + ") is empty"));
                continue;
            }
            ProtectObjectStorageInfo storage = new ProtectObjectStorageInfo();
            storage.setId(UUIDGenerator.getUUID());
            storage.setResourceName(volume.getName());
            storage.setLunWWN(volume.getUuid());
            storage.setResourceId(volume.getUuid());
            storage.setResourceProviderSN(OpenStackCommonUtil.getOpenstackUuidFromStr(volume.getUuid()));
            storage.setDeviceName(deviceName);
            this.initStorageMetadata(po, storage);
        }
    }

    private boolean modifyOldStorageDeviceName(ProtectObject po, OpenStackVolume volume, String deviceName) {
        String storageMetadata = po.getStorageMetadata();
        if (null != storageMetadata && !storageMetadata.trim().isEmpty()) {
            Class<ProtectObjectStorageInfo> clazz;
            JSONArray array = JSONArray.fromObject((Object)storageMetadata);
            List collection = JSONArray.toCollection((JSONArray)array, clazz = ProtectObjectStorageInfo.class);
            if (null == collection) {
                return false;
            }
            for (ProtectObjectStorageInfo info : collection) {
                if (!volume.getUuid().equals(info.getResourceId())) continue;
                info.setDeviceName(deviceName);
                info.setResourceName(volume.getName());
                String newStorageMetadata = JSONArray.fromObject((Object)collection).toString();
                po.setStorageMetadata(newStorageMetadata);
                return true;
            }
        }
        return false;
    }

    private String getDeviceName(ProtectObject po, OpenStackVolume volume) {
        for (OpenStackVolAttachment attachment : volume.getAttachments()) {
            if (!po.getMoUuid().equals(attachment.getVmUuid())) continue;
            return attachment.getDevice();
        }
        return null;
    }

    private void initStorageMetadata(ProtectObject po, ProtectObjectStorageInfo storage) {
        ArrayList<ProtectObjectStorageInfo> storages = new ArrayList<ProtectObjectStorageInfo>();
        String storageMetadata = po.getStorageMetadata();
        if (null != storageMetadata && !storageMetadata.trim().isEmpty()) {
            JSONArray array = JSONArray.fromObject((Object)storageMetadata);
            Class<ProtectObjectStorageInfo> clazz = ProtectObjectStorageInfo.class;
            List collection = JSONArray.toCollection((JSONArray)array, clazz);
            storages.addAll(collection);
        }
        storages.add(storage);
        String newStorageMetadata = JSONArray.fromObject(storages).toString();
        po.setStorageMetadata(newStorageMetadata);
    }

    protected void startRollback(final ProtectGroup pg, final Map<String, PoReplicaInfo> poReplicaInfoMap, final String replicationSide, final Map<String, PoReplicaInfo> poDRReplicaInfoMap, final Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap) {
        String beforeUpgradeType = (String)pg.getProps().get("BEFORE_UPGRADE_TYPE");
        final int operationType = VerifyUtil.isEmpty((Collection)pg.getReplicaList()) ? OpenstackEnumDefine.ROLLBACK_OPERATION_TYPE_E.CREATE_PROTECTGROUP.getType() : (!VerifyUtil.isEmpty((String)beforeUpgradeType) ? OpenstackEnumDefine.ROLLBACK_OPERATION_TYPE_E.CREATE_PROTECTGROUP.getType() : OpenstackEnumDefine.ROLLBACK_OPERATION_TYPE_E.ADD_PROTECTOBJECT.getType());
        new Thread("SumbmitRollBackTaskThread"){

            @Override
            public void run() {
                if (null != replicationSide) {
                    ArrayReplicationReplicaBuilder.rollBackupVhaCsdr(pg, poReplicaInfoMap, replicationSide, poDRReplicaInfoMap, poHyperMetroReplicaInfoMap, operationType);
                } else {
                    for (PoReplicaInfo poReplicaInfo : poReplicaInfoMap.values()) {
                        logger.info((Object)("start rollback,poReplicationInfo=" + JsonUtil.beanToJson(poReplicaInfo)));
                        List pairInfoList = poReplicaInfo.getPairInfos();
                        if (VerifyUtil.isEmpty((Collection)pairInfoList)) continue;
                        JSONObject json = new JSONObject();
                        json.put((Object)"operationType", (Object)operationType);
                        json.put((Object)"replicationInfo", (Object)JSONObject.fromObject((Object)poReplicaInfo));
                        RollBackTaskInfo taskInfo = OpenStackCommonUtil.getRollBackTask(poReplicaInfo, json);
                        RollBackTaskManager.getInstance().addTask(taskInfo, true);
                    }
                }
            }
        }.start();
    }

    protected void mergeShareVolume(Map<String, PoReplicaInfo> poReplicaInfoMap) {
        HashSet<String> volumeUuidSet = new HashSet<String>();
        ArrayList tempPairList = new ArrayList();
        for (PoReplicaInfo replicaInfo : poReplicaInfoMap.values()) {
            tempPairList.addAll(replicaInfo.getPairInfos());
            for (PoReplicaPairInfo pairInfo : tempPairList) {
                String volUuid = pairInfo.getVolumeUuid();
                if (!VerifyUtil.isEmpty((String)volUuid) && !volumeUuidSet.contains(volUuid)) {
                    volumeUuidSet.add(volUuid);
                    continue;
                }
                replicaInfo.getPairInfos().remove(pairInfo);
            }
        }
    }

    protected Map<String, PoReplicaPairInfo> protectVolumes(ProtectGroup pg, Map<String, OpenStackVolume> uuidVolMap, Map<String, String> drVolTypeMap, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap) {
        List<Callable<CreateReplicationTaskResult>> taskList = this.getCreateReplicaTasks(pg, uuidVolMap, drVolTypeMap, needProtectVolUuidPoMap);
        if (VerifyUtil.isEmpty(taskList)) {
            logger.info((Object)("this pg has no volume to be protected, protectGroup name=" + pg.getName()));
            return Collections.emptyMap();
        }
        List<CreateReplicationTaskResult> createResultList = this.generateCreateReplicationTaskList(taskList, pg);
        HashMap<String, PoReplicaPairInfo> newPairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        boolean result = ArrayReplicationReplicaBuilder.checkCreateResult(createResultList, newPairInfoMap);
        if (VerifyUtil.isEmpty(newPairInfoMap)) {
            logger.error((Object)("create replication failed:pairInfoMap is empty.protectGroup name=" + pg.getName()));
            throw new LegoCheckedException(1073948407L);
        }
        for (Map.Entry<String, List<ProtectObject>> entry : needProtectVolUuidPoMap.entrySet()) {
            String srcVolUuid = entry.getKey();
            for (ProtectObject po : entry.getValue()) {
                PoReplicaInfo replicaInfo;
                if (!poReplicaInfoMap.containsKey(po.getUuid())) {
                    PoReplicaInfo tempReplicaInfo = this.createPoReplicaInfo(pg, po);
                    poReplicaInfoMap.put(po.getUuid(), tempReplicaInfo);
                }
                if (VerifyUtil.isEmpty((Object)(replicaInfo = poReplicaInfoMap.get(po.getUuid()))) || VerifyUtil.isEmpty(newPairInfoMap.get(srcVolUuid))) continue;
                logger.info((Object)("replicaInfo mouuid=" + replicaInfo.getMoUuid() + ",vmname=" + replicaInfo.getVmName() + ",add pairs:" + newPairInfoMap.get(srcVolUuid) + ",protectGroup name=" + pg.getName()));
                replicaInfo.getPairInfos().add(newPairInfoMap.get(srcVolUuid));
            }
        }
        this.checkIsExistFailureTask(result, createResultList, taskList, newPairInfoMap);
        this.updateVolumeReplicationCG(pg, newPairInfoMap, poReplicaInfoMap);
        return newPairInfoMap;
    }

    private void updateVolumeReplicationCG(ProtectGroup pg, Map<String, PoReplicaPairInfo> newPairInfoMap, Map<String, PoReplicaInfo> poReplicaInfoMap) {
        ArrayList<PoReplicaPairInfo> newPairInfoList = new ArrayList<PoReplicaPairInfo>();
        newPairInfoList.addAll(newPairInfoMap.values());
        String upgradeType = (String)pg.getProps().get("BEFORE_UPGRADE_TYPE");
        if (!VerifyUtil.isEmpty((Collection)pg.getReplicaList()) && VerifyUtil.isEmpty((String)upgradeType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(upgradeType)) {
            OpenStackCommonUtil.switchAllRing(pg, false);
            this.updateCG(pg, poReplicaInfoMap, newPairInfoList, false);
        } else {
            this.createCG(pg, poReplicaInfoMap, newPairInfoList, true);
        }
    }

    protected Map<String, PoReplicaPairInfo> protectVolumesForRing(ProtectGroup pg, Map<String, OpenStackVolume> uuidVolMap, Map<String, String> drVolTypeMap, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap, Map<String, VolumeInfo> drHyperUUIDTDrVolumeInfo) {
        List<Callable<CreateReplicationTaskResult>> taskList = this.getCreateReplicaTasksForcreatedVolume(pg, uuidVolMap, drVolTypeMap, needProtectVolUuidPoMap, drHyperUUIDTDrVolumeInfo);
        if (VerifyUtil.isEmpty(taskList)) {
            logger.info((Object)("this pg has no volume to be protected, protectGroup name=" + pg.getName()));
            return Collections.emptyMap();
        }
        List<CreateReplicationTaskResult> createResultList = this.generateCreateReplicationTaskListForRing(taskList, pg);
        HashMap<String, PoReplicaPairInfo> newPairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        boolean result = ArrayReplicationReplicaBuilder.checkCreateResult(createResultList, newPairInfoMap);
        if (VerifyUtil.isEmpty(newPairInfoMap)) {
            logger.error((Object)("create replication failed:pairInfoMap is empty, protectGroup name=" + pg.getName()));
            throw new LegoCheckedException(1073948407L);
        }
        for (Map.Entry<String, List<ProtectObject>> entry : needProtectVolUuidPoMap.entrySet()) {
            String srcVolUuid = entry.getKey();
            for (ProtectObject po : entry.getValue()) {
                PoReplicaInfo replicaInfo;
                if (!poReplicaInfoMap.containsKey(po.getUuid())) {
                    PoReplicaInfo tempReplicaInfo = this.createPoReplicaInfo(pg, po);
                    poReplicaInfoMap.put(po.getUuid(), tempReplicaInfo);
                }
                if (VerifyUtil.isEmpty((Object)(replicaInfo = poReplicaInfoMap.get(po.getUuid()))) || VerifyUtil.isEmpty(newPairInfoMap.get(srcVolUuid))) continue;
                logger.info((Object)("replicaInfo mouuid=" + replicaInfo.getMoUuid() + ",vmname=" + replicaInfo.getVmName() + ",add pairs:" + newPairInfoMap.get(srcVolUuid) + ",protectGroup name=" + pg.getName()));
                replicaInfo.getPairInfos().add(newPairInfoMap.get(srcVolUuid));
            }
        }
        String replicaStatus = OpenStackCommonUtil.getRealTimeCGReplicaStatus(pg);
        this.checkIsExistFailureTask(result, createResultList, taskList, newPairInfoMap);
        boolean upgradeType = !VerifyUtil.isEmpty((String)((String)pg.getProps().get("BEFORE_UPGRADE_TYPE")));
        ArrayList<PoReplicaPairInfo> newPairInfoList = new ArrayList<PoReplicaPairInfo>(newPairInfoMap.values());
        if (!VerifyUtil.isEmpty((Collection)pg.getReplicaList()) && !upgradeType) {
            this.doUpdateCG(drHyperUUIDTDrVolumeInfo, pg, poReplicaInfoMap, newPairInfoList, replicaStatus);
        } else {
            this.createCG(pg, poReplicaInfoMap, newPairInfoList, false);
        }
        return newPairInfoMap;
    }

    private void doUpdateCG(Map<String, VolumeInfo> drHyperUUIDTDrVolumeInfo, ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, List<PoReplicaPairInfo> newPairInfoList, String replicaStatus) {
        if (drHyperUUIDTDrVolumeInfo == null) {
            if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(replicaStatus) && "async".equals(this.getReplicaModel(pg))) {
                this.updateCG(pg, poReplicaInfoMap, newPairInfoList, true);
            } else {
                if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(replicaStatus)) {
                    OpenStackCommonUtil.switchAllRing(pg, false);
                }
                this.updateCG(pg, poReplicaInfoMap, newPairInfoList, false);
            }
        } else {
            if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(replicaStatus)) {
                this.updateCG(pg, poReplicaInfoMap, newPairInfoList, false);
            } else {
                this.updateCG(pg, poReplicaInfoMap, newPairInfoList, true);
            }
            OpenStackCommonUtil.switchAllRing(pg, true);
        }
    }

    private void checkIsExistFailureTask(boolean result, List<CreateReplicationTaskResult> createResultList, List<Callable<CreateReplicationTaskResult>> taskList, Map<String, PoReplicaPairInfo> newPairInfoMap) {
        if (!result || createResultList.size() != taskList.size()) {
            logger.error((Object)("exist failed create replication task:result=" + result + ",newPair size=" + newPairInfoMap.size()));
            if (logger.isDebugEnabled()) {
                for (CreateReplicationTaskResult createResult : createResultList) {
                    if (createResult.isResultFlag()) continue;
                    logger.debug((Object)("failed create replication task=" + (Object)((Object)createResult)));
                }
            }
            throw new LegoCheckedException(1073948407L);
        }
    }

    protected List<CreateReplicationTaskResult> generateCreateReplicationTaskList(List<Callable<CreateReplicationTaskResult>> taskList, ProtectGroup pg) {
        int batchNum = OpenStackCommonUtil.getNumFromResource("replication.oper.task.batch.num", 20);
        int timeout = OpenStackCommonUtil.getNumFromResource("replication.oper.task.timeout", 1800);
        logger.info((Object)("configuration of task batch num=" + batchNum + " timeout=" + timeout + " taskList size=" + taskList.size()));
        List createResultList = ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)timeout, (int)batchNum);
        return createResultList;
    }

    protected PoReplicaInfo createPoReplicaInfo(ProtectGroup pg, ProtectObject po) {
        logger.debug((Object)("enter create PoReplicaInfo, protectGroup name=" + pg.getName() + ",protectObject name=" + po.getName() + ",protectObject uuid=" + po.getMoUuid()));
        String regionUuid = (String)pg.getProps().get("regionId");
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        if ((pg.getTemplate().getType() == 34 || pg.getTemplate().getType() == 37) && "hypermetro".equals(this.getReplicaModel(pg))) {
            drRegionUuid = (String)pg.getProps().get("regionId");
            drProjUuid = (String)pg.getProps().get("projectId");
        }
        PoReplicaInfo replicaInfo = new PoReplicaInfo(po.getMoUuid(), po.getName(), regionUuid, drRegionUuid, projUuid, drProjUuid);
        return replicaInfo;
    }

    private List<Callable<CreateReplicationTaskResult>> getCreateReplicaTasks(ProtectGroup pg, Map<String, OpenStackVolume> uuidVolMap, Map<String, String> drVolTypeMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap) {
        ArrayList<Callable<CreateReplicationTaskResult>> taskList = new ArrayList<Callable<CreateReplicationTaskResult>>();
        for (String srcVolumeUuid : needProtectVolUuidPoMap.keySet()) {
            String drVolType = drVolTypeMap.get(srcVolumeUuid);
            OpenStackVolume srcVolume = uuidVolMap.get(srcVolumeUuid);
            if (VerifyUtil.isEmpty((Object)srcVolume)) {
                logger.error((Object)("Create replication task, protectGroup name=" + pg.getName() + ",cant get Openstack Volume by uuid.uuid=" + srcVolumeUuid));
                continue;
            }
            CreateReplicationTask task = new CreateReplicationTask(this.volumeService, srcVolume, pg, drVolType, this.getReplicaModel(pg));
            taskList.add(task);
        }
        return taskList;
    }

    private List<Callable<CreateReplicationTaskResult>> getCreateReplicaTasksForcreatedVolume(ProtectGroup pg, Map<String, OpenStackVolume> uuidVolMap, Map<String, String> drVolTypeMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap, Map<String, VolumeInfo> drHyperUUIDTDrVolumeInfo) {
        ArrayList<Callable<CreateReplicationTaskResult>> taskList = new ArrayList<Callable<CreateReplicationTaskResult>>();
        for (String srcVolumeUuid : needProtectVolUuidPoMap.keySet()) {
            String drVolType = drVolTypeMap.get(srcVolumeUuid);
            OpenStackVolume srcVolume = uuidVolMap.get(srcVolumeUuid);
            if (VerifyUtil.isEmpty((Object)srcVolume)) {
                logger.info((Object)("cant get Openstack Volume by uuid.uuid=" + srcVolumeUuid + ",protectGroup name=" + pg.getName()));
                continue;
            }
            CreateReplicationTask task = new CreateReplicationTask(this.volumeService, srcVolume, pg, drVolType, this.getReplicaModel(pg), drHyperUUIDTDrVolumeInfo);
            taskList.add(task);
        }
        return taskList;
    }

    protected void updatePoPropOfRemovedVol(String volumeUuid, List<ProtectObject> poList) {
        for (ProtectObject po : poList) {
            String replicaInfoStr = (String)po.getProps().get("replicationInfo");
            PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
            if (null == replicaInfo) {
                logger.error((Object)"convert json failed:");
                continue;
            }
            for (PoReplicaPairInfo pairInfo : replicaInfo.getPairInfos()) {
                if (!pairInfo.getVolumeUuid().equals(volumeUuid)) continue;
                replicaInfo.getPairInfos().remove(pairInfo);
                break;
            }
            String newReplicaInfoStr = JsonUtil.beanToJson(replicaInfo);
            po.getProps().put("replicationInfo", newReplicaInfoStr);
        }
    }

    private void createCG(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, List<PoReplicaPairInfo> pairInfoList, boolean isSaveCGID) {
        logger.debug((Object)("enter createCG protectGroup name=" + pg.getName()));
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr((String)pg.getProps().get("regionId"));
        String cgUuid = null;
        String drCgUuid = null;
        try {
            VolumeReplicationCgInfo cgInfo = this.createReplicaCG(pg, pairInfoList, true);
            cgUuid = openstackUuid + ":" + cgInfo.getId();
            this.updatePoReplicaInfo(poReplicaInfoMap, cgUuid, true);
        }
        catch (LegoCheckedException e) {
            if (!VerifyUtil.isEmpty((Object[])e.getParameters())) {
                cgUuid = openstackUuid + ":" + e.getParameters()[0];
                this.updatePoReplicaInfo(poReplicaInfoMap, cgUuid, true);
            }
            logger.error((Object)("create production replicationCG failed.replicaCGUUID=" + cgUuid + ", protectGroup name=" + pg.getName()));
            throw e;
        }
        try {
            VolumeReplicationCgInfo drCgInfo = this.createReplicaCG(pg, pairInfoList, false);
            drCgUuid = openstackUuid + ":" + drCgInfo.getId();
            this.updatePoReplicaInfo(poReplicaInfoMap, drCgUuid, false);
        }
        catch (LegoCheckedException e) {
            if (!VerifyUtil.isEmpty((Object[])e.getParameters())) {
                drCgUuid = openstackUuid + ":" + e.getParameters()[0];
                this.updatePoReplicaInfo(poReplicaInfoMap, drCgUuid, false);
            }
            logger.error((Object)("create disater replicationCG failed.replica CGUUID=" + drCgUuid + ",protectGroup name=" + pg.getName()));
            throw e;
        }
        if (isSaveCGID) {
            pg.getProps().put("replicaCgUuid", cgUuid);
            pg.getProps().put("drReplicaCgUuid", drCgUuid);
        }
    }

    private void updateCG(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, List<PoReplicaPairInfo> newCreatedPairInfoList, boolean isUpdateStandySide) {
        logger.debug((Object)("enter updateCG pgname=" + pg.getName()));
        if (newCreatedPairInfoList.isEmpty()) {
            return;
        }
        this.addReplicaToCG(pg, newCreatedPairInfoList, true, isUpdateStandySide);
        this.addReplicaToCG(pg, newCreatedPairInfoList, false, isUpdateStandySide);
        if (34 != pg.getTemplate().getType() && 37 != pg.getTemplate().getType()) {
            this.updatePoReplicaInfo(poReplicaInfoMap, (String)pg.getProps().get("replicaCgUuid"), true);
            this.updatePoReplicaInfo(poReplicaInfoMap, (String)pg.getProps().get("drReplicaCgUuid"), false);
        } else {
            String updateCgUuid = (String)pg.getProps().get("replicaCgUuid");
            String updateDrCgUuid = (String)pg.getProps().get("drReplicaCgUuid");
            if ((34 == pg.getTemplate().getType() || 37 == pg.getTemplate().getType()) && "hypermetro".equals(this.getReplicaModel(pg))) {
                updateCgUuid = (String)pg.getProps().get("hyperProCgUuid");
                updateDrCgUuid = (String)pg.getProps().get("hyperProdrCgUuid");
            }
            if (!VerifyUtil.isEmpty((String)"hyperProRemoteCgUuid") && isUpdateStandySide) {
                updateCgUuid = (String)pg.getProps().get("hyperProRemoteCgUuid");
                updateDrCgUuid = (String)pg.getProps().get("hyperProRemotedrCgUuid");
            }
            this.updatePoReplicaInfo(poReplicaInfoMap, updateCgUuid, true);
            this.updatePoReplicaInfo(poReplicaInfoMap, updateDrCgUuid, false);
        }
    }

    private void updatePoReplicaInfo(Map<String, PoReplicaInfo> poReplicaInfoMap, String cgUuid, boolean isMaster) {
        for (PoReplicaInfo poReplicaInfo : poReplicaInfoMap.values()) {
            if (isMaster) {
                poReplicaInfo.setCgUuid(cgUuid);
                continue;
            }
            poReplicaInfo.setDrCgUuid(cgUuid);
            poReplicaInfo.setAllVolumeStatus(OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus());
        }
    }

    private void addReplicaToCG(ProtectGroup pg, List<PoReplicaPairInfo> newCreatedPairInfoList, boolean isMaster, boolean isUpdateStandySide) {
        String projUuid;
        String regionUuid;
        String cgUuid;
        if (VerifyUtil.isEmpty(newCreatedPairInfoList)) {
            return;
        }
        Set<String> replicaSet = OpenStackCommonUtil.getReplicaIdSet(newCreatedPairInfoList, isMaster);
        if (isMaster) {
            cgUuid = (String)pg.getProps().get("replicaCgUuid");
            regionUuid = (String)pg.getProps().get("regionId");
            projUuid = (String)pg.getProps().get("projectId");
            if ("hypermetro".equals(this.getReplicaModel(pg)) && (34 == pg.getTemplate().getType() || 37 == pg.getTemplate().getType())) {
                cgUuid = (String)pg.getProps().get("hyperProCgUuid");
            }
            if ((34 == pg.getTemplate().getType() || 37 == pg.getTemplate().getType()) && isUpdateStandySide) {
                cgUuid = (String)pg.getProps().get("hyperProRemoteCgUuid");
            }
        } else {
            cgUuid = (String)pg.getProps().get("drReplicaCgUuid");
            regionUuid = (String)pg.getProps().get("drRegionId");
            projUuid = (String)pg.getProps().get("drProjectId");
            if ("hypermetro".equals(this.getReplicaModel(pg)) && (34 == pg.getTemplate().getType() || 37 == pg.getTemplate().getType())) {
                cgUuid = (String)pg.getProps().get("hyperProdrCgUuid");
                regionUuid = (String)pg.getProps().get("regionId");
                projUuid = (String)pg.getProps().get("projectId");
            }
            if ((34 == pg.getTemplate().getType() || 37 == pg.getTemplate().getType()) && isUpdateStandySide) {
                cgUuid = (String)pg.getProps().get("hyperProRemotedrCgUuid");
            }
        }
        this.volumeService.updateVolumeReplicationCG(regionUuid, projUuid, cgUuid, replicaSet, null);
    }

    private VolumeReplicationCgInfo createReplicaCG(ProtectGroup pg, List<PoReplicaPairInfo> pairInfoList, boolean isMaster) {
        String azName;
        String projUuid;
        String regionUuid;
        if (VerifyUtil.isEmpty(pairInfoList)) {
            logger.error((Object)("createReplicaCG:replicaList is empty,protectGroup name=" + pg.getName()), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        String replicaIdStr = OpenStackCommonUtil.getReplicaIdStr(pairInfoList, isMaster);
        Map pgProps = pg.getProps();
        if (isMaster) {
            regionUuid = (String)pgProps.get("regionId");
            projUuid = (String)pgProps.get("projectId");
            azName = this.getCreateCGProdAZ(pg, pairInfoList, regionUuid, projUuid);
        } else if ("hypermetro".equals(this.getReplicaModel(pg)) && pg.getTemplate().getType() == 34) {
            regionUuid = (String)pgProps.get("regionId");
            projUuid = (String)pgProps.get("projectId");
            azName = (String)pgProps.get("zoneName");
        } else if ("hypermetro".equals(this.getReplicaModel(pg)) && pg.getTemplate().getType() == 37) {
            regionUuid = (String)pgProps.get("regionId");
            projUuid = (String)pgProps.get("projectId");
            azName = (String)pgProps.get("prod_region_drZoneName");
        } else {
            regionUuid = (String)pgProps.get("drRegionId");
            projUuid = (String)pgProps.get("drProjectId");
            azName = (String)pgProps.get("drZoneName");
        }
        logger.debug((Object)("start create replicationCG:replicaIdStr=" + replicaIdStr + "isMaster=" + isMaster + ", protectGroup name=" + pg.getName()));
        VolReplicaCgCreateInfo cgCreateInfo = new VolReplicaCgCreateInfo();
        cgCreateInfo.setName(pg.getName());
        cgCreateInfo.setAzName(azName);
        cgCreateInfo.setMasterFlag(isMaster);
        cgCreateInfo.setReplicaModel(this.getReplicaModel(pg));
        cgCreateInfo.setReplications(replicaIdStr);
        VolumeReplicationCgInfo cgInfo = this.volumeService.createReplicaCG(cgCreateInfo, regionUuid, projUuid);
        logger.info((Object)("create replicationCG sucessfully.replicationCGId=" + cgInfo.getId() + ",isMaster=" + isMaster + ",protectGroup name=" + pg.getName()));
        logger.debug((Object)("create replicationCG sucessfully.replicationCG info=" + cgInfo + ",isMaster=" + isMaster + ",protectGroup name=" + pg.getName()));
        return cgInfo;
    }

    private String getCreateCGProdAZ(ProtectGroup pg, List<PoReplicaPairInfo> pairInfoList, String regionUuid, String projUuid) {
        String azName = "";
        if (!"hypermetro".equals(this.getReplicaModel(pg)) && pg.getTemplate().getType() == 37 && !VerifyUtil.isEmpty(pairInfoList)) {
            DrExtendManager drMgr = new DrExtendManager();
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            VolumeReplicationInfo repliaInfo = drMgr.queryVolumeReplication(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(pairInfoList.get(0).getReplicaUuid()));
            if (null == repliaInfo) {
                logger.error((Object)("getCreateCGProdAZ failed.the replica is not exist:replicaId=" + pairInfoList.get(0).getReplicaUuid()));
                throw new LegoCheckedException(1073948407L);
            }
            if (repliaInfo.getReplicationStatus().equals(OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue())) {
                azName = (String)pg.getProps().get("prod_region_drZoneName");
            }
        } else {
            azName = (String)pg.getProps().get("zoneName");
        }
        return azName;
    }

    protected Map<String, OpenStackVolume> getUuidVolMap(ProtectGroup pg) {
        HashMap<String, OpenStackVolume> uuidVolMap = new HashMap<String, OpenStackVolume>();
        ArrayList<String> volUuidList = new ArrayList<String>();
        for (ProtectObject po : pg.getPolist()) {
            JSONArray volConfigArray = JSONArray.fromObject(po.getProps().get("volumeConfig"));
            for (int i = 0; i < volConfigArray.size(); ++i) {
                JSONObject volJson = volConfigArray.getJSONObject(i);
                String volUuid = volJson.getString("volumeId");
                volUuidList.add(volUuid);
            }
        }
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        List volList = this.volumeService.queryVolumesByUuid(regionUuid, projUuid, volUuidList, false);
        for (OpenStackVolume vol : volList) {
            uuidVolMap.put(vol.getUuid(), vol);
        }
        return uuidVolMap;
    }

    public abstract String getReplicaModel(ProtectGroup var1);

    public abstract int getProtectType();

    public Set<ProtectGroupReplica> beforeDeleteProtectGroup(ProtectGroup protectGroup) {
        return null;
    }

    protected final Set<ProtectObject> getWillAddPoSet(ProtectGroup pg) {
        HashSet<ProtectObject> addPoSet = new HashSet<ProtectObject>();
        ProtectGroup dbPg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(pg.getUuid(), false);
        Set dbPoList = dbPg.getPolist();
        for (ProtectObject po : pg.getPolist()) {
            if (dbPoList.contains(po)) continue;
            addPoSet.add(po);
        }
        if (!VerifyUtil.isEmpty((String)((String)pg.getProps().get("BEFORE_UPGRADE_TYPE")))) {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().evict((Object)dbPg);
        } else {
            SessionFactory factory = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory();
            SessionUtil.clearSessionCache((Session)factory.getCurrentSession(), (ProtectGroup)dbPg);
        }
        return addPoSet;
    }

    public static boolean checkCreateResult(List<CreateReplicationTaskResult> createResultList, Map<String, PoReplicaPairInfo> pairInfoMap) {
        if (VerifyUtil.isEmpty(createResultList)) {
            return false;
        }
        boolean flag = true;
        for (CreateReplicationTaskResult result : createResultList) {
            pairInfoMap.put(result.getPairInfo().getVolumeUuid(), result.getPairInfo());
            if (!result.isResultFlag()) {
                logger.error((Object)("checkCreateResult:volumeUUID check Replication failed, volumeUUID = " + result.getPairInfo().getVolumeUuid()));
                flag = false;
                continue;
            }
            logger.info((Object)("checkCreateResult:volumeUUID check Replication succeed, volumeUUID = " + result.getPairInfo().getVolumeUuid() + ",pairInfo=" + result.getPairInfo().toString()));
        }
        return flag;
    }

    public static void rollBackupVhaCsdr(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, String replicationSide, Map<String, PoReplicaInfo> poDRReplicaInfoMap, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, int operationType) {
        boolean existActiveReplicationInfo = OpenStackCommonUtil.checkExistPoReplication(poReplicaInfoMap);
        boolean existHyperMetorReplicationInfo = OpenStackCommonUtil.checkExistPoReplication(poHyperMetroReplicaInfoMap);
        boolean existStandbyReplicationInfo = OpenStackCommonUtil.checkExistPoReplication(poDRReplicaInfoMap);
        PoReplicaInfo rollbackStandbypoReplicaInfo = null;
        PoReplicaInfo rollbackHyperMetorepoReplicaInfo = null;
        Map<String, PoReplicaInfo> loopPoReplicaMap = poReplicaInfoMap;
        boolean isExChange = false;
        if (!VerifyUtil.isEmpty((Collection)pg.getReplicaList()) && VerifyUtil.isEmpty((String)((String)pg.getProps().get("BEFORE_UPGRADE_TYPE"))) && (isExChange = OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(OpenStackCommonUtil.getRealTimeCGReplicaStatus(pg)))) {
            loopPoReplicaMap = poHyperMetroReplicaInfoMap;
        }
        JSONObject json = new JSONObject();
        for (PoReplicaInfo rollbackPoReplicaInfo : loopPoReplicaMap.values()) {
            PoReplicaInfo rollbackActivepoReplicaInfo;
            List pairInfoList = rollbackPoReplicaInfo.getPairInfos();
            if (VerifyUtil.isEmpty((Collection)pairInfoList)) continue;
            if (existStandbyReplicationInfo) {
                rollbackActivepoReplicaInfo = OpenStackBasicUtil.getSameVmUUIDPoReplication(rollbackPoReplicaInfo, poReplicaInfoMap);
                rollbackHyperMetorepoReplicaInfo = OpenStackBasicUtil.getSameVmUUIDPoReplication(rollbackPoReplicaInfo, poHyperMetroReplicaInfoMap);
                rollbackStandbypoReplicaInfo = OpenStackBasicUtil.getSameVmUUIDPoReplication(rollbackPoReplicaInfo, poDRReplicaInfoMap);
                if (!isExChange) {
                    json.put((Object)"replicationInfo", (Object)JSONObject.fromObject((Object)rollbackActivepoReplicaInfo));
                }
                json.put((Object)"remote_replicationInfo", (Object)JSONObject.fromObject((Object)rollbackStandbypoReplicaInfo));
                json.put((Object)"hypermetor_replicationInfo", (Object)JSONObject.fromObject((Object)rollbackHyperMetorepoReplicaInfo));
            } else if (existHyperMetorReplicationInfo) {
                rollbackHyperMetorepoReplicaInfo = OpenStackBasicUtil.getSameVmUUIDPoReplication(rollbackPoReplicaInfo, poHyperMetroReplicaInfoMap);
                rollbackActivepoReplicaInfo = OpenStackBasicUtil.getSameVmUUIDPoReplication(rollbackPoReplicaInfo, poReplicaInfoMap);
                if (!isExChange) {
                    json.put((Object)"replicationInfo", (Object)JSONObject.fromObject((Object)rollbackActivepoReplicaInfo));
                }
                json.put((Object)"hypermetor_replicationInfo", (Object)JSONObject.fromObject((Object)rollbackHyperMetorepoReplicaInfo));
            } else if (existActiveReplicationInfo) {
                rollbackActivepoReplicaInfo = OpenStackBasicUtil.getSameVmUUIDPoReplication(rollbackPoReplicaInfo, poReplicaInfoMap);
                json.put((Object)"replicationInfo", (Object)JSONObject.fromObject((Object)rollbackActivepoReplicaInfo));
                if (isExChange) {
                    rollbackHyperMetorepoReplicaInfo = OpenStackBasicUtil.getSameVmUUIDPoReplication(rollbackPoReplicaInfo, poHyperMetroReplicaInfoMap);
                    rollbackStandbypoReplicaInfo = OpenStackBasicUtil.getSameVmUUIDPoReplication(rollbackPoReplicaInfo, poDRReplicaInfoMap);
                    json.put((Object)"remote_replicationInfo", (Object)JSONObject.fromObject((Object)rollbackStandbypoReplicaInfo));
                    json.put((Object)"hypermetor_replicationInfo", (Object)JSONObject.fromObject((Object)rollbackHyperMetorepoReplicaInfo));
                }
            } else {
                logger.info((Object)("rollback vm name=" + pg.getName() + ", do have replication, protectGroup name=" + pg.getName()));
                return;
            }
            ArrayReplicationReplicaBuilder.addServerJSON(pg, replicationSide, operationType, json);
            PoReplicaInfo poReplicaInfo = isExChange ? rollbackHyperMetorepoReplicaInfo : rollbackActivepoReplicaInfo;
            logger.info((Object)("submit rollback task, rollback vm name=" + poReplicaInfo.getVmName() + ",activepoReplicaInfo=" + rollbackActivepoReplicaInfo + ",standbypoReplicaInfo=" + rollbackStandbypoReplicaInfo + ",hyperMetorepoReplicaInfo=" + rollbackHyperMetorepoReplicaInfo + ",protectGroup name=" + pg.getName()));
            RollBackTaskInfo taskInfo = OpenStackCommonUtil.getRollBackTask(poReplicaInfo, json);
            RollBackTaskManager.getInstance().addTask(taskInfo, true);
        }
    }

    private static void addServerJSON(ProtectGroup pg, String replicationSide, int operationType, JSONObject json) {
        if (!VerifyUtil.isEmpty((Collection)pg.getReplicaList()) && VerifyUtil.isEmpty((String)((String)pg.getProps().get("BEFORE_UPGRADE_TYPE")))) {
            json.put((Object)"template", (Object)pg.getTemplate().getType());
            json.pick(pg.getProps(), new String[]{"projectId", "drProjectId", "regionId", "drRegionId"});
        }
        if (!VerifyUtil.isEmpty((String)((String)pg.getProps().get("BEFORE_UPGRADE_TYPE")))) {
            json.put((Object)"BEFORE_UPGRADE_TYPE", pg.getProps().get("BEFORE_UPGRADE_TYPE"));
        }
        json.put((Object)"operationType", (Object)operationType);
        json.put((Object)"rollbackupside", (Object)replicationSide);
        json.pick(pg.getProps(), new String[]{"prodRingID", "standbyDRRingUuid", "hyperDRRingID", "serviceInstanceType"});
        if (!VerifyUtil.isEmpty((String)((String)pg.getProps().get("BEFORE_UPGRADE_TYPE")))) {
            json.put((Object)"SERVICEINSTANCE_UUID", pg.getProps().get("SERVICEINSTANCE_UUID"));
        }
    }

    public void reattach(List<Callable<PoReplicaInfo>> reattachTaskList, int batchNum, int timeout) {
        List reattachResultList;
        if (VerifyUtil.isEmpty(reattachTaskList)) {
            logger.info((Object)"reattachTaskList is empty");
            return;
        }
        int calculateTimeOut = OpenStackCommonUtil.calculateTaskTimeOut(reattachTaskList);
        if (calculateTimeOut > timeout) {
            timeout = calculateTimeOut;
        }
        if (VerifyUtil.isEmpty((Collection)(reattachResultList = ExecutionService.batchSubmit(reattachTaskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)timeout, (int)batchNum))) || reattachResultList.size() != reattachTaskList.size()) {
            logger.error((Object)("reattach volume failed:result size=" + reattachResultList.size() + " ,task size" + reattachTaskList.size()));
            throw new LegoCheckedException(1073948106L);
        }
    }

    protected List<CreateReplicationTaskResult> generateCreateReplicationTaskListForRing(List<Callable<CreateReplicationTaskResult>> taskList, ProtectGroup pg) {
        if ("hypermetro".equals(this.getReplicaModel(pg)) && (pg.getTemplate().getType() == 34 || pg.getTemplate().getType() == 37)) {
            return this.genCreateHyperPairTaskResults(taskList, pg);
        }
        int batchNum = OpenStackCommonUtil.getNumFromResource("replication.oper.task.batch.num", 20);
        int timeout = OpenStackCommonUtil.getNumFromResource("replication.oper.task.timeout", 1800);
        logger.info((Object)("configuration of task batch num=" + batchNum + ", timeout=" + timeout + ", taskList size=" + taskList.size() + ", protectGroup name=" + pg.getName()));
        List createResultList = ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)timeout, (int)batchNum);
        return createResultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CreateReplicationTaskResult> genCreateHyperPairTaskResults(List<Callable<CreateReplicationTaskResult>> taskList, ProtectGroup pg) {
        Object object = CREATE_HYPERMETRE_PAIAR_LOCK;
        synchronized (object) {
            int batchNum = 1;
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                batchNum = (int)LegoConfig.getInstance().getNumber("batch.create.hyperpair.size", 4L);
            }
            int timeout = OpenStackCommonUtil.getNumFromResource("replication.oper.task.timeout", 1800);
            logger.info((Object)("configuration of task batch num=" + batchNum + " timeout=" + timeout + " taskList size=" + taskList.size() + ", protectGroup name=" + pg.getName()));
            return ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)timeout, (int)batchNum);
        }
    }

    private JSONObject updataPoPropsVolumeConfig(ProtectGroup pg, ProtectObject po, JSONObject poVolCfgJson) {
        for (ProtectObject obj : pg.getPolist()) {
            if (po.getUuid().equals(obj.getUuid())) continue;
            String objVolCfgStr = (String)obj.getProps().get("volumeConfig");
            JSONArray objVolCfgArray = JSONArray.fromObject((Object)objVolCfgStr);
            JSONObject objVolCfgJson = this.getShareVolumeJsonObj(objVolCfgArray, poVolCfgJson);
            return objVolCfgJson;
        }
        return poVolCfgJson;
    }

    private JSONObject getShareVolumeJsonObj(JSONArray objVolCfgArray, JSONObject poVolCfgJson) {
        String poVolumeUuid = (String)poVolCfgJson.get("volumeId");
        int size = objVolCfgArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject objVolCfgJson = objVolCfgArray.getJSONObject(i);
            String volumeUuid = (String)objVolCfgJson.get("volumeId");
            if (!poVolumeUuid.equals(volumeUuid) || VerifyUtil.isEmpty((Object)objVolCfgJson.get("drVolumeType")) || VerifyUtil.isEmpty((Object)objVolCfgJson.get("drHyperVolumeType"))) continue;
            logger.debug((Object)("share volume volumeUuid is " + poVolumeUuid + "get drVolumeType and drHyperVolumeType "));
            return objVolCfgJson;
        }
        logger.debug((Object)("share volume volumeUuid is " + poVolumeUuid + " don't get drVolumeType and drHyperVolumeType "));
        return poVolCfgJson;
    }
}

