/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.replica.builder;

import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.replica.builder.ArrayReplicationReplicaBuilder;
import com.huawei.ism.drm.openstack.protection.replica.builder.HyperMetroReplicationReplicaBuilder;
import com.huawei.ism.drm.openstack.protection.service.ConfigPhVmTask;
import com.huawei.ism.drm.openstack.protection.service.CreateRingTask;
import com.huawei.ism.drm.openstack.protection.service.CreateRingTaskResult;
import com.huawei.ism.drm.openstack.protection.service.ReattachVolumeTask;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolume;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;

public class VhaAsyncArrayReplicationReplicaBuilder
extends ArrayReplicationReplicaBuilder {
    private static Log logger = LogFactory.getInstance(VhaAsyncArrayReplicationReplicaBuilder.class);
    private HyperMetroReplicationReplicaBuilder hypermetroreplicationreplicabuilder = new HyperMetroReplicationReplicaBuilder();

    @Override
    public void buildReplica(ProtectGroup pg) {
        if (this.isCreateInstance(pg)) {
            this.createInstance(pg);
            return;
        }
        if (this.isAddServer(pg)) {
            this.addServerToInstance(pg);
            return;
        }
        if (this.isUpgrade(pg)) {
            this.upGradeInstance(pg);
            return;
        }
    }

    private void createInstance(ProtectGroup pg) {
        HashMap<String, PoReplicaInfo> poReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        HashMap<String, PoReplicaInfo> poHyperMetroReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        HashMap<String, PoReplicaPairInfo> newHyperMetroCreatePairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, PoReplicaInfo> poDRReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        Map<String, OpenStackVolume> uuidVolMap = this.getUuidVolMap(pg);
        HashMap<String, String> drVolTypeMap = new HashMap<String, String>();
        HashMap<String, String> drHyperMetroVolTypeMap = new HashMap<String, String>();
        HashMap<String, String> drRemoteHyperMetroVolTypeMap = new HashMap<String, String>();
        HashMap<String, List<ProtectObject>> needProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unNeedProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, PoReplicaPairInfo> protectedPairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, List<ProtectObject>> protectedVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unprotectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        try {
            logger.info((Object)("start to create protectgroup replica:pgName=" + pg.getName()));
            this.checkVolume(pg, drVolTypeMap, drHyperMetroVolTypeMap);
            this.getPairInfoMap(pg, protectedPairInfoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
            if (!this.checkVolumeStatus(pg, protectedPairInfoMap)) {
                logger.error((Object)("check pg protectedPairInfoMap volume status fail : " + pg.getName()));
                throw new LegoCheckedException(1073948416L);
            }
            this.getAddedPoVolumeInfoMap(pg, protectedPairInfoMap, needProtectVolUuidPoMap, unNeedProtectVolUuidPoMap);
            logger.info((Object)("First:creating vha_csdr/csha_csdr:create master replication,protectGroup name=" + pg.getName() + ", source volume uuids:" + uuidVolMap.keySet().toString() + ", dr volume ids:" + drVolTypeMap.keySet().toString() + ",dr volume types" + drVolTypeMap.values() + ",replicationmode:" + this.getReplicaModel(pg) + ",protectGroup name=" + pg.getName()));
            pg.getProps().put("replicationModel", "async");
            Map<String, PoReplicaPairInfo> newCreatePairInfoMap = this.protectVolumes(pg, uuidVolMap, drVolTypeMap, poReplicaInfoMap, needProtectVolUuidPoMap);
            pg.getProps().put("replicationModel", "hypermetro");
            Map<String, PoReplicaPairInfo> newCreateVolUuidToPairMap = this.protectVolumesForRing(pg, uuidVolMap, drHyperMetroVolTypeMap, poHyperMetroReplicaInfoMap, needProtectVolUuidPoMap, null);
            newHyperMetroCreatePairInfoMap.putAll(newCreateVolUuidToPairMap);
            this.saveHyperCGID(pg, poHyperMetroReplicaInfoMap);
            Set addPoSet = pg.getPolist();
            this.afterCreatePairForHyperMetro(pg, poHyperMetroReplicaInfoMap, addPoSet);
            logger.info((Object)("Second:creating vha_csdr/csha_csdr:create master hypereplication,protectGroup name=" + pg.getName() + ", source volume uuids:" + uuidVolMap.keySet().toString() + ", dr volume ids:" + drVolTypeMap.keySet().toString() + ",dr volume types" + drVolTypeMap.values() + ",replicationmode:" + this.getReplicaModel(pg) + ",protectGroup name=" + pg.getName()));
            pg.getProps().put("replicationModel", "async");
            HashMap<String, String> drSUUIDToDrVolumeUUIDMap = new HashMap<String, String>();
            ArrayList<String> drRemoteHyperMetroVolUUID = new ArrayList<String>();
            this.getUsefulMapping(newHyperMetroCreatePairInfoMap, drRemoteHyperMetroVolUUID, drSUUIDToDrVolumeUUIDMap, drVolTypeMap, drRemoteHyperMetroVolTypeMap);
            Map<String, OpenStackVolume> drUUIDVolume = this.getUuidVolMap(pg, drRemoteHyperMetroVolUUID);
            HashMap<String, String> drHyperUUIDTDrUUID = new HashMap<String, String>();
            HashMap<String, String> drDRUUIDToHyperMetroUUID = new HashMap<String, String>();
            HashMap<String, List<ProtectObject>> needProtectDrVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
            HashMap<String, VolumeInfo> drHyperUUIDTDrVolumeInfo = new HashMap<String, VolumeInfo>();
            this.getDrHyperUuidToDrVolumeInfoMap(newCreatePairInfoMap, drHyperUUIDTDrUUID, drSUUIDToDrVolumeUUIDMap, needProtectVolUuidPoMap, needProtectDrVolUuidPoMap, drDRUUIDToHyperMetroUUID);
            String drProjUuid = (String)pg.getProps().get("drProjectId");
            String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
            String drRegionId = (String)pg.getProps().get("drRegionId");
            this.initHyperMetroUUIDToVolume(drHyperUUIDTDrUUID, drDRUUIDToHyperMetroUUID, drHyperUUIDTDrVolumeInfo, drProjUuid, tokenId, drRegionId);
            logger.info((Object)("Third:creating vha_csdr:create standby replication,protectGroup name=" + pg.getName() + ", source volume uuids:" + drUUIDVolume.keySet().toString() + ", dr volume ids:" + drRemoteHyperMetroVolTypeMap.keySet().toString() + ",dr volume types" + drRemoteHyperMetroVolTypeMap.values() + ",replicationmode:" + this.getReplicaModel(pg) + ",protectGroup name=" + pg.getName()));
            this.protectVolumesForRing(pg, drUUIDVolume, drRemoteHyperMetroVolTypeMap, poDRReplicaInfoMap, needProtectDrVolUuidPoMap, drHyperUUIDTDrVolumeInfo);
            this.saveStandbyCGID(pg, poDRReplicaInfoMap);
            this.saveRemotePhInfo(poReplicaInfoMap, poDRReplicaInfoMap);
            this.createRingAndConfigPhVM(pg, poReplicaInfoMap, poHyperMetroReplicaInfoMap, poDRReplicaInfoMap, null, null);
        }
        catch (LegoCheckedException e) {
            this.mergeAndRollBack(poReplicaInfoMap, poDRReplicaInfoMap, poHyperMetroReplicaInfoMap, pg, protectedPairInfoMap);
            logger.error((Object)("build replica failed:protectGroup name=" + pg.getName()));
            throw e;
        }
        catch (Exception e) {
            this.mergeAndRollBack(poReplicaInfoMap, poDRReplicaInfoMap, poHyperMetroReplicaInfoMap, pg, protectedPairInfoMap);
            logger.error((Object)("build replica failed:protectGroup name=" + pg.getName()));
            ExceptionUtil.rethrowException((Throwable)e, (String)"build replica failed", (long)0x300001L, (String[])new String[0], (Log)logger);
        }
        this.updateProp(pg, poReplicaInfoMap, uuidVolMap, drVolTypeMap, drHyperMetroVolTypeMap);
        this.updatePoPropForRing(pg, poHyperMetroReplicaInfoMap, uuidVolMap, poDRReplicaInfoMap);
        this.updateUnprotectVolumePoPropsInfo(pg);
        this.makePgReplica(pg);
        pg.getProps().remove("replicationModel");
        logger.info((Object)("build vha_csdr/csha_csdr replica succeed.protectGroup name=" + pg.getName()));
    }

    private void addServerToInstance(ProtectGroup pg) {
        HashMap<String, PoReplicaInfo> poReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        HashMap<String, PoReplicaPairInfo> newCreatePairInfoMap = new HashMap();
        HashMap<String, PoReplicaInfo> poHyperMetroReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        HashMap<String, PoReplicaPairInfo> newHyperMetroCreatePairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, PoReplicaInfo> poDRReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        Map<String, OpenStackVolume> uuidVolMap = this.getUuidVolMap(pg);
        HashMap<String, String> drVolTypeMap = new HashMap<String, String>();
        HashMap<String, String> drHyperMetroVolTypeMap = new HashMap<String, String>();
        HashMap<String, String> drRemoteHyperMetroVolTypeMap = new HashMap<String, String>();
        HashMap<String, List<ProtectObject>> needProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unNeedProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, PoReplicaPairInfo> protectedPairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, List<ProtectObject>> protectedVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unprotectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, PoReplicaPairInfo> hyperMetroProtectedPairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, PoReplicaPairInfo> remoteProtectedPairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        try {
            Map<String, PoReplicaPairInfo> newVolUuidToCreatePairMap;
            logger.info((Object)("start to add protectgroup to instance:pgName=" + pg.getName()));
            this.checkVolume(pg, drVolTypeMap, drHyperMetroVolTypeMap);
            this.getPairInfoMap(pg, protectedPairInfoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
            if (!this.checkVolumeStatus(pg, protectedPairInfoMap)) {
                logger.error((Object)("check pg protectedPairInfoMap volume status fail : " + pg.getName()));
                throw new LegoCheckedException(1073948416L);
            }
            this.getHyperMetroPairMap(pg, hyperMetroProtectedPairInfoMap, remoteProtectedPairInfoMap);
            this.getAddedPoVolumeInfoMap(pg, protectedPairInfoMap, needProtectVolUuidPoMap, unNeedProtectVolUuidPoMap);
            String replicaStatus = this.getActiveSideReplicaStatus(pg);
            if (!OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(replicaStatus)) {
                logger.info((Object)("First:add protectgroup to instance:create master replication,protectGroup name=" + pg.getName() + ", source volume uuids:" + uuidVolMap.keySet().toString() + ", dr volume ids:" + drVolTypeMap.keySet().toString() + ",dr volume types" + drVolTypeMap.values() + ",replicationmode:" + this.getReplicaModel(pg) + ",protectGroup name=" + pg.getName()));
                pg.getProps().put("replicationModel", "async");
                newCreatePairInfoMap = this.protectVolumes(pg, uuidVolMap, drVolTypeMap, poReplicaInfoMap, needProtectVolUuidPoMap);
                this.dealShareVolume(pg, poReplicaInfoMap, newCreatePairInfoMap, protectedPairInfoMap, "replicationInfo", unNeedProtectVolUuidPoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
            }
            pg.getProps().put("replicationModel", "hypermetro");
            Map<String, PoReplicaPairInfo> newCreateVolUuidToPairMap = this.protectVolumesForRing(pg, uuidVolMap, drHyperMetroVolTypeMap, poHyperMetroReplicaInfoMap, needProtectVolUuidPoMap, null);
            newHyperMetroCreatePairInfoMap.putAll(newCreateVolUuidToPairMap);
            this.saveHyperCGID(pg, poHyperMetroReplicaInfoMap);
            this.dealShareVolume(pg, poHyperMetroReplicaInfoMap, newHyperMetroCreatePairInfoMap, hyperMetroProtectedPairInfoMap, "hypermetor_replicationInfo", unNeedProtectVolUuidPoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
            Set<ProtectObject> addPoSet = this.getWillAddPoSet(pg);
            this.afterCreatePairForHyperMetro(pg, poHyperMetroReplicaInfoMap, addPoSet);
            pg.getProps().put("replicationModel", "async");
            HashMap<String, String> drSUUIDToDrVolumeUUIDMap = new HashMap<String, String>();
            ArrayList<String> drRemoteHyperMetroVolUUID = new ArrayList<String>();
            this.getUsefulMapping(newHyperMetroCreatePairInfoMap, drRemoteHyperMetroVolUUID, drSUUIDToDrVolumeUUIDMap, drVolTypeMap, drRemoteHyperMetroVolTypeMap);
            Map<String, OpenStackVolume> drUUIDVolume = this.getUuidVolMap(pg, drRemoteHyperMetroVolUUID);
            HashMap<String, String> drHyperUUIDTDrUUID = new HashMap<String, String>();
            HashMap<String, String> drDRUUIDToHyperMetroUUID = new HashMap<String, String>();
            HashMap<String, List<ProtectObject>> needProtectDrVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
            HashMap<String, VolumeInfo> drHyperUUIDTDrVolumeInfo = new HashMap<String, VolumeInfo>();
            this.getDrHyperUuidToDrVolumeInfoMap(newCreatePairInfoMap, drHyperUUIDTDrUUID, drSUUIDToDrVolumeUUIDMap, needProtectVolUuidPoMap, needProtectDrVolUuidPoMap, drDRUUIDToHyperMetroUUID);
            String drProjUuid = (String)pg.getProps().get("drProjectId");
            String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
            String drRegionId = (String)pg.getProps().get("drRegionId");
            this.initHyperMetroUUIDToVolume(drHyperUUIDTDrUUID, drDRUUIDToHyperMetroUUID, drHyperUUIDTDrVolumeInfo, drProjUuid, tokenId, drRegionId);
            this.initHyperMetroUUIDToProtectObject(newHyperMetroCreatePairInfoMap, needProtectVolUuidPoMap, replicaStatus, needProtectDrVolUuidPoMap);
            logger.info((Object)("Third:add protectgroup to instance:create standby replication,protectGroup name=" + pg.getName() + ", source volume uuids:" + drUUIDVolume.keySet().toString() + ", dr volume ids:" + drRemoteHyperMetroVolTypeMap.keySet().toString() + ",dr volume types" + drRemoteHyperMetroVolTypeMap.values() + ",replicationmode:" + this.getReplicaModel(pg) + ",protectGroup name=" + pg.getName()));
            String replicaKey = null;
            if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(replicaStatus)) {
                newVolUuidToCreatePairMap = this.protectVolumesForRing(pg, drUUIDVolume, drRemoteHyperMetroVolTypeMap, poDRReplicaInfoMap, needProtectDrVolUuidPoMap, null);
                replicaKey = "replicationInfo";
            } else {
                newVolUuidToCreatePairMap = this.protectVolumesForRing(pg, drUUIDVolume, drRemoteHyperMetroVolTypeMap, poDRReplicaInfoMap, needProtectDrVolUuidPoMap, drHyperUUIDTDrVolumeInfo);
                replicaKey = "remote_replicationInfo";
            }
            this.dealShareVolume(pg, poDRReplicaInfoMap, newVolUuidToCreatePairMap, remoteProtectedPairInfoMap, replicaKey, unNeedProtectVolUuidPoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
            this.saveRemotePhInfo(poReplicaInfoMap, poDRReplicaInfoMap);
            if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(replicaStatus)) {
                HashMap<String, VolumeInfo> srcUuidToRemoteVolume = new HashMap<String, VolumeInfo>();
                this.getSrcUuidToRemoteVolumeMap(newHyperMetroCreatePairInfoMap, newVolUuidToCreatePairMap, pg, srcUuidToRemoteVolume, tokenId, drProjUuid);
                newCreatePairInfoMap = this.protectVolumesForRing(pg, uuidVolMap, drVolTypeMap, poReplicaInfoMap, needProtectVolUuidPoMap, srcUuidToRemoteVolume);
                this.dealShareVolume(pg, poReplicaInfoMap, newCreatePairInfoMap, protectedPairInfoMap, "remote_replicationInfo", unNeedProtectVolUuidPoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
                this.saveRemotePhInfo(poReplicaInfoMap, poDRReplicaInfoMap);
            }
            this.createRingAndConfigPhVM(pg, poReplicaInfoMap, poHyperMetroReplicaInfoMap, poDRReplicaInfoMap, replicaStatus, null);
        }
        catch (LegoCheckedException e) {
            this.mergeAndRollBack(poReplicaInfoMap, poDRReplicaInfoMap, poHyperMetroReplicaInfoMap, pg, protectedPairInfoMap);
            logger.error((Object)("build replica failed:protectGroup name=" + pg.getName()));
            throw e;
        }
        catch (Exception e) {
            this.mergeAndRollBack(poReplicaInfoMap, poDRReplicaInfoMap, poHyperMetroReplicaInfoMap, pg, protectedPairInfoMap);
            logger.error((Object)("build replica failed:protectGroup name=" + pg.getName()));
            ExceptionUtil.rethrowException((Throwable)e, (String)"build replica failed", (long)0x300001L, (String[])new String[0], (Log)logger);
        }
        this.updateProp(pg, poReplicaInfoMap, uuidVolMap, drVolTypeMap, drHyperMetroVolTypeMap);
        this.updatePoPropForRing(pg, poHyperMetroReplicaInfoMap, uuidVolMap, poDRReplicaInfoMap);
        this.updateUnprotectVolumePoPropsInfo(pg);
        this.makePgReplica(pg);
        pg.getProps().remove("replicationModel");
        logger.info((Object)("build vha_csdr replica succeed.protectGroup name=" + pg.getName()));
    }

    private void upGradeInstance(ProtectGroup pg) {
        HashMap<String, PoReplicaInfo> poReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        Map<String, PoReplicaPairInfo> newCreatePairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, PoReplicaInfo> poHyperMetroReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        HashMap<String, PoReplicaPairInfo> newHyperMetroCreatePairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, PoReplicaInfo> poDRReplicaInfoMap = new HashMap<String, PoReplicaInfo>();
        Map<String, OpenStackVolume> uuidVolMap = this.getUuidVolMap(pg);
        HashMap<String, String> drVolTypeMap = new HashMap<String, String>();
        HashMap<String, String> drHyperMetroVolTypeMap = new HashMap<String, String>();
        HashMap<String, String> drRemoteHyperMetroVolTypeMap = new HashMap<String, String>();
        HashMap<String, List<ProtectObject>> needProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unNeedProtectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, PoReplicaPairInfo> protectedPairInfoMap = new HashMap<String, PoReplicaPairInfo>();
        HashMap<String, List<ProtectObject>> protectedVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        HashMap<String, List<ProtectObject>> unprotectVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
        try {
            logger.info((Object)("start to update protectgroup replica:pgName=" + pg.getName()));
            this.checkVolume(pg, drVolTypeMap, drHyperMetroVolTypeMap);
            this.getPairInfoMap(pg, protectedPairInfoMap, protectedVolUuidPoMap, unprotectVolUuidPoMap);
            if (!this.checkVolumeStatus(pg, protectedPairInfoMap)) {
                logger.error((Object)("check pg protectedPairInfoMap volume status fail : " + pg.getName()));
                throw new LegoCheckedException(1073948416L);
            }
            this.getAddedPoVolumeInfoMap(pg, protectedPairInfoMap, needProtectVolUuidPoMap, unNeedProtectVolUuidPoMap);
            String upgradeType = (String)pg.getProps().get("BEFORE_UPGRADE_TYPE");
            if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(upgradeType)) {
                this.updatePoReplicaInfoMap(pg, poReplicaInfoMap, newCreatePairInfoMap);
            } else {
                pg.getProps().put("replicationModel", "async");
                logger.info((Object)("First:upgrading vha_csdr:create master replication,protectGroup name=" + pg.getName() + ", source volume uuids:" + uuidVolMap.keySet().toString() + ", dr volume ids:" + drVolTypeMap.keySet().toString() + ",dr volume types" + drVolTypeMap.values() + ",replicationmode:" + this.getReplicaModel(pg) + ",protectGroup name=" + pg.getName()));
                newCreatePairInfoMap = this.protectVolumes(pg, uuidVolMap, drVolTypeMap, poReplicaInfoMap, needProtectVolUuidPoMap);
            }
            this.createHyperMetroReplication(pg, poHyperMetroReplicaInfoMap, newHyperMetroCreatePairInfoMap, uuidVolMap, drHyperMetroVolTypeMap, needProtectVolUuidPoMap);
            Set addPoSet = pg.getPolist();
            this.afterCreatePairForHyperMetro(pg, poHyperMetroReplicaInfoMap, addPoSet);
            logger.info((Object)("Second:upgrade vha_csdr:create master hypereplication,protectGroup name=" + pg.getName() + ", source volume uuids:" + uuidVolMap.keySet().toString() + ", dr volume ids:" + drVolTypeMap.keySet().toString() + ",dr volume types" + drVolTypeMap.values() + ",replicationmode:" + this.getReplicaModel(pg) + ",protectGroup name=" + pg.getName()));
            pg.getProps().put("replicationModel", "async");
            HashMap<String, String> drSUUIDToDrVolumeUUIDMap = new HashMap<String, String>();
            ArrayList<String> drRemoteHyperMetroVolUUID = new ArrayList<String>();
            this.getUsefulMapping(newHyperMetroCreatePairInfoMap, drRemoteHyperMetroVolUUID, drSUUIDToDrVolumeUUIDMap, drVolTypeMap, drRemoteHyperMetroVolTypeMap);
            Map<String, OpenStackVolume> drUUIDVolume = this.getUuidVolMap(pg, drRemoteHyperMetroVolUUID);
            HashMap<String, String> drHyperUUIDTDrUUID = new HashMap<String, String>();
            HashMap<String, String> drDRUUIDToHyperMetroUUID = new HashMap<String, String>();
            HashMap<String, List<ProtectObject>> needProtectDrVolUuidPoMap = new HashMap<String, List<ProtectObject>>();
            HashMap<String, VolumeInfo> drHyperUUIDTDrVolumeInfo = new HashMap<String, VolumeInfo>();
            this.getDrHyperUuidToDrVolumeInfoMap(newCreatePairInfoMap, drHyperUUIDTDrUUID, drSUUIDToDrVolumeUUIDMap, needProtectVolUuidPoMap, needProtectDrVolUuidPoMap, drDRUUIDToHyperMetroUUID);
            String drProjUuid = (String)pg.getProps().get("drProjectId");
            String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
            String drRegionId = (String)pg.getProps().get("drRegionId");
            this.initHyperMetroUUIDToVolume(drHyperUUIDTDrUUID, drDRUUIDToHyperMetroUUID, drHyperUUIDTDrVolumeInfo, drProjUuid, tokenId, drRegionId);
            logger.info((Object)("Third:upgrading vha_csdr:create standby replication,protectGroup name=" + pg.getName() + ", source volume uuids:" + drUUIDVolume.keySet().toString() + ", dr volume ids:" + drRemoteHyperMetroVolTypeMap.keySet().toString() + ",dr volume types" + drRemoteHyperMetroVolTypeMap.values() + ",replicationmode:" + this.getReplicaModel(pg) + ",protectGroup name=" + pg.getName()));
            this.protectVolumesForRing(pg, drUUIDVolume, drRemoteHyperMetroVolTypeMap, poDRReplicaInfoMap, needProtectDrVolUuidPoMap, drHyperUUIDTDrVolumeInfo);
            this.saveStandbyCGID(pg, poDRReplicaInfoMap);
            this.saveRemotePhInfo(poReplicaInfoMap, poDRReplicaInfoMap);
            this.createRingAndConfigPhVM(pg, poReplicaInfoMap, poHyperMetroReplicaInfoMap, poDRReplicaInfoMap, null, upgradeType);
        }
        catch (LegoCheckedException e) {
            this.mergeAndRollBack(poReplicaInfoMap, poDRReplicaInfoMap, poHyperMetroReplicaInfoMap, pg, protectedPairInfoMap);
            logger.error((Object)("build replica failed:protectGroup name=" + pg.getName()));
            throw e;
        }
        catch (Exception e) {
            this.mergeAndRollBack(poReplicaInfoMap, poDRReplicaInfoMap, poHyperMetroReplicaInfoMap, pg, protectedPairInfoMap);
            logger.error((Object)("build replica failed:protectGroup name=" + pg.getName()));
            ExceptionUtil.rethrowException((Throwable)e, (String)"build replica failed", (long)0x300001L, (String[])new String[0], (Log)logger);
        }
        this.updateProp(pg, poReplicaInfoMap, uuidVolMap, drVolTypeMap, drHyperMetroVolTypeMap);
        this.updatePoPropForRing(pg, poHyperMetroReplicaInfoMap, uuidVolMap, poDRReplicaInfoMap);
        this.updateUnprotectVolumePoPropsInfo(pg);
        this.makePgReplica(pg);
        pg.getProps().remove("replicationModel");
        logger.info((Object)("build vha_csdr replica succeed.protectGroup name=" + pg.getName()));
    }

    private boolean isAddServer(ProtectGroup pg) {
        return !VerifyUtil.isEmpty((Collection)pg.getReplicaList()) && VerifyUtil.isEmpty((String)((String)pg.getProps().get("BEFORE_UPGRADE_TYPE")));
    }

    private boolean isCreateInstance(ProtectGroup pg) {
        return VerifyUtil.isEmpty((Collection)pg.getReplicaList());
    }

    private boolean isUpgrade(ProtectGroup pg) {
        return !VerifyUtil.isEmpty((String)((String)pg.getProps().get("BEFORE_UPGRADE_TYPE")));
    }

    protected void saveHyperCGID(ProtectGroup pg, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap) {
        for (PoReplicaInfo poReplicaInfo : poHyperMetroReplicaInfoMap.values()) {
            pg.getProps().put("hyperProCgUuid", poReplicaInfo.getCgUuid());
            pg.getProps().put("hyperProdrCgUuid", poReplicaInfo.getDrCgUuid());
        }
    }

    protected void dealShareVolume(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, PoReplicaPairInfo> newCreatePairInfoMap, Map<String, PoReplicaPairInfo> protectedPairInfoMap, String replicaKey, Map<String, List<ProtectObject>> ... items) {
        Map<String, List<ProtectObject>> unNeedProtectVolUuidPoMap = items[0];
        Map<String, List<ProtectObject>> protectedVolUuidPoMap = items[1];
        Map<String, List<ProtectObject>> unprotectVolUuidPoMap = items[2];
        this.dealUnNeedProtectVolume(pg, unNeedProtectVolUuidPoMap, protectedPairInfoMap, protectedVolUuidPoMap, poReplicaInfoMap);
        this.dealUnProtectedVolume(unprotectVolUuidPoMap, newCreatePairInfoMap, replicaKey);
    }

    protected void initHyperMetroUUIDToProtectObject(Map<String, PoReplicaPairInfo> newHyperMetroCreatePairInfoMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap, String replicaStatus, Map<String, List<ProtectObject>> needProtectDrVolUuidPoMap) {
        if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(replicaStatus)) {
            for (PoReplicaPairInfo pairInfo : newHyperMetroCreatePairInfoMap.values()) {
                needProtectDrVolUuidPoMap.put(pairInfo.getDrVolumeUuid(), needProtectVolUuidPoMap.get(pairInfo.getVolumeUuid()));
            }
        }
    }

    protected void initHyperMetroUUIDToVolume(Map<String, String> drHyperUUIDTDrUUID, Map<String, String> drDRUUIDToHyperMetroUUID, Map<String, VolumeInfo> drHyperUUIDTDrVolumeInfo, String drProjUuid, String tokenId, String drRegionId) {
        CinderManager cinderMgr = new CinderManager();
        for (String drVolumeUUID : drHyperUUIDTDrUUID.values()) {
            VolumeInfo volInfo = cinderMgr.queryVolume(drRegionId, tokenId, drProjUuid, OpenStackCommonUtil.getIdFromUuid(drVolumeUUID));
            drHyperUUIDTDrVolumeInfo.put(drDRUUIDToHyperMetroUUID.get(drVolumeUUID), volInfo);
        }
    }

    protected void createRingAndConfigPhVM(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, Map<String, PoReplicaInfo> poDRReplicaInfoMap, String replicaStatus, String upgradeType) {
        if (this.isNeedCreateRing(pg, upgradeType)) {
            this.createRing(pg, poReplicaInfoMap, poHyperMetroReplicaInfoMap, poDRReplicaInfoMap);
        }
        if (!ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(upgradeType) && !OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(replicaStatus)) {
            logger.info((Object)("Last:after config phvm ,protectGroup name=" + pg.getName()));
            this.afterCreatePair(pg, poReplicaInfoMap);
        }
        if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue().equals(replicaStatus)) {
            logger.info((Object)("Last:after config phvm ,protectGroup name=" + pg.getName()));
            this.afterCreatePair(pg, poReplicaInfoMap);
        }
        this.saveRemotePhInfo(poReplicaInfoMap, poDRReplicaInfoMap);
        if (37 == pg.getTemplate().getType()) {
            this.updateStandbyReplicationProdVM(poHyperMetroReplicaInfoMap, poDRReplicaInfoMap);
        }
    }

    protected void updateStandbyReplicationProdVM(Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, Map<String, PoReplicaInfo> poDRReplicaInfoMap) {
        for (Map.Entry<String, PoReplicaInfo> entry : poHyperMetroReplicaInfoMap.entrySet()) {
            poDRReplicaInfoMap.get(entry.getKey()).setMoUuid(poHyperMetroReplicaInfoMap.get(entry.getKey()).getPhVmInfo().getVmUuid());
            poDRReplicaInfoMap.get(entry.getKey()).setVmName(poHyperMetroReplicaInfoMap.get(entry.getKey()).getPhVmInfo().getName());
        }
    }

    protected void saveStandbyCGID(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap) {
        for (PoReplicaInfo poReplicaInfo : poReplicaInfoMap.values()) {
            pg.getProps().put("hyperProRemoteCgUuid", poReplicaInfo.getCgUuid());
            pg.getProps().put("hyperProRemotedrCgUuid", poReplicaInfo.getDrCgUuid());
        }
    }

    protected void getHyperMetroPairMap(ProtectGroup pg, Map<String, PoReplicaPairInfo> hyperMetroProtectedPairInfoMap, Map<String, PoReplicaPairInfo> remoteProtectedPairInfoMap) {
        logger.debug((Object)("enter getHyperMetroPairMap pgname=" + pg.getName()));
        HashMap<String, String> hyperUuidToSrcUuid = new HashMap<String, String>();
        for (ProtectObject po : pg.getPolist()) {
            PoReplicaInfo replicaInfo;
            String replicaInfoStr = (String)po.getProps().get("hypermetor_replicationInfo");
            if (VerifyUtil.isEmpty((String)replicaInfoStr) || null == (replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class))) continue;
            for (PoReplicaPairInfo pairInfo : replicaInfo.getPairInfos()) {
                String volumeUuid = pairInfo.getVolumeUuid();
                hyperUuidToSrcUuid.put(pairInfo.getDrVolumeUuid(), volumeUuid);
                if (OpenstackEnumDefine.VOL_PROTECT_STATUS_E.UNPROTECTED.getStatus().equals(pairInfo.getVolumeStatus()) || hyperMetroProtectedPairInfoMap.keySet().contains(volumeUuid)) continue;
                hyperMetroProtectedPairInfoMap.put(volumeUuid, pairInfo);
            }
            PoReplicaInfo remoteReplicaInfo = (PoReplicaInfo)po.getProperty("remote_replicationInfo", PoReplicaInfo.class);
            if (null == remoteReplicaInfo) continue;
            for (PoReplicaPairInfo pairInfo : remoteReplicaInfo.getPairInfos()) {
                String hyperVolumeUuid = pairInfo.getVolumeUuid();
                String volumeUuid = (String)hyperUuidToSrcUuid.get(hyperVolumeUuid);
                if (OpenstackEnumDefine.VOL_PROTECT_STATUS_E.UNPROTECTED.getStatus().equals(pairInfo.getVolumeStatus()) || remoteProtectedPairInfoMap.keySet().contains(volumeUuid)) continue;
                remoteProtectedPairInfoMap.put(volumeUuid, pairInfo);
            }
        }
        logger.info((Object)("hyperMetroProtectedPairInfoMap:" + hyperMetroProtectedPairInfoMap));
        logger.info((Object)("remoteProtectedPairInfoMap:" + remoteProtectedPairInfoMap));
    }

    protected void getSrcUuidToRemoteVolumeMap(Map<String, PoReplicaPairInfo> newHyperMetroCreatePairInfoMap, Map<String, PoReplicaPairInfo> newVolUuidToCreatePairMap, ProtectGroup pg, Map<String, VolumeInfo> srcUuidToRemoteVolume, String tokenId, String drProjUuid) {
        HashMap<String, String> srcUudiToHyperUuid = new HashMap<String, String>();
        for (PoReplicaPairInfo poReplicaPairInfo : newHyperMetroCreatePairInfoMap.values()) {
            srcUudiToHyperUuid.put(poReplicaPairInfo.getVolumeUuid(), poReplicaPairInfo.getDrVolumeUuid());
        }
        HashMap<String, String> hyperUuidToRemoteUuid = new HashMap<String, String>();
        for (PoReplicaPairInfo tempPoReplicaPairInfo : newVolUuidToCreatePairMap.values()) {
            hyperUuidToRemoteUuid.put(tempPoReplicaPairInfo.getVolumeUuid(), tempPoReplicaPairInfo.getDrVolumeUuid());
        }
        String string = (String)pg.getProps().get("drRegionId");
        CinderManager cinderMgr = new CinderManager();
        for (Map.Entry entry : srcUudiToHyperUuid.entrySet()) {
            String srcUuid = (String)entry.getKey();
            String hyperUuid = (String)entry.getValue();
            String remoteUuid = (String)hyperUuidToRemoteUuid.get(hyperUuid);
            VolumeInfo remoteVol = cinderMgr.queryVolume(string, tokenId, drProjUuid, OpenStackCommonUtil.getIdFromUuid(remoteUuid));
            srcUuidToRemoteVolume.put(srcUuid, remoteVol);
        }
    }

    protected void getDrHyperUuidToDrVolumeInfoMap(Map<String, PoReplicaPairInfo> newCreatePairInfoMap, Map<String, String> drHyperUUIDTDrUUID, Map<String, String> drSUUIDToDrVolumeUUIDMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap, Map<String, List<ProtectObject>> needProtectDrVolUuidPoMap, Map<String, String> drDRUUIDToHyperMetroUUID) {
        for (PoReplicaPairInfo tempPoReplicaPairInfo : newCreatePairInfoMap.values()) {
            drHyperUUIDTDrUUID.put(drSUUIDToDrVolumeUUIDMap.get(tempPoReplicaPairInfo.getVolumeUuid()), tempPoReplicaPairInfo.getDrVolumeUuid());
            needProtectDrVolUuidPoMap.put(drSUUIDToDrVolumeUUIDMap.get(tempPoReplicaPairInfo.getVolumeUuid()), needProtectVolUuidPoMap.get(tempPoReplicaPairInfo.getVolumeUuid()));
            drDRUUIDToHyperMetroUUID.put(tempPoReplicaPairInfo.getDrVolumeUuid(), drSUUIDToDrVolumeUUIDMap.get(tempPoReplicaPairInfo.getVolumeUuid()));
        }
    }

    protected void getUsefulMapping(Map<String, PoReplicaPairInfo> newHyperMetroCreatePairInfoMap, List<String> drRemoteHyperMetroVolUUID, Map<String, String> drSUUIDToDrVolumeUUIDMap, Map<String, String> drVolTypeMap, Map<String, String> drRemoteHyperMetroVolTypeMap) {
        for (PoReplicaPairInfo tempPoReplicaPairInfo : newHyperMetroCreatePairInfoMap.values()) {
            drRemoteHyperMetroVolUUID.add(tempPoReplicaPairInfo.getDrVolumeUuid());
            drSUUIDToDrVolumeUUIDMap.put(tempPoReplicaPairInfo.getVolumeUuid(), tempPoReplicaPairInfo.getDrVolumeUuid());
            if (drVolTypeMap.get(tempPoReplicaPairInfo.getVolumeUuid()) != null) {
                drRemoteHyperMetroVolTypeMap.put(tempPoReplicaPairInfo.getDrVolumeUuid(), drVolTypeMap.get(tempPoReplicaPairInfo.getVolumeUuid()));
                continue;
            }
            logger.error((Object)("drvoltype is null, VolumeUuid=" + tempPoReplicaPairInfo.getVolumeUuid() + " , drVolTypes=" + drVolTypeMap.values()));
        }
    }

    protected void createHyperMetroReplication(ProtectGroup pg, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, Map<String, PoReplicaPairInfo> newHyperMetroCreatePairInfoMap, Map<String, OpenStackVolume> uuidVolMap, Map<String, String> drHyperMetroVolTypeMap, Map<String, List<ProtectObject>> needProtectVolUuidPoMap) {
        String upgradeType = (String)pg.getProps().get("BEFORE_UPGRADE_TYPE");
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(upgradeType)) {
            this.updatePoReplicaInfoMap(pg, poHyperMetroReplicaInfoMap, newHyperMetroCreatePairInfoMap);
        } else {
            pg.getProps().put("replicationModel", "hypermetro");
            Map<String, PoReplicaPairInfo> newCreateVolUuidToPairMap = this.protectVolumesForRing(pg, uuidVolMap, drHyperMetroVolTypeMap, poHyperMetroReplicaInfoMap, needProtectVolUuidPoMap, null);
            newHyperMetroCreatePairInfoMap.putAll(newCreateVolUuidToPairMap);
        }
        this.saveHyperCGID(pg, poHyperMetroReplicaInfoMap);
    }

    protected String getActiveSideReplicaStatus(ProtectGroup pg) {
        if ((34 == pg.getTemplate().getType() || 37 == pg.getTemplate().getType()) && !VerifyUtil.isEmpty((Collection)pg.getReplicaList()) && VerifyUtil.isEmpty((String)((String)pg.getProps().get("BEFORE_UPGRADE_TYPE")))) {
            String replicaStatus = OpenStackCommonUtil.getRealTimeCGReplicaStatus(pg);
            ArrayList<String> allowRepStatus = new ArrayList<String>();
            allowRepStatus.add(OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue());
            allowRepStatus.add(OpenstackEnumDefine.REPLICATION_REP_STATUS_E.COPYING.getValue());
            allowRepStatus.add(OpenstackEnumDefine.REPLICATION_REP_STATUS_E.STANDBY.getValue());
            if (!allowRepStatus.contains(replicaStatus)) {
                logger.error((Object)("add volume first cg replication error: replication status:" + replicaStatus + ", protectGroup name= " + pg.getName()));
                throw new LegoCheckedException(1073948462L);
            }
            logger.info((Object)("add po  query repica status:" + replicaStatus + ", protectGroup name= " + pg.getName()));
            return replicaStatus;
        }
        return null;
    }

    protected boolean isNeedCreateRing(ProtectGroup pg, String upgradeType) {
        return VerifyUtil.isEmpty((Collection)pg.getReplicaList()) || !VerifyUtil.isEmpty((String)upgradeType);
    }

    protected void checkVolume(ProtectGroup pg, Map<String, String> drVolTypeMap, Map<String, String> drHyperMetroVolTypeMap) {
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Collection)pg.getPolist())) {
            logger.error((Object)("pg or polist is empty , protectGroup name=" + pg.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.checkDrVolTypeExist(pg, drVolTypeMap, drHyperMetroVolTypeMap)) {
            logger.error((Object)("drvoltype is empty,pgName=" + pg.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        logger.debug((Object)("drVolTypeMap:" + drVolTypeMap + "; drHyperMetroVolTypeMap:" + drHyperMetroVolTypeMap));
    }

    protected void updatePoReplicaInfoMap(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, PoReplicaPairInfo> newCreatePairInfoMap) {
        for (ProtectObject po : pg.getPolist()) {
            if (poReplicaInfoMap.containsKey(po.getUuid())) continue;
            String replicaInfoStr = (String)po.getProps().get("replicationInfo");
            PoReplicaInfo replicaInfo = JsonUtil.jsonToBean(replicaInfoStr, PoReplicaInfo.class);
            if (null == replicaInfo) {
                logger.error((Object)"convert json failed:");
                continue;
            }
            poReplicaInfoMap.put(po.getUuid(), replicaInfo);
            ArrayList<PoReplicaPairInfo> protectedPairInfos = new ArrayList<PoReplicaPairInfo>();
            for (PoReplicaPairInfo info : replicaInfo.getPairInfos()) {
                if (OpenstackEnumDefine.VOL_PROTECT_STATUS_E.UNPROTECTED.getStatus().equals(info.getVolumeStatus())) {
                    logger.info((Object)("volume " + info.getVolumeUuid() + " is unprotected."));
                    continue;
                }
                protectedPairInfos.add(info);
                newCreatePairInfoMap.put(info.getVolumeUuid(), info);
            }
            replicaInfo.setPairInfos(protectedPairInfos);
        }
    }

    protected void mergeAndRollBack(Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, PoReplicaInfo> poDRReplicaInfoMap, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, ProtectGroup pg, Map<String, PoReplicaPairInfo> protectedPairInfoMap) {
        String beforeUpgradeType;
        boolean isUpgrade;
        if (this.isAddServer(pg)) {
            this.filterSharePoReplicaPairInfo(protectedPairInfoMap, poReplicaInfoMap, poHyperMetroReplicaInfoMap, poDRReplicaInfoMap);
        }
        boolean bl = isUpgrade = !VerifyUtil.isEmpty((String)(beforeUpgradeType = (String)pg.getProps().get("BEFORE_UPGRADE_TYPE")));
        if (!isUpgrade || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue().equals(beforeUpgradeType)) {
            this.mergeShareVolume(poReplicaInfoMap);
        }
        this.mergeShareVolume(poDRReplicaInfoMap);
        if (!isUpgrade || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.getValue().equals(beforeUpgradeType)) {
            this.mergeShareVolume(poHyperMetroReplicaInfoMap);
        }
        this.startRollback(pg, poReplicaInfoMap, "hypermetorside", poDRReplicaInfoMap, poHyperMetroReplicaInfoMap);
    }

    protected void filterSharePoReplicaPairInfo(Map<String, PoReplicaPairInfo> protectedPairInfoMap, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, Map<String, PoReplicaInfo> poDRReplicaInfoMap) {
        for (String volUuid : protectedPairInfoMap.keySet()) {
            PoReplicaPairInfo pairInfo;
            Iterator iter;
            for (PoReplicaInfo poReplicaInfo : poReplicaInfoMap.values()) {
                Iterator iter2 = poReplicaInfo.getPairInfos().iterator();
                while (iter2.hasNext()) {
                    PoReplicaPairInfo pairInfo2 = (PoReplicaPairInfo)iter2.next();
                    if (!Objects.equals(pairInfo2.getVolumeUuid(), volUuid)) continue;
                    iter2.remove();
                }
            }
            HashMap<String, String> hyperUuidToSrcUuid = new HashMap<String, String>();
            for (PoReplicaInfo poReplicaInfo : poHyperMetroReplicaInfoMap.values()) {
                iter = poReplicaInfo.getPairInfos().iterator();
                while (iter.hasNext()) {
                    pairInfo = (PoReplicaPairInfo)iter.next();
                    hyperUuidToSrcUuid.put(pairInfo.getDrVolumeUuid(), pairInfo.getVolumeUuid());
                    if (!Objects.equals(pairInfo.getVolumeUuid(), volUuid)) continue;
                    iter.remove();
                }
            }
            for (PoReplicaInfo poReplicaInfo : poDRReplicaInfoMap.values()) {
                iter = poReplicaInfo.getPairInfos().iterator();
                while (iter.hasNext()) {
                    pairInfo = (PoReplicaPairInfo)iter.next();
                    String srcUuid = (String)hyperUuidToSrcUuid.get(pairInfo.getVolumeUuid());
                    if (!Objects.equals(srcUuid, volUuid)) continue;
                    iter.remove();
                }
            }
        }
    }

    protected void saveRemotePhInfo(Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, PoReplicaInfo> poDRReplicaInfoMap) {
        for (Map.Entry<String, PoReplicaInfo> entry : poReplicaInfoMap.entrySet()) {
            poDRReplicaInfoMap.get(entry.getKey()).setPhVmInfo(poReplicaInfoMap.get(entry.getKey()).getPhVmInfo());
        }
    }

    protected void createRing(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, Map<String, PoReplicaInfo> poDRReplicaInfoMap) {
        if (VerifyUtil.isEmpty(poReplicaInfoMap) && VerifyUtil.isEmpty(poHyperMetroReplicaInfoMap) && VerifyUtil.isEmpty(poDRReplicaInfoMap)) {
            return;
        }
        ArrayList<Callable<CreateRingTaskResult>> taskList = new ArrayList<Callable<CreateRingTaskResult>>();
        CreateRingTask createAtivetask = new CreateRingTask(this.getVolumeService(), pg, poReplicaInfoMap, "ring_active");
        taskList.add(createAtivetask);
        List<CreateRingTaskResult> createResultList = this.generateCreateRingTaskList(taskList);
        boolean result = VhaAsyncArrayReplicationReplicaBuilder.checkCreateRingResult(createResultList);
        if (!result) {
            logger.error((Object)("create active ring failed, protectGroup name=" + pg.getName()));
            throw new LegoCheckedException(1073948140L);
        }
        taskList.clear();
        CreateRingTask createHyperMetrotask = new CreateRingTask(this.getVolumeService(), pg, poHyperMetroReplicaInfoMap, "ring_hypermetor");
        taskList.add(createHyperMetrotask);
        CreateRingTask createStandbyMetortask = new CreateRingTask(this.getVolumeService(), pg, poDRReplicaInfoMap, "ring_standby");
        taskList.add(createStandbyMetortask);
        createResultList = this.generateCreateRingTaskList(taskList);
        result = VhaAsyncArrayReplicationReplicaBuilder.checkCreateRingResult(createResultList);
        if (!result) {
            logger.error((Object)("create hyperMetor and standby ring failed, protectGroup name=" + pg.getName()));
            throw new LegoCheckedException(1073948140L);
        }
    }

    protected List<CreateRingTaskResult> generateCreateRingTaskList(List<Callable<CreateRingTaskResult>> taskList) {
        int batchNum = OpenStackCommonUtil.getNumFromResource("replication.oper.task.batch.num", 20);
        int timeout = OpenStackCommonUtil.getNumFromResource("replication.oper.task.timeout", 1800);
        logger.info((Object)("configuration of createRing Task task batch num=" + batchNum + " timeout=" + timeout + " taskList size=" + taskList.size()));
        List createResultList = ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)timeout, (int)batchNum);
        return createResultList;
    }

    public static boolean checkCreateRingResult(List<CreateRingTaskResult> createResultList) {
        if (VerifyUtil.isEmpty(createResultList)) {
            logger.debug((Object)"enter checkCreateRingResult,createResultList is empty. ");
            return false;
        }
        boolean flag = true;
        for (CreateRingTaskResult result : createResultList) {
            if (result.isResultFlag()) continue;
            flag = false;
            break;
        }
        return flag;
    }

    protected Map<String, OpenStackVolume> getUuidVolMap(ProtectGroup pg, List<String> volUUIDList) {
        HashMap<String, OpenStackVolume> uuidVolMap = new HashMap<String, OpenStackVolume>();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        List volList = this.getVolumeService().queryVolumesByUuid(regionUuid, projUuid, volUUIDList, false);
        for (OpenStackVolume vol : volList) {
            uuidVolMap.put(vol.getUuid(), vol);
        }
        return uuidVolMap;
    }

    protected void afterCreatePairForHyperMetro(ProtectGroup pg, Map<String, PoReplicaInfo> poHyperMetroReplicaInfoMap, Set<ProtectObject> addPoSet) {
        ArrayList<Callable<PoReplicaInfo>> reattachTaskList = new ArrayList<Callable<PoReplicaInfo>>();
        ArrayList createVmTaskList = new ArrayList();
        for (ProtectObject po : addPoSet) {
            String poUuid = po.getUuid();
            PoReplicaInfo replicaInfo = poHyperMetroReplicaInfoMap.get(poUuid);
            if (VerifyUtil.isEmpty((Object)replicaInfo)) {
                logger.error((Object)("After create hypermetro pair, reattach volume can't find protectObject replicationInfo,protectObject uuid=" + poUuid + ", protectGroup name=" + pg.getName()));
                continue;
            }
            ReattachVolumeTask task = new ReattachVolumeTask(replicaInfo);
            task.setIsHyperMetro(true);
            reattachTaskList.add(task);
            if (this.getType() != 37) continue;
            super.addTagToVm(replicaInfo);
            this.hypermetroreplicationreplicabuilder.addTagToVm(replicaInfo, "__type_csha");
            if (!OpenStackCommonUtil.isCurrentFCVersionHighThan63()) continue;
            String phvmId = (String)po.getProps().get("csha_occupied_vm");
            if (VerifyUtil.isEmpty((String)phvmId)) {
                logger.error((Object)("can't set phvmId, uuid=" + poUuid));
                continue;
            }
            createVmTaskList.add(new ConfigPhVmTask(replicaInfo, phvmId, ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.getValue(), pg.getName()));
        }
        int batchNum = OpenStackCommonUtil.getNumFromResource("replication.oper.task.batch.num", 20);
        int timeout = OpenStackCommonUtil.getNumFromResource("replication.oper.task.timeout", 1800);
        super.reattach(reattachTaskList, batchNum, timeout);
        if (VerifyUtil.isEmpty(createVmTaskList)) {
            logger.info((Object)"createVmTaskList is empty");
            return;
        }
        OpenStackCommonUtil.executeTask(createVmTaskList, ExecutionService.ExecuteType.FAILED_ABORT, true);
    }

    protected void updateProp(ProtectGroup pg, Map<String, PoReplicaInfo> poReplicaInfoMap, Map<String, OpenStackVolume> uuidVolMap, Map<String, String> drVolTypeMap, Map<String, String> drHyperMetroVolTypeMap) {
        String aSrcVolTypeName = ((OpenStackVolume)CommonUtil.getFirstElement(uuidVolMap.values())).getVolType();
        String aDrVolTypeName = (String)CommonUtil.getFirstElement(drVolTypeMap.values());
        String aHyperMetroDrVolTypeName = (String)CommonUtil.getFirstElement(drHyperMetroVolTypeMap.values());
        this.updatePgProp(pg, aSrcVolTypeName, aDrVolTypeName, aHyperMetroDrVolTypeName);
        this.updatePoProp(pg, poReplicaInfoMap, uuidVolMap);
    }

    public int getType() {
        return 34;
    }

    @Override
    public String getReplicaModel(ProtectGroup protectGroup) {
        String replicationMode = (String)protectGroup.getProps().get("replicationModel");
        logger.info((Object)("vhaAsyn replication builder get replicationmode=" + replicationMode + ", protectGroup name=" + protectGroup.getName()));
        return replicationMode;
    }

    @Override
    public int getProtectType() {
        return 2;
    }
}

