/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Map;
import java.util.concurrent.Callable;

public class ConfigVMMetaTask
implements Callable<Boolean> {
    private static Log logger = LogFactory.getInstance(ConfigVMMetaTask.class);
    private String vmUuid;
    private String regionUuid;
    private String projectUuid;
    private String openstackUuid;
    private Map<String, String> metadata;
    private String protectGroupName;

    public ConfigVMMetaTask(String openstackUuid, String vmUuid, String projectUuid, String regionUuid, Map<String, String> metadata, String protectGroupName) {
        this.openstackUuid = openstackUuid;
        this.vmUuid = vmUuid;
        this.projectUuid = projectUuid;
        this.regionUuid = regionUuid;
        this.metadata = metadata;
        this.protectGroupName = protectGroupName;
    }

    @Override
    public Boolean call() {
        INovaManager novaManager = ManagerFactory.getInstance().getNovaManager(this.openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(this.projectUuid);
        try {
            novaManager.updateVMmetadata(this.vmUuid, this.projectUuid, this.regionUuid, tokenId, this.metadata);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("protectGroup name=" + this.protectGroupName + ", config vm metadata error,vmUuid=" + this.vmUuid), (Throwable)e);
        }
        return true;
    }
}

