/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeAttachmentInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.concurrent.Callable;

public class DelPlaceHoldVMTask
implements Callable<PhVmInfo> {
    private static Log logger = LogFactory.getInstance(DelPlaceHoldVMTask.class);
    private ProtectGroup pg;
    private ProtectObject po;
    private final PhVmInfo vm;
    private boolean needDelete;

    public DelPlaceHoldVMTask(PhVmInfo vm, ProtectGroup pg, ProtectObject po, boolean needDelete) {
        this.pg = pg;
        this.po = po;
        this.vm = vm;
        this.needDelete = needDelete;
    }

    @Override
    public PhVmInfo call() {
        OpenStackVM phvm;
        String tokenId;
        boolean attachBootVolume;
        String openstackUuid = this.pg.getPoProviderSN();
        String drProjId = (String)this.pg.getProps().get("drProjectId");
        String drRegionId = (String)this.pg.getProps().get("drRegionId");
        String splitFlag = (String)this.pg.getProps().get("PG_PROP_REPLICATION_SPLIT_KEY");
        String instanceType = (String)this.pg.getProps().get("serviceInstanceType");
        INovaManager novaManager = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        boolean bl = attachBootVolume = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.isCurrent(instanceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.isCurrent(instanceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.isCurrent(instanceType);
        if (attachBootVolume) {
            this.attachPrdBootVol(novaManager, this.pg, this.po);
            try {
                if (!this.needDelete) {
                    tokenId = TokenUtil.getInstance().getTokenId(drProjId);
                    phvm = novaManager.getVm(drRegionId, tokenId, drProjId, this.vm.getVmUuid(), new int[0]);
                    if (null != phvm && !OpenStackCommonUtil.isBareMetalServer(phvm)) {
                        this.attachPhBootVolume(drProjId, drRegionId, novaManager, tokenId, phvm);
                    } else if (null == phvm) {
                        this.unreserveVolumeForPhVMNotExist(drRegionId, drProjId);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("attachPhBootVol failed. vmID=" + this.po.getMoUuid() + ", protectGroup name=" + this.pg.getName()));
            }
        }
        if (Boolean.toString(true).equals(splitFlag)) {
            logger.info((Object)("Do not delelte placeHold VMTask.Because splitFlag(Force delete)=" + splitFlag + ", ProtectGroup name=" + this.pg.getName()));
            return this.vm;
        }
        tokenId = TokenUtil.getInstance().getTokenId(drProjId);
        try {
            phvm = novaManager.getVm(drRegionId, tokenId, drProjId, this.vm.getVmUuid(), new int[0]);
            if (null == phvm) {
                logger.info((Object)("Delelte placeHold VMTask.Because splitFlag(Force delete)=" + splitFlag + ", ProtectGroup name=" + this.pg.getName()));
                return this.vm;
            }
            if (!OpenStackCommonUtil.isBareMetalServer(phvm)) {
                AsyncTaskResponse response = novaManager.unlockVm(drRegionId, tokenId, drProjId, this.vm.getVmUuid());
                if (!response.isSuccess()) {
                    logger.error((Object)("Unlock placeHold VMTask failed.Vmuuid=" + this.vm.getVmUuid() + ", protectGroup name=" + this.pg.getName()));
                    throw new LegoCheckedException(response.getErrorCode());
                }
                if (this.needDelete && !(response = novaManager.deleteVm(drRegionId, drProjId, tokenId, this.vm.getVmUuid())).isSuccess()) {
                    logger.error((Object)("Delete placeHold VMTask failed.Vmuuid=" + this.vm.getVmUuid() + ", protectGroup name=" + this.pg.getName()));
                    throw new LegoCheckedException(response.getErrorCode());
                }
            }
        }
        catch (LegoCheckedException e) {
            if (201L == e.getErrorCode()) {
                logger.info((Object)("Delete placeHold VMTask success. vm " + this.vm.getVmUuid() + "has no exist., protectGroup name=" + this.pg.getName()));
            } else {
                logger.error((Object)("Delete placeHold VMTask failed. vmID=" + this.vm.getVmUuid() + ", protectGroup name=" + this.pg.getName()));
                ExceptionUtil.rethrowException((Throwable)e, (String)"task execute failed:", (long)1073948412L, (String[])new String[0], (Log)logger);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Delete placeHold VMTask failed. vmID=" + this.vm.getVmUuid() + ", protectGroup name=" + this.pg.getName()));
            ExceptionUtil.rethrowException((Throwable)e, (String)"task execute failed:", (long)1073948412L, (String[])new String[0], (Log)logger);
        }
        return this.vm;
    }

    private void attachPhBootVolume(String drProjId, String drRegionId, INovaManager novaManager, String tokenId, OpenStackVM phvm) {
        if (null == this.po) {
            logger.warn((Object)("po is null.Vmuuid=" + this.vm.getVmUuid() + ", protectGroup name=" + this.pg.getName()));
            return;
        }
        String replicationInfo = (String)this.po.getProperty("replicationInfo", String.class);
        if (null == replicationInfo) {
            logger.warn((Object)("replicationInfo is null.Vmuuid=" + this.vm.getVmUuid() + ", protectGroup name=" + this.pg.getName()));
            return;
        }
        PoReplicaInfo poReplicaInfo = JsonUtil.jsonToBean(replicationInfo, PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            logger.warn((Object)("poReplicaInfo is null.Vmuuid=" + this.vm.getVmUuid() + ", protectGroup name=" + this.pg.getName()));
            return;
        }
        String srcBootVolumeUuid = (String)this.po.getProps().get("VM_BOOTABLE_VOLUME");
        for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
            if (VerifyUtil.isEmpty((String)srcBootVolumeUuid) || !srcBootVolumeUuid.equals(pairInfo.getVolumeUuid())) continue;
            String drVmUuid = this.vm.getVmUuid();
            String drVolumeUuid = pairInfo.getDrVolumeUuid();
            this.attachVolume(drProjId, drRegionId, novaManager, tokenId, phvm, drVmUuid, drVolumeUuid);
        }
    }

    private void attachVolume(String projId, String regionId, INovaManager novaManager, String tokenId, OpenStackVM openStackVm, String ... args) {
        String vmUuid = args.length > 0 ? args[0] : null;
        String volumeUuid = args.length > 1 ? args[1] : null;
        IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
        VolumeInfo volumeInfo = volService.queryVolumeInfoByUuid(regionId, projId, volumeUuid);
        if (!VerifyUtil.isEmpty((Object)volumeInfo)) {
            boolean alreadyAttach = false;
            for (VolumeAttachmentInfo attachmentInfo : volumeInfo.getAttachments()) {
                if (!attachmentInfo.getServerId().equals(vmUuid) || !OpenstackEnumDefine.VOLUME_STATUS_E.INUSE.getType().equals(volumeInfo.getStatus())) continue;
                alreadyAttach = true;
                logger.info((Object)("vol(" + volumeUuid + ") is areadly attached to vm(" + openStackVm.getName() + ")"));
            }
            if (!alreadyAttach) {
                ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).unreserveVolume(OpenStackCommonUtil.getIdFromUuid(volumeUuid), regionId, projId);
                volService.deleteVolMetadatas(regionId, projId, OpenStackCommonUtil.getIdFromUuid(volumeUuid), "occupied_volume");
                String vmType = (String)this.po.getProps().get("vm_type");
                AsyncTaskResponse attachResponse = novaManager.attachVolumeToVM(tokenId, projId, regionId, vmUuid, vmType, OpenStackCommonUtil.getIdFromUuid(volumeUuid), openStackVm.getBootDevName());
                if (attachResponse.isSuccess()) {
                    logger.info((Object)("vol(" + volumeUuid + ") success attached to vm(" + openStackVm.getName() + ")"));
                } else {
                    logger.error((Object)("vol(" + volumeUuid + ") error to attached to vm(" + openStackVm.getName() + ")"));
                }
            } else {
                logger.info((Object)("vol(" + volumeUuid + ") allready attached to vm(" + openStackVm.getName() + ")"));
            }
        } else {
            logger.warn((Object)("drVolume is null.drVolumeUuid=" + volumeUuid + ", protectGroup name=" + this.pg.getName()));
        }
    }

    private void attachPrdBootVol(INovaManager novaManager, ProtectGroup protectGroup, ProtectObject protectObject) {
        try {
            String regionUuid = (String)protectGroup.getProps().get("regionId");
            String projUuid = (String)protectGroup.getProps().get("projectId");
            String vmUuid = protectObject.getMoUuid();
            String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
            OpenStackVM openStackVM = novaManager.getVm(regionUuid, tokenId, projUuid, vmUuid, new int[0]);
            if (null == openStackVM) {
                logger.error((Object)("vm not exist:" + protectObject.getName() + ", ProtectGroup name=" + protectGroup.getName()));
                return;
            }
            String srcBootVolumeUuid = (String)protectObject.getProps().get("VM_BOOTABLE_VOLUME");
            if (!VerifyUtil.isEmpty((String)openStackVM.getVolumeAttached())) {
                List<String> attachedVol = OpenStackCommonUtil.getListFromStr(openStackVM.getVolumeAttached(), ",");
                for (String volUuid : attachedVol) {
                    if (!volUuid.equals(srcBootVolumeUuid)) continue;
                    logger.info((Object)("boot volume already attached vm:" + openStackVM.getName()));
                    return;
                }
            }
            if (!OpenStackCommonUtil.isBareMetalServer(openStackVM)) {
                AsyncTaskResponse response = novaManager.unlockVm(regionUuid, tokenId, projUuid, openStackVM.getUuid());
                if (!response.isSuccess()) {
                    logger.error((Object)("Unlock VMTask failed.Vmuuid=" + openStackVM.getUuid() + ", protectGroup name=" + protectGroup.getName()));
                    return;
                }
                this.attachVolume(projUuid, regionUuid, novaManager, tokenId, openStackVM, openStackVM.getUuid(), srcBootVolumeUuid);
            }
        }
        catch (Exception e) {
            logger.error((Object)("attachPrdBootVol failed. vmID=" + protectObject.getMoUuid() + ", protectGroup name=" + this.pg.getName()));
        }
    }

    private void unreserveVolumeForPhVMNotExist(String drRegionId, String drProjId) {
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)this.po.getProperty("replicationInfo", PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            logger.warn((Object)("poReplicaInfo is null.Vmuuid=" + this.vm.getVmUuid() + ", protectGroup name=" + this.pg.getName()));
            return;
        }
        String srcBootVolumeUuid = (String)this.po.getProps().get("VM_BOOTABLE_VOLUME");
        for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
            if (VerifyUtil.isEmpty((String)srcBootVolumeUuid) || !srcBootVolumeUuid.equals(pairInfo.getVolumeUuid())) continue;
            String drVolumeUuid = pairInfo.getDrVolumeUuid();
            ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).unreserveVolume(OpenStackCommonUtil.getIdFromUuid(drVolumeUuid), drRegionId, drProjId);
            IVolumeService volService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
            volService.deleteVolMetadatas(drRegionId, drProjId, OpenStackCommonUtil.getIdFromUuid(drVolumeUuid), "occupied_volume");
        }
    }
}

