/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.openstack.tools.model.DelTagParam;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public class DelReplicationTask
implements Callable<PoReplicaPairInfo>,
Runnable {
    public static final List<String> NO_ALLOWDELETE_STATUS = Collections.unmodifiableList(Arrays.asList(ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.MAINTAIN.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_COMPLETED.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.DISASTER_RECOVERY_FAILED.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_FAILED.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.PLANED_MIGRATION_COMPLETED.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.REPROTECT_FAILED.getValue(), ServiceInstaceEnumDefine.SERVICEINSTANCE_STATUS_E.HOT_MIGRATION_FAILED.getValue()));
    private static Log logger = LogFactory.getInstance(DelReplicationTask.class);
    private IVolumeService volumeService;
    private ProtectGroup pg;
    private final PoReplicaPairInfo pairInfo;
    private String replicationSide;
    private DelTagParam delTagParam = new DelTagParam();

    public DelReplicationTask(IVolumeService service, PoReplicaPairInfo pairInfo, ProtectGroup pg, String replicationSide) {
        this.pg = pg;
        this.volumeService = service;
        this.pairInfo = pairInfo;
        this.replicationSide = replicationSide;
    }

    @Override
    public PoReplicaPairInfo call() {
        this.run();
        return this.pairInfo;
    }

    @Override
    public void run() {
        String projId = (String)this.pg.getProps().get("projectId");
        String regionId = (String)this.pg.getProps().get("regionId");
        String drProjId = (String)this.pg.getProps().get("drProjectId");
        String drRegionId = (String)this.pg.getProps().get("drRegionId");
        boolean isHyperMetorSide = this.replicationSide != null && "hypermetorside".equals(this.replicationSide);
        boolean isReprotect = this.isReprotect(regionId);
        drProjId = isHyperMetorSide && isReprotect ? projId : drProjId;
        drRegionId = isHyperMetorSide && isReprotect ? regionId : drRegionId;
        projId = isHyperMetorSide && !isReprotect ? drProjId : projId;
        regionId = isHyperMetorSide && !isReprotect ? drRegionId : regionId;
        String splitFlag = (String)this.pg.getProps().get("PG_PROP_REPLICATION_SPLIT_KEY");
        String beforeStutas = (String)this.pg.getProps().get("before_delete_instance_status");
        logger.debug((Object)("delete replication pairInfo:" + this.pairInfo + ",prodProjectId=" + projId + ",prodRegionId=" + projId + "drProjectId=" + drProjId + ",drRegionId=" + drRegionId + ", splitFlag=" + splitFlag + ",instance Stutas=" + beforeStutas + ",isHyperMetorSide=" + isHyperMetorSide + ",isReprotect=" + isReprotect + ",protectGroup name=" + this.pg.getName()));
        if (OpenstackEnumDefine.VOL_PROTECT_STATUS_E.UNPROTECTED.getStatus().equals(this.pairInfo.getVolumeStatus())) {
            logger.info((Object)("delete replication. pairInfo:" + this.pairInfo + " is unprotectd, protectGroup name=" + this.pg.getName()));
            return;
        }
        try {
            this.deleteProdAndDrReplica(projId, regionId, drProjId, drRegionId, splitFlag);
            if (this.replicationSide != null && "standbyside".equals(this.replicationSide)) {
                logger.info((Object)("delete standby side and do not delete DR volume. replicationSide:" + this.replicationSide + ",protectGroup name=" + this.pg.getName()));
                return;
            }
            this.deleteVolumeMetadata(regionId, projId, drRegionId, drProjId);
            if (this.replicationSide != null && "activeside".equals(this.replicationSide) && !isReprotect) {
                logger.info((Object)("protectGroup haved finished reprotected.Delete active side and do not delete DR volume. replicationSide:" + this.replicationSide + ",protectGroup name=" + this.pg.getName()));
                return;
            }
            this.delVolume(drProjId, drRegionId, isHyperMetorSide, isReprotect, splitFlag, beforeStutas);
            this.tryUnreverseAllVolume(beforeStutas, regionId, projId, drRegionId, drProjId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Delete replication task execute failed,protectGroup name=" + this.pg.getName() + ", pairInfo=" + this.pairInfo));
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("Delete replication task execute failed,protectGroup name=" + this.pg.getName() + ", pairInfo=" + this.pairInfo));
            ExceptionUtil.rethrowException((Throwable)e, (String)"task execute failed:", (long)1073948412L, (String[])new String[0], (Log)logger);
        }
    }

    private void delVolume(String drProjId, String drRegionId, boolean isHyperMetorSide, boolean isReprotect, String splitFlag, String beforeStutas) {
        boolean isAllowStatus = this.checkIsAllowStatus(drProjId, drRegionId, beforeStutas);
        if (!VerifyUtil.isEmpty((String)this.pairInfo.getDrVolumeUuid()) && !Boolean.toString(true).equals(splitFlag) && isAllowStatus) {
            logger.debug((Object)("start delete disater volume.volume id=" + this.pairInfo.getDrVolumeUuid() + ",protectGroup name=" + this.pg.getName()));
            this.volumeService.delVolume(this.pairInfo.getDrVolumeUuid(), drRegionId, drProjId);
        }
        if (isHyperMetorSide && !VerifyUtil.isEmpty((String)this.pairInfo.getVolumeUuid()) && !Boolean.toString(true).equals(splitFlag) && isAllowStatus && !isReprotect) {
            VolumeInfo volumeInfo = this.volumeService.queryVolumeInfoByUuid(drRegionId, drProjId, this.pairInfo.getVolumeUuid());
            if (null != volumeInfo && !volumeInfo.isBootable()) {
                logger.debug((Object)("protectGroup type is hyperMetro_replication.start delete hyperMetro productin volume.volume id=" + this.pairInfo.getVolumeUuid() + ",protectGroup name=" + this.pg.getName()));
                this.volumeService.delVolume(this.pairInfo.getVolumeUuid(), drRegionId, drProjId);
            } else {
                logger.debug((Object)("boot volume no need delte.volume id=" + this.pairInfo.getVolumeUuid() + ",protectGroup name=" + this.pg.getName()));
            }
        }
    }

    private boolean checkIsAllowStatus(String drProjId, String drRegionId, String beforeStutas) {
        VolumeInfo volumeInfo;
        String instanceType;
        boolean isAllowStatus;
        boolean bl = isAllowStatus = !NO_ALLOWDELETE_STATUS.contains(beforeStutas);
        if (isAllowStatus && (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION.isCurrent(instanceType = (String)this.pg.getProps().get("serviceInstanceType")) || (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA_REPLICATION.isCurrent(instanceType) || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.CSHA_REPLICATION.isCurrent(instanceType)) && "activeside".equals(this.replicationSide)) && null != (volumeInfo = this.volumeService.queryVolumeInfoByUuid(drRegionId, drProjId, this.pairInfo.getDrVolumeUuid())) && volumeInfo.isBootable()) {
            logger.debug((Object)("boot volume no need delete.volume id=" + this.pairInfo.getDrVolumeUuid() + ",protectGroup name=" + this.pg.getName()));
            isAllowStatus = false;
        }
        return isAllowStatus;
    }

    private void deleteProdAndDrReplica(String projId, String regionId, String drProjId, String drRegionId, String splitFlag) {
        if (!VerifyUtil.isEmpty((String)this.pairInfo.getReplicaUuid())) {
            logger.debug((Object)("start delete production replication.replicationid=" + this.pairInfo.getReplicaUuid() + ",protectGroup name=" + this.pg.getName()));
            this.deleteReplica(projId, regionId, this.pairInfo.getReplicaUuid(), splitFlag);
        }
        if (!VerifyUtil.isEmpty((String)this.pairInfo.getDrReplicaUuid())) {
            logger.debug((Object)("start delete disaster replication.replicationid=" + this.pairInfo.getDrReplicaUuid() + ",protectGroup name=" + this.pg.getName()));
            this.deleteReplica(drProjId, drRegionId, this.pairInfo.getDrReplicaUuid(), splitFlag);
        }
    }

    private void deleteVolumeMetadata(String regionId, String projId, String drRegionId, String drProjId) {
        if (!VerifyUtil.isEmpty((String)this.pairInfo.getVolumeUuid()) && this.delTagParam.isDelPrdVol()) {
            logger.debug((Object)("start delete production volume metadata.volume id=" + this.pairInfo.getVolumeUuid() + ",protectGroup name=" + this.pg.getName()));
            this.volumeService.deleteVolMetadatas(regionId, projId, OpenStackCommonUtil.getIdFromUuid(this.pairInfo.getVolumeUuid()), "occupied_volume");
        }
        if (!VerifyUtil.isEmpty((String)this.pairInfo.getDrVolumeUuid()) && this.delTagParam.isDelPhVol()) {
            logger.debug((Object)("start delete disaster volume metadata.volume id=" + this.pairInfo.getDrVolumeUuid() + ",protectGroup name=" + this.pg.getName()));
            this.volumeService.deleteVolMetadatas(drRegionId, drProjId, OpenStackCommonUtil.getIdFromUuid(this.pairInfo.getDrVolumeUuid()), "occupied_volume");
        }
    }

    private boolean isReprotect(String regionId) {
        String originalRegionUuid = (String)this.pg.getProps().get("originalAvailableRegion");
        boolean isReprotect = false;
        if (regionId.equals(originalRegionUuid)) {
            isReprotect = true;
        }
        return isReprotect;
    }

    private void deleteReplica(String projId, String regionId, String replicaUuid, String splitFlag) {
        block2: {
            try {
                this.volumeService.delVolReplica(regionId, projId, replicaUuid, false, false);
            }
            catch (LegoCheckedException e) {
                if (Boolean.toString(true).equals(splitFlag)) break block2;
                throw e;
            }
        }
        logger.info((Object)("start single delete replication:replicaUuid=" + replicaUuid));
        this.volumeService.delVolReplica(regionId, projId, replicaUuid, true, true);
    }

    private void tryUnreverseAllVolume(String beforeStutas, String regionId, String projId, String drRegionId, String drProjId) {
        if (!NO_ALLOWDELETE_STATUS.contains(beforeStutas)) {
            return;
        }
        if (!VerifyUtil.isEmpty((String)this.pairInfo.getVolumeUuid())) {
            logger.debug((Object)("start tryUnreverseVolume volume.volume id=" + this.pairInfo.getVolumeUuid() + ",protectGroup name=" + this.pg.getName()));
            this.tryUnreverseVolume(regionId, projId, OpenStackCommonUtil.getIdFromUuid(this.pairInfo.getVolumeUuid()));
        }
        if (!VerifyUtil.isEmpty((String)this.pairInfo.getDrVolumeUuid())) {
            logger.debug((Object)("start tryUnreverseVolume volume.volume id=" + this.pairInfo.getDrVolumeUuid() + ",protectGroup name=" + this.pg.getName()));
            this.tryUnreverseVolume(drRegionId, drProjId, OpenStackCommonUtil.getIdFromUuid(this.pairInfo.getDrVolumeUuid()));
        }
    }

    private void tryUnreverseVolume(String regionId, String projId, String volumeUuid) {
        try {
            VolumeInfo volumeInfo = this.volumeService.queryVolumeInfoByUuid(regionId, projId, volumeUuid);
            if (VerifyUtil.isEmpty((Object)volumeInfo)) {
                logger.debug((Object)("no need unreverse volume:" + volumeUuid + ",protectGroup name=" + this.pg.getName()));
                return;
            }
            if (!OpenstackEnumDefine.VOLUME_STATUS_E.ATTACHING.getType().equals(volumeInfo.getStatus())) {
                logger.debug((Object)("no need unreverse volume:" + volumeUuid + ",protectGroup name=" + this.pg.getName()));
                return;
            }
            this.volumeService.unreserveVolume(OpenStackCommonUtil.getIdFromUuid(volumeUuid), regionId, projId);
            this.volumeService.deleteVolMetadatas(regionId, projId, OpenStackCommonUtil.getIdFromUuid(volumeUuid), "occupied_volume");
        }
        catch (Exception e) {
            logger.error((Object)("Error for tryUnreverseVolume volume:" + volumeUuid + ",protectGroup name=" + this.pg.getName() + " erroMsg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    public IVolumeService getVolumeService() {
        return this.volumeService;
    }

    public void setVolumeService(IVolumeService volumeService) {
        this.volumeService = volumeService;
    }

    public ProtectGroup getPg() {
        return this.pg;
    }

    public void setPg(ProtectGroup pg) {
        this.pg = pg;
    }

    public PoReplicaPairInfo getPairInfo() {
        return this.pairInfo;
    }

    public void setDelTagParam(DelTagParam delTagParam) {
        this.delTagParam = delTagParam;
    }
}

