/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.protection.service;

import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.model.ReattchParam;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.protection.service.TimeOutCalculator;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.ReconnectVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolAttachInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

public class ReattachVolumeTask
implements Callable<PoReplicaInfo>,
TimeOutCalculator {
    private static Log logger = LogFactory.getInstance(ReattachVolumeTask.class);
    private final PoReplicaInfo replicaInfo;
    private String srcVmUuid;
    private String regionUuid;
    private String projectUuid;
    private Boolean isHyperMetro = false;
    private Boolean isDisasterReMappingVols = false;
    private Boolean isAfterHyperMetroDel = false;

    public ReattachVolumeTask(PoReplicaInfo replicaInfo) {
        this.replicaInfo = replicaInfo;
        this.srcVmUuid = replicaInfo.getMoUuid();
        this.regionUuid = replicaInfo.getRegionUuid();
        this.projectUuid = replicaInfo.getProjUuid();
    }

    @Override
    public PoReplicaInfo call() {
        try {
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(this.regionUuid);
            INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
            String tokenId = TokenUtil.getInstance().getTokenId(this.projectUuid);
            IVolumeService volumeService = (IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class);
            if (OpenStackCommonUtil.isCurrentFCVersionHighThan63() && this.replicaInfo.getPairInfos().size() > 10) {
                this.concurrentReattachVol(novaMgr, tokenId, volumeService);
            } else {
                this.cascadeReattachVol(novaMgr, tokenId, volumeService);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Reattach volume failed:vmuuid=" + this.srcVmUuid + ", vm name=" + this.replicaInfo.getVmName()));
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"reattach volume failed", (long)1073948106L, (String[])new String[0], (Log)logger);
        }
        return this.replicaInfo;
    }

    private void cascadeReattachVol(INovaManager novaMgr, String tokenId, IVolumeService volumeService) {
        for (PoReplicaPairInfo pairInfo : this.replicaInfo.getPairInfos()) {
            this.reattachVol(novaMgr, tokenId, volumeService, pairInfo);
        }
    }

    private void concurrentReattachVol(INovaManager novaMgr, String tokenId, IVolumeService volumeService) {
        ArrayList<ReattachVolumeSubTask> reattachSubTaskList = new ArrayList<ReattachVolumeSubTask>();
        for (PoReplicaPairInfo pairInfo : this.replicaInfo.getPairInfos()) {
            ReattachVolumeSubTask reattachVolumeSubTask = new ReattachVolumeSubTask(novaMgr, tokenId, volumeService, pairInfo);
            reattachSubTaskList.add(reattachVolumeSubTask);
        }
        int batchNum = (int)LegoConfig.getInstance().getNumber("batch.nova.size", 10L);
        int timeout = OpenStackCommonUtil.getNumFromResource("replication.oper.task.timeout", 1800);
        logger.info((Object)"start concurrentReattachVol...");
        List reattachResultList = ExecutionService.batchSubmit(reattachSubTaskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)timeout, (int)batchNum);
        logger.info((Object)"end concurrentReattachVol...");
        if (VerifyUtil.isEmpty((Collection)reattachResultList) || reattachResultList.size() != reattachSubTaskList.size()) {
            logger.error((Object)("create vm failed:result size=" + reattachResultList.size() + " task size" + reattachSubTaskList.size()));
            throw new LegoCheckedException(1073948106L);
        }
    }

    private PoReplicaPairInfo reattachVol(INovaManager novaMgr, String tokenId, IVolumeService volumeService, PoReplicaPairInfo pairInfo) {
        String volumeUuid = pairInfo.getVolumeUuid();
        String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid);
        String volumeStatus = pairInfo.getVolumeStatus();
        if (!OpenstackEnumDefine.VOL_PROTECT_STATUS_E.PROTECTED.getStatus().equals(volumeStatus)) {
            logger.info((Object)("Reattach volume,the volume has not been protected: volumeUuid=" + volumeUuid + ", vm uuid=" + this.replicaInfo.getMoUuid() + ", vm name=" + this.replicaInfo.getVmName()));
            return pairInfo;
        }
        if (volumeService.isAttachVM(this.regionUuid, this.projectUuid, this.srcVmUuid, volumeUuid)) {
            VolAttachInfo attachInfo;
            if (this.isDisasterReMappingVols.booleanValue() && OpenStackCommonUtil.isCurrentFCVersionHighThan63() && OpenStackCommonUtil.checkHyperMetroVolPath(attachInfo = novaMgr.getVolumeAttachInfo(this.srcVmUuid, this.regionUuid, tokenId, volumeId))) {
                logger.debug((Object)("Reattach volume has HyperMetro Path, volumeUuid=" + volumeUuid + ", vm uuid=" + this.replicaInfo.getMoUuid() + ", vm name=" + this.replicaInfo.getVmName()));
                return pairInfo;
            }
            ReconnectVolumeInfo reconnVolumeInfo = new ReconnectVolumeInfo();
            reconnVolumeInfo.setVolumeId(volumeId);
            if (!this.isAfterHyperMetroDel.booleanValue()) {
                reconnVolumeInfo.setIsHyperMetro(this.isHyperMetro);
            }
            if (this.isDisasterReMappingVols.booleanValue() && OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
                novaMgr.reattachAndCheckVolume(new ReattchParam(this.regionUuid, this.projectUuid, tokenId), this.srcVmUuid, reconnVolumeInfo);
            } else {
                novaMgr.reattachVolume(new ReattchParam(this.regionUuid, this.projectUuid, tokenId), this.srcVmUuid, reconnVolumeInfo);
            }
        }
        return pairInfo;
    }

    @Override
    public int timeOutSecond(List taskList) {
        if (VerifyUtil.isEmpty((Collection)taskList)) {
            return this.getTimeOutForTask(this);
        }
        int timeOutSum = 0;
        for (Object task : taskList) {
            if (!(task instanceof ReattachVolumeTask)) continue;
            timeOutSum += this.getTimeOutForTask((ReattachVolumeTask)task);
        }
        return timeOutSum;
    }

    private int getTimeOutForTask(ReattachVolumeTask reattachVolumeTask) {
        PoReplicaInfo poReplicaInfo = reattachVolumeTask.getReplicaInfo();
        if (!VerifyUtil.isEmpty((Object)poReplicaInfo) && !VerifyUtil.isEmpty((Collection)poReplicaInfo.getPairInfos())) {
            return poReplicaInfo.getPairInfos().size() * 30;
        }
        return 0;
    }

    public Boolean getIsHyperMetro() {
        return this.isHyperMetro;
    }

    public void setIsHyperMetro(Boolean isHyperMetro) {
        this.isHyperMetro = isHyperMetro;
    }

    public Boolean getIsDisasterReMappingVols() {
        return this.isDisasterReMappingVols;
    }

    public void setIsDisasterReMappingVols(Boolean isDisasterReMappingVols) {
        this.isDisasterReMappingVols = isDisasterReMappingVols;
    }

    public PoReplicaInfo getReplicaInfo() {
        return this.replicaInfo;
    }

    public void setAfterHyperMetroDel(Boolean afterHyperMetroDel) {
        this.isAfterHyperMetroDel = afterHyperMetroDel;
    }

    private class ReattachVolumeSubTask
    implements Callable<PoReplicaPairInfo> {
        private INovaManager novaMgr;
        private String tokenId;
        private IVolumeService volumeService;
        private PoReplicaPairInfo pairInfo;

        public ReattachVolumeSubTask(INovaManager novaMgr, String tokenId, IVolumeService volumeService, PoReplicaPairInfo pairInfo) {
            this.novaMgr = novaMgr;
            this.tokenId = tokenId;
            this.volumeService = volumeService;
            this.pairInfo = pairInfo;
        }

        @Override
        public PoReplicaPairInfo call() {
            return ReattachVolumeTask.this.reattachVol(this.novaMgr, this.tokenId, this.volumeService, this.pairInfo);
        }
    }
}

