/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenStackAttachOnePortSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 4694719091326036813L;
    private static Log logger = LogFactory.getInstance(OpenStackAttachOnePortSubProcessor.class);

    public OpenStackAttachOnePortSubProcessor() {
        logger.trace((Object)"OpenStackDetachPortSubProcessor defautl constructor");
    }

    public OpenStackAttachOnePortSubProcessor(String regionUuid, String projectUuid, String portId, String vmName, String vmUuid) {
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projectUuid);
        this.addString("portId", portId);
        this.addString("vmName", vmName);
        this.addString("vmUuid", vmUuid);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String regionUuid = this.getString("regionUuid");
        String projectUuid = this.getString("projUuid");
        String vmName = this.getString("vmName");
        String portId = this.getString("portId");
        String vmUuid = this.getString("vmUuid");
        this.updateProcessNameParams(new String[]{this.getPortName()});
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        try {
            Set<String> curUsePortIdSet = this.getPortsHasAttached();
            if (!VerifyUtil.isEmpty(curUsePortIdSet) && curUsePortIdSet.contains(portId)) {
                logger.info((Object)(portId + " the port has been used by vm currently, vmName=" + vmName));
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
            novaMgr.attachPortToVM(portId, vmUuid, projectUuid, regionUuid, tokenId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("attach port failed:vmName=" + vmName), (Throwable)e);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    private Set<String> getPortsHasAttached() {
        String vmUuid = this.getString("vmUuid");
        String regionUuid = this.getString("regionUuid");
        String projectUuid = this.getString("projUuid");
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        String tokenId = TokenUtil.getInstance().getTokenId(projectUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        HashSet<String> portIdSet = new HashSet<String>();
        List<VMInterface> interfaces = novaMgr.getVmInterfaces(regionUuid, tokenId, projectUuid, vmUuid);
        if (VerifyUtil.isEmpty(interfaces)) {
            return null;
        }
        for (VMInterface vmInterface : interfaces) {
            portIdSet.add(vmInterface.getPortId());
        }
        return portIdSet;
    }

    private String getPortName() {
        return OpenStackRecoveryTool.getPortName(this.getContextRef().getProtectGroup(), this.getString("portId"));
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

