/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.openstack.recovery.processor.AttachVolTaskQueue;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackAttachVolSubProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class OpenStackAttachVolProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -729290830188252874L;
    private static Log logger = LogFactory.getInstance(OpenStackAttachVolProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        logger.info((Object)("enter into OpenStackAttachVolProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        this.generateSubProcessors(context);
        AttachVolTaskQueue attachVolTaskQueue = new AttachVolTaskQueue();
        context.setAttribute("AttachVolTaskQueue", (Object)attachVolTaskQueue);
        attachVolTaskQueue.start();
        ArrayList subProcessorList = new ArrayList();
        subProcessorList.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor excuter = RecoveryProcessConcurrentExecutor.createExecutor(subProcessorList, (boolean)false);
        excuter.process(context);
        attachVolTaskQueue.stop();
        logger.info((Object)("leave OpenStackAttachVolProcessor,recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)));
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return this.getAttachProcExeResult();
    }

    private Boolean getAttachProcExeResult() {
        for (RecoveryProcessor childProc : this.getChildProc()) {
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == childProc.getProcStatus()) continue;
            for (RecoveryProcessor grandsonProc : childProc.getChildProc()) {
                if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == grandsonProc.getProcStatus()) continue;
                logger.info((Object)("grandsonProc is " + grandsonProc.getProcId() + " and ProcDetail is " + grandsonProc.getProcDetail()));
                if ("openstackattachvoltovmprocessor.vol.status.removed".equals(grandsonProc.getProcDetail()) || "openstackattachvoltovmprocessor.vol.status.unportected".equals(grandsonProc.getProcDetail())) continue;
                return false;
            }
        }
        return true;
    }

    private void generateSubProcessors(RecoveryProcessorContext context) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return;
        }
        ProtectGroup pg = context.getProtectGroup();
        boolean isWithinRegionRecovery = PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg);
        String drRegionUuid = isWithinRegionRecovery ? (String)pg.getProps().get("regionId") : (String)pg.getProps().get("drRegionId");
        String drProjUuid = isWithinRegionRecovery ? (String)pg.getProps().get("projectId") : (String)pg.getProps().get("drProjectId");
        HashSet<OpenStackAttachVolSubProcessor> subProcessors = new HashSet<OpenStackAttachVolSubProcessor>();
        for (ProtectObject po : pg.getPolist()) {
            if (OpenStackRecoveryTool.isMigration(context.getRecoveryPlan(), po.getMoUuid())) {
                logger.info((Object)"po:%s is migration,no need do this processor.", new Object[]{po.getName()});
                continue;
            }
            String drVmUuid = OpenStackRecoveryTool.getPoRecoverySetting(context.getRecoveryPlan(), po, "PLACEHOLDVM");
            String replicationInfoStr = po.getProperty("replicationInfo");
            if (isWithinRegionRecovery) {
                drVmUuid = OpenStackRecoveryTool.getPoRecoverySetting(context.getRecoveryPlan(), po, "CSHAPLACEHOLDVM");
                replicationInfoStr = po.getProperty("hypermetor_replicationInfo");
            }
            OpenStackAttachVolSubProcessor subProcessor = new OpenStackAttachVolSubProcessor(po.getUuid(), drVmUuid, drRegionUuid, drProjUuid, replicationInfoStr);
            this.initProc((RecoveryProcessor)subProcessor);
            subProcessors.add(subProcessor);
        }
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

