/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.IDrExtendManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCheckDataConsistencyProcessor;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackCheckRingDataConsistencyProcessor
extends OpenStackCheckDataConsistencyProcessor {
    private static final long serialVersionUID = -6033983210489674659L;
    private static Log logger = LogFactory.getInstance(OpenStackCheckRingDataConsistencyProcessor.class);

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        boolean executeResult = super.execute(context);
        ProtectGroup pg = context.getProtectGroup();
        logger.info((Object)("Enter into OpenStackCheckRingDataConsistencyProcessor.  pg name is :" + pg.getName()));
        if (!executeResult) {
            logger.error((Object)("Execute OpenStackCheckDataConsistencyProcessor Failed pg name is :" + pg.getName()));
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        int result = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue();
        if (!OpenStackCommonUtil.isCsdrVhaMode(pg)) {
            result = this.checkAndSuspendHyperMetro(pg);
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue() == result) {
            logger.error((Object)(pg.getName() + ": suspend HyperMetro FAILED."));
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948906", null);
            return false;
        }
        return true;
    }

    @Override
    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.CheckDataConsistencyProcessor.des");
    }

    private int checkAndSuspendHyperMetro(ProtectGroup pg) {
        DrExtendManager mgr = new DrExtendManager();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String hyperMetorCG = OpenStackRecoveryTool.getHyperProCgUuid(pg);
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        VolumeReplicationCgInfo repCGInfo = mgr.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(hyperMetorCG));
        if (null == repCGInfo) {
            logger.info((Object)(pg.getName() + " :the cg is not exist:cgId=" + hyperMetorCG));
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue();
        }
        String replicationStatus = repCGInfo.getReplicationStatus();
        String status = repCGInfo.getStatus();
        if (!OpenstackEnumDefine.REPLICATION_STATUS_E.AVAILABLE.getValue().equals(status)) {
            logger.error((Object)("replica's status is not avaiable.protectGroupName=" + pg.getName()));
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue();
        }
        if (!OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVE.getValue().equals(replicationStatus)) {
            logger.info((Object)("replica's replicaionstatus is not activity.protectGroupName=" + pg.getName()));
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue();
        }
        String slaveHyperMetorCG = OpenStackRecoveryTool.getSlaveHyperMetorCgUuid(pg);
        repCGInfo = mgr.queryVolumeReplicationCG(regionUuid, tokenId, projUuid, OpenStackCommonUtil.getIdFromUuid(slaveHyperMetorCG));
        if (null == repCGInfo) {
            logger.info((Object)("the cg is not exist:cgId=" + slaveHyperMetorCG + ", protectGroupName=" + pg.getName()));
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue();
        }
        if (OpenstackEnumDefine.REPLICATION_REP_STATUS_E.ACTIVESTOPPED.getValue().equals(repCGInfo.getReplicationStatus())) {
            logger.info((Object)(pg.getName() + " :replica's replicaionstatus is not activity"));
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue();
        }
        boolean result = this.suspendHyperMetro(regionUuid, projUuid, hyperMetorCG);
        if (result) {
            return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue();
        }
        return DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue();
    }

    private boolean suspendHyperMetro(String regionUuid, String projUuid, String hyperMetorCG) {
        IDrExtendManager drExtendMgr = ManagerFactory.getInstance().getDrExtendManager(OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid));
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        hyperMetorCG = OpenStackCommonUtil.getIdFromUuid(hyperMetorCG);
        try {
            AsyncTaskResponse response = drExtendMgr.splitVolumeReplicationCG(regionUuid, tokenId, projUuid, hyperMetorCG);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                logger.info((Object)("set volRepCg(" + hyperMetorCG + ") split failed: errorcode is " + response.getErrorCode()));
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("volRepCg(" + hyperMetorCG + ") fault switch failed."), (Throwable)e);
            return false;
        }
        return true;
    }
}

