/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NeutronManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.msg.VMInterface;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenStackCleanVmTestNetWorkProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -6264264123057800688L;
    private static Log logger = LogFactory.getInstance(OpenStackCleanVmTestNetWorkProcessor.class);

    public OpenStackCleanVmTestNetWorkProcessor() {
    }

    public OpenStackCleanVmTestNetWorkProcessor(String drProjUuid, String drRegionUuid, String testNetWorkUuids, String vmUuid, String oldNetWorkUuids, String vmName) {
        this.addString("projUuid", drProjUuid);
        this.addString("regionUuid", drRegionUuid);
        this.addString("testPortIds", testNetWorkUuids);
        this.addString("vmUuid", vmUuid);
        this.addString("oldPortIds", oldNetWorkUuids);
        this.addString("vmName", vmName);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"enter into OpenStackCleanTestPortSubProcessor");
        String vmName = this.getString("vmName");
        this.updateProcessNameParams(new String[]{vmName});
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.process.no.need", new String[0]);
            return true;
        }
        if (this.detachTestPorts() && this.updateRecoveryPorts()) {
            logger.info((Object)"leave OpenStackCleanTestPortSubProcessor");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        logger.info((Object)"leave OpenStackCleanTestPortSubProcessor");
        return false;
    }

    private boolean detachTestPorts() {
        String drProjUuid = this.getString("projUuid");
        String drRegionUuid = this.getString("regionUuid");
        String testNetWorkUuids = this.getString("testPortIds");
        String vmUuid = this.getString("vmUuid");
        logger.info((Object)("testNetWorkUuids is:" + testNetWorkUuids));
        NovaManager novaMgr = new NovaManager();
        NeutronManager neuMgr = new NeutronManager();
        String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        try {
            List<VMInterface> interfaces = novaMgr.getVmInterfaces(drRegionUuid, tokenId, drProjUuid, vmUuid);
            HashSet<String> vmCurrentInterfaceUuids = new HashSet<String>();
            if (null == interfaces || interfaces.isEmpty()) {
                return true;
            }
            for (VMInterface vmInterface : interfaces) {
                vmCurrentInterfaceUuids.add(OpenStackCommonUtil.getIdFromUuid(vmInterface.getPortId()));
            }
            logger.info((Object)"start detach test Net");
            List<String> testNetWorkUuidList = OpenStackCommonUtil.getListFromStr(testNetWorkUuids, ",");
            for (String portId : testNetWorkUuidList) {
                boolean success = this.handlePort(novaMgr, neuMgr, tokenId, vmCurrentInterfaceUuids, portId);
                if (success) continue;
                return success;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("clean vm(" + vmUuid + ") testNetWork failed."), (Throwable)e);
            this.updateProcessDetail(e);
            return false;
        }
        return true;
    }

    private boolean handlePort(NovaManager novaMgr, NeutronManager neuMgr, String tokenId, Set<String> vmCurrentInterfaceUuids, String portId) {
        String drProjUuid = this.getString("projUuid");
        String drRegionUuid = this.getString("regionUuid");
        String vmUuid = this.getString("vmUuid");
        if (!OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            if (!vmCurrentInterfaceUuids.contains(portId)) {
                AsyncTaskResponse delPortRes = this.deletePort(drRegionUuid, tokenId, portId);
                if (!delPortRes.isSuccess()) {
                    this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                    logger.error((Object)("delete vm(" + vmUuid + ") testPort failed, portId is:" + portId));
                    this.updateProcessDetail("lego.err." + delPortRes.getErrorCode(), null);
                    return false;
                }
            } else {
                AsyncTaskResponse response = novaMgr.detachPortFromVM(portId, vmUuid, drProjUuid, drRegionUuid, tokenId);
                if (!response.isSuccess()) {
                    this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                    logger.error((Object)("clean vm(" + vmUuid + ") testPort failed, portId is:" + portId));
                    this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                    return false;
                }
                AsyncTaskResponse delPortRes = this.deletePort(drRegionUuid, tokenId, portId);
                if (!delPortRes.isSuccess()) {
                    this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                    logger.error((Object)("delete vm(" + vmUuid + ") testPort failed, portId is:" + portId));
                    this.updateProcessDetail("lego.err." + delPortRes.getErrorCode(), null);
                    return false;
                }
            }
        } else {
            neuMgr.updatePortAdminState(drRegionUuid, tokenId, drProjUuid, portId, false);
        }
        return true;
    }

    private AsyncTaskResponse deletePort(String drRegionUuid, String tokenId, String portId) {
        NeutronManager neutronMgr = new NeutronManager();
        return neutronMgr.deletePort(drRegionUuid, tokenId, portId);
    }

    private boolean updateRecoveryPorts() {
        String drProjUuid = this.getString("projUuid");
        String drRegionUuid = this.getString("regionUuid");
        String vmUuid = this.getString("vmUuid");
        String oldNetWorkUuids = this.getString("oldPortIds");
        logger.info((Object)("start attach old Net:" + oldNetWorkUuids));
        NeutronManager neuMgr = new NeutronManager();
        try {
            String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
            List<String> oldNetWorkUuidList = OpenStackCommonUtil.getListFromStr(oldNetWorkUuids, ",");
            for (String portId : oldNetWorkUuidList) {
                portId = OpenStackCommonUtil.getIdFromUuid(portId);
                neuMgr.updatePortAdminState(drRegionUuid, tokenId, drProjUuid, portId, true);
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("clean vm(" + vmUuid + ") testNetWork failed."), (Throwable)e);
            this.updateProcessDetail(e);
            return false;
        }
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

