/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgUpdateInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OpenStackCreateVolCgProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -2871017380190213926L;
    private static Log logger = LogFactory.getInstance(OpenStackCreateVolCgProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"enter into OpenStackCreateVolCgProcessor");
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        this.addString("regionUuid", drRegionUuid);
        this.addString("projUuid", drProjUuid);
        CinderManager cinderMgr = new CinderManager();
        String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
        try {
            logger.info((Object)"start to create volCg");
            AsyncTaskResponse response = this.createVolCg(drRegionUuid, drProjUuid, cinderMgr, tokenId);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                logger.error((Object)("create volCg failed." + response.getErrorCode()));
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                return false;
            }
            logger.info((Object)"start to add vol to volCg");
            Set<String> drVolUuidSet = this.getDrVolUuidSet(context);
            String drVolUuids = OpenStackCommonUtil.getStringFromCollection(drVolUuidSet, ",");
            logger.info((Object)("drVolUuids is:" + drVolUuids));
            VolumeCgUpdateInfo volCgUpdateInfo = new VolumeCgUpdateInfo();
            volCgUpdateInfo.setAddVolUuids(drVolUuids);
            this.addString("volUuid", drVolUuids);
            response = cinderMgr.updateVolumeConsistenceGroup(volCgUpdateInfo, drRegionUuid, tokenId, drProjUuid, this.getString("volCgUuid"));
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                logger.error((Object)("update volCg failed." + response.getErrorCode()));
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("create volCg or update volCg failed." + (Object)((Object)e)));
            this.updateProcessDetail(e);
            return false;
        }
        catch (Exception e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("create volCg or update volCg failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            this.updateProcessDetail("lego.err.1073948913", null);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        logger.info((Object)"out OpenStackCreateVolCgProcessor");
        return true;
    }

    private Set<String> getDrVolUuidSet(RecoveryProcessorContext context) {
        Map<String, String> productVoldToDrVolId = OpenStackRecoveryTool.getProductVolIdToDrVolId(context.getRecoveryPlan());
        HashSet<String> drVolUuidSet = new HashSet<String>();
        for (Map.Entry<String, String> entry : productVoldToDrVolId.entrySet()) {
            String drVolUuid = entry.getValue();
            if (VerifyUtil.isEmpty((String)drVolUuid)) {
                logger.warn((Object)("vol has no drvol:" + entry.getKey()));
                continue;
            }
            drVolUuidSet.add(OpenStackCommonUtil.getIdFromUuid(drVolUuid));
        }
        return drVolUuidSet;
    }

    private AsyncTaskResponse createVolCg(String drRegionUuid, String drProjUuid, CinderManager cinderMgr, String tokenId) {
        VolumeCgCreateInfo volCgCreateInfo = new VolumeCgCreateInfo();
        HashSet<String> volumeTypes = new HashSet<String>();
        for (ProtectObject po : this.getContextRef().getProtectGroup().getPolist()) {
            PoReplicaInfo replicaInfo = JsonUtil.jsonToBean((String)po.getProps().get("replicationInfo"), PoReplicaInfo.class);
            if (replicaInfo == null) continue;
            for (PoReplicaPairInfo pairInfo : replicaInfo.getPairInfos()) {
                volumeTypes.add(pairInfo.getDrVolumeType());
            }
        }
        volCgCreateInfo.setVolumeTypes(OpenStackCommonUtil.getStringFromCollection(volumeTypes, ","));
        AsyncTaskResponse response = cinderMgr.createVolumeConsistenceGroup(volCgCreateInfo, drRegionUuid, tokenId, drProjUuid);
        if (response.getTaskResult() != null && response.getTaskResult() instanceof VolumeCgInfo) {
            VolumeCgInfo volcg = (VolumeCgInfo)response.getTaskResult();
            this.addString("volCgUuid", volcg.getId());
        }
        return response;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

