/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolCgProcessor;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgSnapShotCreateInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgSnapShotInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackCreateVolCgSnapshotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -349245366211801342L;
    private static Log logger = LogFactory.getInstance(OpenStackCreateVolCgSnapshotProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"enter into OpenStackCreateVolRepCgSnapshotProcessor");
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        ProtectGroup pg = context.getProtectGroup();
        String drRegionUuid = (String)pg.getProps().get("drRegionId");
        String drProjUuid = (String)pg.getProps().get("drProjectId");
        this.addString("regionUuid", drRegionUuid);
        this.addString("projUuid", drProjUuid);
        try {
            String volCgId = this.getVolCgIdFromProcessor();
            CinderManager cinderMgr = new CinderManager();
            String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
            AsyncTaskResponse response = this.createVolCgSnapShot(drRegionUuid, drProjUuid, cinderMgr, tokenId, volCgId);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                logger.error((Object)("create volCgSnapShot failed." + response.getErrorCode()));
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("create volCgSnapShot failed." + (Object)((Object)e)));
            this.updateProcessDetail(e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        logger.info((Object)"leave OpenStackCreateVolRepCgSnapshotProcessor");
        return true;
    }

    private String getVolCgIdFromProcessor() {
        OpenStackCreateVolCgProcessor processor = (OpenStackCreateVolCgProcessor)this.getPreviousProcessor();
        return processor.getString("volCgUuid");
    }

    private AsyncTaskResponse createVolCgSnapShot(String drRegionUuid, String drProjUuid, CinderManager cinderMgr, String tokenId, String volCgId) {
        VolumeCgSnapShotCreateInfo createCgInfo = new VolumeCgSnapShotCreateInfo(volCgId);
        AsyncTaskResponse response = cinderMgr.createVolCgSnapShot(createCgInfo, drRegionUuid, tokenId, drProjUuid);
        if (response.getTaskResult() != null && response.getTaskResult() instanceof VolumeCgSnapShotInfo) {
            VolumeCgSnapShotInfo volRepSnapShot = (VolumeCgSnapShotInfo)response.getTaskResult();
            this.addString("volCgSnapShotId", volRepSnapShot.getId());
        }
        return response;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

