/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.msg.CreateVolumeSnapShotInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeSnapShotInfo;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;

public class OpenStackCreateVolSnapshotSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 565923070721728856L;
    private static Log logger = LogFactory.getInstance(OpenStackCreateVolSnapshotSubProcessor.class);

    public OpenStackCreateVolSnapshotSubProcessor() {
    }

    public OpenStackCreateVolSnapshotSubProcessor(String regionUuid, String projUuid, String volUuid, String volName) {
        this.addString("regionUuid", regionUuid);
        this.addString("projUuid", projUuid);
        this.addString("volUuid", volUuid);
        this.addString("volName", volName);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"enter into OpenStackCreateVolSnapshotSubProcessor");
        this.updateProcessNameParams(new String[]{this.getString("volName")});
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        String drRegionUuid = this.getString("regionUuid");
        String drProjUuid = this.getString("projUuid");
        String drVolUuid = this.getString("volUuid");
        try {
            String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
            AsyncTaskResponse response = this.createVolSnapShot(drRegionUuid, drProjUuid, tokenId, drVolUuid);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                logger.error((Object)("create volSnapShot failed. volId: " + drVolUuid));
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.error((Object)("create volSnapShot failed." + (Object)((Object)e)));
            this.updateProcessDetail(e);
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        logger.info((Object)"leave OpenStackCreateVolSnapshotSubProcessor");
        return true;
    }

    private AsyncTaskResponse createVolSnapShot(String drRegionUuid, String drProjUuid, String tokenId, String volUuid) {
        CinderManager cinderMgr = new CinderManager();
        CreateVolumeSnapShotInfo createCgInfo = new CreateVolumeSnapShotInfo();
        createCgInfo.setForce(Boolean.valueOf(true));
        String volId = OpenStackCommonUtil.getIdFromUuid(volUuid);
        createCgInfo.setVolumeId(volId);
        JSONObject metadata = new JSONObject();
        metadata.put((Object)"__system__enableActive", (Object)"false");
        createCgInfo.setMetadata(metadata);
        createCgInfo.setName("dr_snapshot_csdr_" + volId);
        logger.info((Object)("start create volume snapshot, volumeId:" + volId));
        AsyncTaskResponse response = cinderMgr.createVolSnapshot(drRegionUuid, drProjUuid, tokenId, createCgInfo);
        if (response.getTaskResult() != null && response.getTaskResult() instanceof VolumeSnapShotInfo) {
            VolumeSnapShotInfo volSnapShot = (VolumeSnapShotInfo)response.getTaskResult();
            logger.info((Object)("create volume snapshot, volSnapShotId:" + volSnapShot.getId()));
            this.addString("volSnapShotUuid", volSnapShot.getId());
            this.addString("volUuid", volUuid);
            this.addString("providerAuth", volSnapShot.getProviderAuth());
        }
        return response;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

