/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.adapter.manager.impl.NovaManager;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackDcStatusCheck;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class OpenStackDcNovaStatusCheckProcessor
extends OpenStackDcStatusCheck {
    private static final long serialVersionUID = -6687214803477677538L;
    private static final Log logger = LogFactory.getInstance(OpenStackDcNovaStatusCheckProcessor.class);
    private static final String VMUUID = "61a9308f-f99e-4e32-945e-5f4a78bfa957";
    private transient NovaManager novaManager;

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        boolean checkServerStatus = this.checkServerStatus(context);
        if (checkServerStatus) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            logger.info((Object)("leave OpenStackDcNovaStatusCheckProcessor:check successed.recoveryPlan name=" + (recoveryPlan != null ? recoveryPlan.getName() : "")));
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
        this.updateProcessDetail("com.huawei.ism.drm.openstack.recovery.processor.dc.check.error", new String[0]);
        logger.info((Object)("leave OpenStackDcNovaStatusCheckProcessor:check failed.recoveryPlan name=" + (recoveryPlan != null ? recoveryPlan.getName() : "")));
        return false;
    }

    @Override
    protected boolean checkSingleStatus(String regionUuid, String projUuid, String tokenId) {
        try {
            if (this.novaManager == null) {
                this.novaManager = new NovaManager();
            }
            this.novaManager.getVm(regionUuid, tokenId, projUuid, VMUUID, new int[0]);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1073947401L || e.getErrorCode() == 1073947398L) {
                logger.error((Object)("OpenStackDcNovaStatusCheckProcessor getVm ( " + regionUuid + " ," + projUuid + " ," + VMUUID + " ) failed."), (Throwable)e);
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)("OpenStackDcNovaStatusCheckProcessor getVm ( " + regionUuid + " ," + projUuid + " ," + VMUUID + " ) other exception."));
        }
        return true;
    }
}

