/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public abstract class OpenStackDcStatusCheck
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -3774411872989746782L;
    private static final Log logger = LogFactory.getInstance(OpenStackDcStatusCheck.class);
    private static final long CHECK_PERIOD = 180000L;
    private static final long SLEEP_TIME = 1000L;

    protected boolean checkServerStatus(RecoveryProcessorContext context) {
        long beginTime;
        ProtectGroup pg = context.getProtectGroup();
        boolean check = PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(pg);
        String drRegionUuid = pg.getProperty(check ? "regionId" : "drRegionId");
        String drProjUuid = pg.getProperty(check ? "projectId" : "drProjectId");
        long endTime = beginTime = System.currentTimeMillis();
        while (endTime - beginTime <= 180000L) {
            String tokenId;
            try {
                tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"checkServerStatus getTokenId failed.");
                CommUtil.pauseThread((long)1000L);
                endTime = System.currentTimeMillis();
                continue;
            }
            boolean isNormal = this.checkSingleStatus(drRegionUuid, drProjUuid, tokenId);
            if (isNormal) {
                return true;
            }
            CommUtil.pauseThread((long)1000L);
            endTime = System.currentTimeMillis();
        }
        return false;
    }

    protected abstract boolean checkSingleStatus(String var1, String var2, String var3);

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

