/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.manager.impl.CinderManager;
import com.huawei.ism.drm.openstack.adapter.msg.AsyncTaskResponse;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.recovery.processor.OpenStackCreateVolCgSnapshotProcessor;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeCgSnapShotInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;

public class OpenStackDelVolCgSnapShotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -8499070800369388069L;
    private static Log logger = LogFactory.getInstance(OpenStackDelVolCgSnapShotProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"enter into OpenStackDelVolRepCgSnapShotProcessor");
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        List createProcessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue()), OpenStackCreateVolCgSnapshotProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        OpenStackCreateVolCgSnapshotProcessor createVolCgSnapShotProcessor = (OpenStackCreateVolCgSnapshotProcessor)((Object)CommonUtil.getFirstElement((Collection)createProcessors));
        String volCgSnapShotUuid = createVolCgSnapShotProcessor.getString("volCgSnapShotId");
        String drRegionUuid = createVolCgSnapShotProcessor.getString("regionUuid");
        String drProjUuid = createVolCgSnapShotProcessor.getString("projUuid");
        if (VerifyUtil.isEmpty((String)volCgSnapShotUuid)) {
            logger.info((Object)"volCgSnapShotUuid is null.no need to delete cg snapshot.");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        try {
            CinderManager cinderMgr = new CinderManager();
            String tokenId = TokenUtil.getInstance().getTokenId(drProjUuid);
            VolumeCgSnapShotInfo volCgSnapShot = cinderMgr.queryVolCgSnapShot(drRegionUuid, tokenId, drProjUuid, volCgSnapShotUuid);
            if (null == volCgSnapShot) {
                logger.info((Object)("volCgSnapShot(" + volCgSnapShotUuid + ") doesn't exit."));
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
            AsyncTaskResponse response = cinderMgr.deleteVolCgSnapShot(volCgSnapShotUuid, drRegionUuid, tokenId, drProjUuid);
            if (!response.isSuccess()) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                this.updateProcessDetail("lego.err." + response.getErrorCode(), null);
                return false;
            }
        }
        catch (LegoCheckedException e) {
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            logger.info((Object)("del volRepCgSnapshot(" + volCgSnapShotUuid + ")failed." + (Object)((Object)e)));
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        logger.info((Object)"leave OpenStackDelVolRepCgSnapShotProcessor");
        return true;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

